/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.rmi;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jndi.JndiAccessor;

public class JndiRmiServiceExporter
extends JndiAccessor
implements InitializingBean,
DisposableBean {
    private Remote service;
    private String jndiName;

    public void setService(Remote service) {
        this.service = service;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public void afterPropertiesSet() throws NamingException, RemoteException {
        if (this.jndiName == null) {
            throw new IllegalArgumentException("jndiName is required");
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Binding RMI service to JNDI location [" + this.jndiName + "]"));
        }
        PortableRemoteObject.exportObject((Remote)this.service);
        this.getJndiTemplate().rebind(this.jndiName, (Object)this.service);
    }

    public void destroy() throws NamingException, NoSuchObjectException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Unbinding RMI service from JNDI location [" + this.jndiName + "]"));
        }
        this.getJndiTemplate().unbind(this.jndiName);
        PortableRemoteObject.unexportObject((Remote)this.service);
    }
}

