/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jca.cci.core;

import java.sql.SQLException;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.IndexedRecord;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.MappedRecord;
import javax.resource.cci.Record;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResultSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jca.cci.CannotCreateRecordException;
import org.springframework.jca.cci.CciOperationNotSupportedException;
import org.springframework.jca.cci.InvalidResultSetAccessException;
import org.springframework.jca.cci.RecordTypeNotSupportedException;
import org.springframework.jca.cci.connection.ConnectionFactoryUtils;
import org.springframework.jca.cci.core.CciOperations;
import org.springframework.jca.cci.core.ConnectionCallback;
import org.springframework.jca.cci.core.InteractionCallback;
import org.springframework.jca.cci.core.RecordCreator;
import org.springframework.jca.cci.core.RecordExtractor;

public class CciTemplate
implements CciOperations {
    private final Log logger = LogFactory.getLog(this.getClass());
    private ConnectionFactory connectionFactory;
    private RecordCreator outputRecordCreator;

    public CciTemplate() {
    }

    public CciTemplate(ConnectionFactory connectionFactory) {
        this.setConnectionFactory(connectionFactory);
        this.afterPropertiesSet();
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setOutputRecordCreator(RecordCreator creator) {
        this.outputRecordCreator = creator;
    }

    public RecordCreator getOutputRecordCreator() {
        return this.outputRecordCreator;
    }

    public void afterPropertiesSet() {
        if (this.getConnectionFactory() == null) {
            throw new IllegalArgumentException("connectionFactory is required");
        }
    }

    public Object execute(ConnectionCallback action) throws DataAccessException {
        Connection connection = ConnectionFactoryUtils.getConnection(this.getConnectionFactory());
        try {
            Object object = action.doInConnection(connection, this.getConnectionFactory());
            return object;
        }
        catch (NotSupportedException ex) {
            throw new CciOperationNotSupportedException("CCI operation not supported by connector", (ResourceException)((Object)ex));
        }
        catch (ResourceException ex) {
            throw new DataAccessResourceFailureException("CCI operation failed", (Throwable)ex);
        }
        catch (SQLException ex) {
            throw new InvalidResultSetAccessException("Parsing of CCI ResultSet failed", ex);
        }
        finally {
            ConnectionFactoryUtils.releaseConnection(connection, this.getConnectionFactory());
        }
    }

    public Object execute(final InteractionCallback action) throws DataAccessException {
        return this.execute(new ConnectionCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInConnection(Connection connection, ConnectionFactory connectionFactory) throws ResourceException, SQLException, DataAccessException {
                Interaction interaction = connection.createInteraction();
                try {
                    Object object = action.doInInteraction(interaction, connectionFactory);
                    return object;
                }
                finally {
                    CciTemplate.this.closeInteraction(interaction);
                }
            }
        });
    }

    public Record execute(InteractionSpec spec, Record inputRecord) throws DataAccessException {
        return (Record)this.doExecute(spec, inputRecord, null, null);
    }

    public void execute(InteractionSpec spec, Record inputRecord, Record outputRecord) throws DataAccessException {
        this.doExecute(spec, inputRecord, outputRecord, null);
    }

    public Record execute(InteractionSpec spec, RecordCreator inputCreator) throws DataAccessException {
        return (Record)this.doExecute(spec, this.createRecord(inputCreator), null, null);
    }

    public Object execute(InteractionSpec spec, Record inputRecord, RecordExtractor outputExtractor) throws DataAccessException {
        return this.doExecute(spec, inputRecord, null, outputExtractor);
    }

    public Object execute(InteractionSpec spec, RecordCreator inputCreator, RecordExtractor outputExtractor) throws DataAccessException {
        return this.doExecute(spec, this.createRecord(inputCreator), null, outputExtractor);
    }

    protected Object doExecute(final InteractionSpec spec, final Record inputRecord, final Record outputRecord, final RecordExtractor outputExtractor) throws DataAccessException {
        return this.execute(new InteractionCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInInteraction(Interaction interaction, ConnectionFactory connectionFactory) throws ResourceException, SQLException, DataAccessException {
                Record outputRecordToUse = outputRecord;
                try {
                    Object object;
                    if (outputRecord != null || CciTemplate.this.getOutputRecordCreator() != null) {
                        if (outputRecord == null) {
                            RecordFactory recordFactory = CciTemplate.this.getConnectionFactory().getRecordFactory();
                            outputRecordToUse = CciTemplate.this.getOutputRecordCreator().createRecord(recordFactory);
                        }
                        interaction.execute(spec, inputRecord, outputRecordToUse);
                    } else {
                        outputRecordToUse = interaction.execute(spec, inputRecord);
                    }
                    if (outputExtractor != null) {
                        object = outputExtractor.extractData(outputRecordToUse);
                        return object;
                    }
                    object = outputRecordToUse;
                    return object;
                }
                finally {
                    if (outputRecordToUse instanceof ResultSet) {
                        CciTemplate.this.closeResultSet((ResultSet)outputRecordToUse);
                    }
                }
            }
        });
    }

    public IndexedRecord createIndexedRecord(String name) throws DataAccessException {
        try {
            RecordFactory factory = this.getConnectionFactory().getRecordFactory();
            return factory.createIndexedRecord(name);
        }
        catch (NotSupportedException ex) {
            throw new RecordTypeNotSupportedException("Creation of indexed Record not supported by connector", (ResourceException)((Object)ex));
        }
        catch (ResourceException ex) {
            throw new CannotCreateRecordException("Creation of indexed Record failed", ex);
        }
    }

    public MappedRecord createMappedRecord(String name) throws DataAccessException {
        try {
            RecordFactory factory = this.getConnectionFactory().getRecordFactory();
            return factory.createMappedRecord(name);
        }
        catch (NotSupportedException ex) {
            throw new RecordTypeNotSupportedException("Creation of mapped Record not supported by connector", (ResourceException)((Object)ex));
        }
        catch (ResourceException ex) {
            throw new CannotCreateRecordException("Creation of mapped Record failed", ex);
        }
    }

    protected Record createRecord(RecordCreator recordCreator) throws DataAccessException {
        try {
            RecordFactory recordFactory = this.getConnectionFactory().getRecordFactory();
            return recordCreator.createRecord(recordFactory);
        }
        catch (NotSupportedException ex) {
            throw new RecordTypeNotSupportedException("Creation of the desired Record type not supported by connector", (ResourceException)((Object)ex));
        }
        catch (ResourceException ex) {
            throw new CannotCreateRecordException("Creation of the desired Record failed", ex);
        }
    }

    private void closeInteraction(Interaction interaction) {
        if (interaction != null) {
            try {
                interaction.close();
            }
            catch (ResourceException ex) {
                this.logger.warn((Object)"Could not close Interaction", (Throwable)ex);
            }
        }
    }

    private void closeResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException ex) {
                this.logger.warn((Object)"Could not close ResultSet", (Throwable)ex);
            }
        }
    }
}

