/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.access;

import javax.management.JMException;
import org.aopalliance.intercept.Interceptor;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jmx.access.MBeanClientInterceptor;

public class MBeanProxyFactoryBean
extends MBeanClientInterceptor
implements FactoryBean,
InitializingBean {
    private Class proxyInterface;
    private Object mbeanProxy;

    public void setProxyInterface(Class managementInterface) {
        this.proxyInterface = managementInterface;
    }

    public void afterPropertiesSet() throws JMException {
        super.afterPropertiesSet();
        if (this.proxyInterface == null) {
            throw new IllegalArgumentException("proxyInterface is required");
        }
        this.mbeanProxy = ProxyFactory.getProxy((Class)this.proxyInterface, (Interceptor)this);
    }

    public Object getObject() {
        return this.mbeanProxy;
    }

    public Class getObjectType() {
        return this.mbeanProxy != null ? this.mbeanProxy.getClass() : null;
    }

    public boolean isSingleton() {
        return true;
    }
}

