/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.chart;

import java.awt.Color;
import java.util.Map;
import org.knowm.xchart.PieChart;
import org.knowm.xchart.PieSeries;
import org.knowm.xchart.style.PieStyler;
import org.knowm.xchart.style.Styler;
import tech.grasshopper.pdf.chart.CustomStyler;
import tech.grasshopper.pdf.chart.DonutChartSeriesData;

public class ReportDonutChart
extends PieChart
implements CustomStyler,
DonutChartSeriesData {
    private Color[] sliceColors = new Color[]{Color.GREEN, Color.RED, Color.ORANGE};

    public ReportDonutChart(int width, int height) {
        super(width, height, Styler.ChartTheme.XChart);
        this.updateStyler();
    }

    @Override
    public void updateStyler() {
        PieStyler styler = (PieStyler)this.getStyler();
        styler.setLegendVisible(false);
        styler.setPlotContentSize(1.0);
        styler.setPlotBorderVisible(false);
        styler.setChartPadding(0);
        styler.setClockwiseDirectionType(PieStyler.ClockwiseDirectionType.CLOCKWISE);
        styler.setSeriesColors(this.sliceColors);
        styler.setHasAnnotations(false);
        styler.setDefaultSeriesRenderStyle(PieSeries.PieSeriesRenderStyle.Donut);
        styler.setSumVisible(true);
        styler.setDecimalPattern("#");
    }

    @Override
    public void updateData(Map<String, Number> data) {
        this.addSeries("Passed", data.getOrDefault("Passed", 0));
        this.addSeries("Failed", data.getOrDefault("Failed", 0));
        this.addSeries("Skipped", data.getOrDefault("Skipped", 0));
    }
}

