/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.optimizer;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.util.PdfUtil;

public class TextLengthOptimizer {
    private PDFont font;
    private int fontsize;
    private float availableSpace;
    private int maxLines;
    private boolean textTrimmed;

    public boolean doesTextFitInSpace(String text) {
        return !(PdfUtil.getStringWidth((String)text, (PDFont)this.font, (int)this.fontsize) > this.availableSpace);
    }

    public String optimizeText(String text) {
        if (this.doesTextFitInSpace(text)) {
            this.textTrimmed = false;
            return text;
        }
        this.textTrimmed = true;
        text = text.substring(0, text.length() - 2);
        while (!this.doesTextFitInSpace(new StringBuffer(text).append("*").toString())) {
            text = text.substring(0, text.length() - 1);
        }
        return text + "*";
    }

    public String optimizeTextLines(String text) {
        List lines = PdfUtil.getOptimalTextBreakLines((String)text, (PDFont)this.font, (int)this.fontsize, (float)this.availableSpace);
        if (lines.size() > this.maxLines) {
            this.textTrimmed = true;
            if (PdfUtil.getOptimalTextBreakLines((String)((String)lines.get(this.maxLines - 1) + " *"), (PDFont)this.font, (int)this.fontsize, (float)this.availableSpace).size() > 1) {
                int length = ((String)lines.get(this.maxLines - 1)).length();
                lines.set(this.maxLines - 1, ((String)lines.get(this.maxLines - 1)).substring(0, length - 3) + " *");
            } else {
                lines.set(this.maxLines - 1, (String)lines.get(this.maxLines - 1) + " *");
            }
        } else {
            this.textTrimmed = false;
            return text;
        }
        return lines.subList(0, this.maxLines).stream().collect(Collectors.joining(" "));
    }

    public static String optimizeOutlineText(String text) {
        return TextLengthOptimizer.optimizeTextLength(text, 50);
    }

    private static String optimizeTextLength(String text, int length) {
        if (text.length() > length) {
            return text.substring(0, length - 3) + " *";
        }
        return text;
    }

    private static int $default$maxLines() {
        return 1;
    }

    private static boolean $default$textTrimmed() {
        return false;
    }

    TextLengthOptimizer(PDFont font, int fontsize, float availableSpace, int maxLines, boolean textTrimmed) {
        this.font = font;
        this.fontsize = fontsize;
        this.availableSpace = availableSpace;
        this.maxLines = maxLines;
        this.textTrimmed = textTrimmed;
    }

    public static TextLengthOptimizerBuilder builder() {
        return new TextLengthOptimizerBuilder();
    }

    public void setFont(PDFont font) {
        this.font = font;
    }

    public void setFontsize(int fontsize) {
        this.fontsize = fontsize;
    }

    public void setAvailableSpace(float availableSpace) {
        this.availableSpace = availableSpace;
    }

    public void setMaxLines(int maxLines) {
        this.maxLines = maxLines;
    }

    public boolean isTextTrimmed() {
        return this.textTrimmed;
    }

    public static class TextLengthOptimizerBuilder {
        private PDFont font;
        private int fontsize;
        private float availableSpace;
        private boolean maxLines$set;
        private int maxLines$value;
        private boolean textTrimmed$set;
        private boolean textTrimmed$value;

        TextLengthOptimizerBuilder() {
        }

        public TextLengthOptimizerBuilder font(PDFont font) {
            this.font = font;
            return this;
        }

        public TextLengthOptimizerBuilder fontsize(int fontsize) {
            this.fontsize = fontsize;
            return this;
        }

        public TextLengthOptimizerBuilder availableSpace(float availableSpace) {
            this.availableSpace = availableSpace;
            return this;
        }

        public TextLengthOptimizerBuilder maxLines(int maxLines) {
            this.maxLines$value = maxLines;
            this.maxLines$set = true;
            return this;
        }

        public TextLengthOptimizerBuilder textTrimmed(boolean textTrimmed) {
            this.textTrimmed$value = textTrimmed;
            this.textTrimmed$set = true;
            return this;
        }

        public TextLengthOptimizer build() {
            int maxLines$value = this.maxLines$value;
            if (!this.maxLines$set) {
                maxLines$value = TextLengthOptimizer.$default$maxLines();
            }
            boolean textTrimmed$value = this.textTrimmed$value;
            if (!this.textTrimmed$set) {
                textTrimmed$value = TextLengthOptimizer.$default$textTrimmed();
            }
            return new TextLengthOptimizer(this.font, this.fontsize, this.availableSpace, maxLines$value, textTrimmed$value);
        }

        public String toString() {
            return "TextLengthOptimizer.TextLengthOptimizerBuilder(font=" + this.font + ", fontsize=" + this.fontsize + ", availableSpace=" + this.availableSpace + ", maxLines$value=" + this.maxLines$value + ", textTrimmed$value=" + this.textTrimmed$value + ")";
        }
    }
}

