/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.details.executable;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.ImageCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.pdf.annotation.FileAnnotation;
import tech.grasshopper.pdf.pojo.cucumber.Executable;
import tech.grasshopper.pdf.structure.cell.TableWithinTableCell;
import tech.grasshopper.pdf.structure.cell.TextFileLinkCell;

public class MediaDisplay {
    private Executable executable;
    private PDDocument document;
    private boolean attachView;
    private static final int MAX_MEDIA_COUNT_PER_ROW = 4;

    public AbstractCell display() {
        int i;
        List<String> medias = this.executable.getMedia();
        float mediaWidth = 125.0f;
        float mediaHeigth = 125.0f;
        float plusWidth = 15.0f;
        float padding = 2.0f;
        Table.TableBuilder mediaTableBuilder = Table.builder();
        Row.RowBuilder rowBuilder = null;
        for (i = 0; i < 4; ++i) {
            mediaTableBuilder.addColumnsOfWidth(new float[]{mediaWidth, plusWidth});
        }
        for (i = 0; i < medias.size(); ++i) {
            if (i % 4 == 0) {
                if (rowBuilder != null) {
                    mediaTableBuilder.addRow(rowBuilder.build());
                }
                rowBuilder = Row.builder();
            }
            PDImageXObject image = PDImageXObject.createFromFile((String)medias.get(i), (PDDocument)this.document);
            rowBuilder.add((AbstractCell)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)ImageCell.builder().image(image).width(mediaWidth)).padding(padding)).maxHeight(mediaHeigth).build());
            if (this.attachView) {
                ArrayList<FileAnnotation> annotations = new ArrayList<FileAnnotation>();
                annotations.add(FileAnnotation.builder().text(" ").link(medias.get(i)).build());
                rowBuilder.add((AbstractCell)((TextFileLinkCell.TextFileLinkCellBuilder)TextFileLinkCell.builder().text(" ")).annotations(annotations).build());
                this.executable.addAttachAnnotation((FileAnnotation)annotations.get(0));
                continue;
            }
            rowBuilder.add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text("").fontSize(Integer.valueOf(0))).padding(0.0f)).build());
        }
        if (medias.size() % 4 > 0) {
            for (i = 0; i < 4 - medias.size() % 4; ++i) {
                rowBuilder.add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("").fontSize(Integer.valueOf(0))).build());
                rowBuilder.add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("").fontSize(Integer.valueOf(0))).build());
            }
        }
        mediaTableBuilder.addRow(rowBuilder.build());
        return ((TableWithinTableCell.TableWithinTableCellBuilder)((TableWithinTableCell.TableWithinTableCellBuilder)TableWithinTableCell.builder().table(mediaTableBuilder.build()).borderColor(Color.GRAY)).borderWidth(1.0f)).build();
    }

    MediaDisplay(Executable executable, PDDocument document, boolean attachView) {
        this.executable = executable;
        this.document = document;
        this.attachView = attachView;
    }

    public static MediaDisplayBuilder builder() {
        return new MediaDisplayBuilder();
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public PDDocument getDocument() {
        return this.document;
    }

    public boolean isAttachView() {
        return this.attachView;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MediaDisplay)) {
            return false;
        }
        MediaDisplay other = (MediaDisplay)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAttachView() != other.isAttachView()) {
            return false;
        }
        Executable this$executable = this.getExecutable();
        Executable other$executable = other.getExecutable();
        if (this$executable == null ? other$executable != null : !((Object)this$executable).equals(other$executable)) {
            return false;
        }
        PDDocument this$document = this.getDocument();
        PDDocument other$document = other.getDocument();
        return !(this$document == null ? other$document != null : !this$document.equals(other$document));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MediaDisplay;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAttachView() ? 79 : 97);
        Executable $executable = this.getExecutable();
        result = result * 59 + ($executable == null ? 43 : ((Object)$executable).hashCode());
        PDDocument $document = this.getDocument();
        result = result * 59 + ($document == null ? 43 : $document.hashCode());
        return result;
    }

    public String toString() {
        return "MediaDisplay(executable=" + this.getExecutable() + ", document=" + this.getDocument() + ", attachView=" + this.isAttachView() + ")";
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    public void setDocument(PDDocument document) {
        this.document = document;
    }

    public void setAttachView(boolean attachView) {
        this.attachView = attachView;
    }

    public static class MediaDisplayBuilder {
        private Executable executable;
        private PDDocument document;
        private boolean attachView;

        MediaDisplayBuilder() {
        }

        public MediaDisplayBuilder executable(Executable executable) {
            this.executable = executable;
            return this;
        }

        public MediaDisplayBuilder document(PDDocument document) {
            this.document = document;
            return this;
        }

        public MediaDisplayBuilder attachView(boolean attachView) {
            this.attachView = attachView;
            return this;
        }

        public MediaDisplay build() {
            return new MediaDisplay(this.executable, this.document, this.attachView);
        }

        public String toString() {
            return "MediaDisplay.MediaDisplayBuilder(executable=" + this.executable + ", document=" + this.document + ", attachView=" + this.attachView + ")";
        }
    }
}

