/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.data;

import java.time.Duration;
import java.time.LocalDateTime;
import tech.grasshopper.pdf.data.DisplayData;

public class DashboardData
implements DisplayData {
    private LocalDateTime testRunStartTime;
    private LocalDateTime testRunEndTime;
    private int passedFeatures;
    private int failedFeatures;
    private int skippedFeatures;
    private int totalFeatures;
    private int passedScenarios;
    private int failedScenarios;
    private int skippedScenarios;
    private int totalScenarios;
    private int passedSteps;
    private int failedSteps;
    private int skippedSteps;
    private int totalSteps;

    public Duration getTestRunDuration() {
        return Duration.between(this.testRunStartTime, this.testRunEndTime);
    }

    DashboardData(LocalDateTime testRunStartTime, LocalDateTime testRunEndTime, int passedFeatures, int failedFeatures, int skippedFeatures, int totalFeatures, int passedScenarios, int failedScenarios, int skippedScenarios, int totalScenarios, int passedSteps, int failedSteps, int skippedSteps, int totalSteps) {
        this.testRunStartTime = testRunStartTime;
        this.testRunEndTime = testRunEndTime;
        this.passedFeatures = passedFeatures;
        this.failedFeatures = failedFeatures;
        this.skippedFeatures = skippedFeatures;
        this.totalFeatures = totalFeatures;
        this.passedScenarios = passedScenarios;
        this.failedScenarios = failedScenarios;
        this.skippedScenarios = skippedScenarios;
        this.totalScenarios = totalScenarios;
        this.passedSteps = passedSteps;
        this.failedSteps = failedSteps;
        this.skippedSteps = skippedSteps;
        this.totalSteps = totalSteps;
    }

    public static DashboardDataBuilder builder() {
        return new DashboardDataBuilder();
    }

    public LocalDateTime getTestRunStartTime() {
        return this.testRunStartTime;
    }

    public LocalDateTime getTestRunEndTime() {
        return this.testRunEndTime;
    }

    public int getPassedFeatures() {
        return this.passedFeatures;
    }

    public int getFailedFeatures() {
        return this.failedFeatures;
    }

    public int getSkippedFeatures() {
        return this.skippedFeatures;
    }

    public int getTotalFeatures() {
        return this.totalFeatures;
    }

    public int getPassedScenarios() {
        return this.passedScenarios;
    }

    public int getFailedScenarios() {
        return this.failedScenarios;
    }

    public int getSkippedScenarios() {
        return this.skippedScenarios;
    }

    public int getTotalScenarios() {
        return this.totalScenarios;
    }

    public int getPassedSteps() {
        return this.passedSteps;
    }

    public int getFailedSteps() {
        return this.failedSteps;
    }

    public int getSkippedSteps() {
        return this.skippedSteps;
    }

    public int getTotalSteps() {
        return this.totalSteps;
    }

    public void setTestRunStartTime(LocalDateTime testRunStartTime) {
        this.testRunStartTime = testRunStartTime;
    }

    public void setTestRunEndTime(LocalDateTime testRunEndTime) {
        this.testRunEndTime = testRunEndTime;
    }

    public void setPassedFeatures(int passedFeatures) {
        this.passedFeatures = passedFeatures;
    }

    public void setFailedFeatures(int failedFeatures) {
        this.failedFeatures = failedFeatures;
    }

    public void setSkippedFeatures(int skippedFeatures) {
        this.skippedFeatures = skippedFeatures;
    }

    public void setTotalFeatures(int totalFeatures) {
        this.totalFeatures = totalFeatures;
    }

    public void setPassedScenarios(int passedScenarios) {
        this.passedScenarios = passedScenarios;
    }

    public void setFailedScenarios(int failedScenarios) {
        this.failedScenarios = failedScenarios;
    }

    public void setSkippedScenarios(int skippedScenarios) {
        this.skippedScenarios = skippedScenarios;
    }

    public void setTotalScenarios(int totalScenarios) {
        this.totalScenarios = totalScenarios;
    }

    public void setPassedSteps(int passedSteps) {
        this.passedSteps = passedSteps;
    }

    public void setFailedSteps(int failedSteps) {
        this.failedSteps = failedSteps;
    }

    public void setSkippedSteps(int skippedSteps) {
        this.skippedSteps = skippedSteps;
    }

    public void setTotalSteps(int totalSteps) {
        this.totalSteps = totalSteps;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DashboardData)) {
            return false;
        }
        DashboardData other = (DashboardData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPassedFeatures() != other.getPassedFeatures()) {
            return false;
        }
        if (this.getFailedFeatures() != other.getFailedFeatures()) {
            return false;
        }
        if (this.getSkippedFeatures() != other.getSkippedFeatures()) {
            return false;
        }
        if (this.getTotalFeatures() != other.getTotalFeatures()) {
            return false;
        }
        if (this.getPassedScenarios() != other.getPassedScenarios()) {
            return false;
        }
        if (this.getFailedScenarios() != other.getFailedScenarios()) {
            return false;
        }
        if (this.getSkippedScenarios() != other.getSkippedScenarios()) {
            return false;
        }
        if (this.getTotalScenarios() != other.getTotalScenarios()) {
            return false;
        }
        if (this.getPassedSteps() != other.getPassedSteps()) {
            return false;
        }
        if (this.getFailedSteps() != other.getFailedSteps()) {
            return false;
        }
        if (this.getSkippedSteps() != other.getSkippedSteps()) {
            return false;
        }
        if (this.getTotalSteps() != other.getTotalSteps()) {
            return false;
        }
        LocalDateTime this$testRunStartTime = this.getTestRunStartTime();
        LocalDateTime other$testRunStartTime = other.getTestRunStartTime();
        if (this$testRunStartTime == null ? other$testRunStartTime != null : !((Object)this$testRunStartTime).equals(other$testRunStartTime)) {
            return false;
        }
        LocalDateTime this$testRunEndTime = this.getTestRunEndTime();
        LocalDateTime other$testRunEndTime = other.getTestRunEndTime();
        return !(this$testRunEndTime == null ? other$testRunEndTime != null : !((Object)this$testRunEndTime).equals(other$testRunEndTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DashboardData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPassedFeatures();
        result = result * 59 + this.getFailedFeatures();
        result = result * 59 + this.getSkippedFeatures();
        result = result * 59 + this.getTotalFeatures();
        result = result * 59 + this.getPassedScenarios();
        result = result * 59 + this.getFailedScenarios();
        result = result * 59 + this.getSkippedScenarios();
        result = result * 59 + this.getTotalScenarios();
        result = result * 59 + this.getPassedSteps();
        result = result * 59 + this.getFailedSteps();
        result = result * 59 + this.getSkippedSteps();
        result = result * 59 + this.getTotalSteps();
        LocalDateTime $testRunStartTime = this.getTestRunStartTime();
        result = result * 59 + ($testRunStartTime == null ? 43 : ((Object)$testRunStartTime).hashCode());
        LocalDateTime $testRunEndTime = this.getTestRunEndTime();
        result = result * 59 + ($testRunEndTime == null ? 43 : ((Object)$testRunEndTime).hashCode());
        return result;
    }

    public String toString() {
        return "DashboardData(testRunStartTime=" + this.getTestRunStartTime() + ", testRunEndTime=" + this.getTestRunEndTime() + ", passedFeatures=" + this.getPassedFeatures() + ", failedFeatures=" + this.getFailedFeatures() + ", skippedFeatures=" + this.getSkippedFeatures() + ", totalFeatures=" + this.getTotalFeatures() + ", passedScenarios=" + this.getPassedScenarios() + ", failedScenarios=" + this.getFailedScenarios() + ", skippedScenarios=" + this.getSkippedScenarios() + ", totalScenarios=" + this.getTotalScenarios() + ", passedSteps=" + this.getPassedSteps() + ", failedSteps=" + this.getFailedSteps() + ", skippedSteps=" + this.getSkippedSteps() + ", totalSteps=" + this.getTotalSteps() + ")";
    }

    public static class DashboardDataBuilder {
        private LocalDateTime testRunStartTime;
        private LocalDateTime testRunEndTime;
        private int passedFeatures;
        private int failedFeatures;
        private int skippedFeatures;
        private int totalFeatures;
        private int passedScenarios;
        private int failedScenarios;
        private int skippedScenarios;
        private int totalScenarios;
        private int passedSteps;
        private int failedSteps;
        private int skippedSteps;
        private int totalSteps;

        DashboardDataBuilder() {
        }

        public DashboardDataBuilder testRunStartTime(LocalDateTime testRunStartTime) {
            this.testRunStartTime = testRunStartTime;
            return this;
        }

        public DashboardDataBuilder testRunEndTime(LocalDateTime testRunEndTime) {
            this.testRunEndTime = testRunEndTime;
            return this;
        }

        public DashboardDataBuilder passedFeatures(int passedFeatures) {
            this.passedFeatures = passedFeatures;
            return this;
        }

        public DashboardDataBuilder failedFeatures(int failedFeatures) {
            this.failedFeatures = failedFeatures;
            return this;
        }

        public DashboardDataBuilder skippedFeatures(int skippedFeatures) {
            this.skippedFeatures = skippedFeatures;
            return this;
        }

        public DashboardDataBuilder totalFeatures(int totalFeatures) {
            this.totalFeatures = totalFeatures;
            return this;
        }

        public DashboardDataBuilder passedScenarios(int passedScenarios) {
            this.passedScenarios = passedScenarios;
            return this;
        }

        public DashboardDataBuilder failedScenarios(int failedScenarios) {
            this.failedScenarios = failedScenarios;
            return this;
        }

        public DashboardDataBuilder skippedScenarios(int skippedScenarios) {
            this.skippedScenarios = skippedScenarios;
            return this;
        }

        public DashboardDataBuilder totalScenarios(int totalScenarios) {
            this.totalScenarios = totalScenarios;
            return this;
        }

        public DashboardDataBuilder passedSteps(int passedSteps) {
            this.passedSteps = passedSteps;
            return this;
        }

        public DashboardDataBuilder failedSteps(int failedSteps) {
            this.failedSteps = failedSteps;
            return this;
        }

        public DashboardDataBuilder skippedSteps(int skippedSteps) {
            this.skippedSteps = skippedSteps;
            return this;
        }

        public DashboardDataBuilder totalSteps(int totalSteps) {
            this.totalSteps = totalSteps;
            return this;
        }

        public DashboardData build() {
            return new DashboardData(this.testRunStartTime, this.testRunEndTime, this.passedFeatures, this.failedFeatures, this.skippedFeatures, this.totalFeatures, this.passedScenarios, this.failedScenarios, this.skippedScenarios, this.totalScenarios, this.passedSteps, this.failedSteps, this.skippedSteps, this.totalSteps);
        }

        public String toString() {
            return "DashboardData.DashboardDataBuilder(testRunStartTime=" + this.testRunStartTime + ", testRunEndTime=" + this.testRunEndTime + ", passedFeatures=" + this.passedFeatures + ", failedFeatures=" + this.failedFeatures + ", skippedFeatures=" + this.skippedFeatures + ", totalFeatures=" + this.totalFeatures + ", passedScenarios=" + this.passedScenarios + ", failedScenarios=" + this.failedScenarios + ", skippedScenarios=" + this.skippedScenarios + ", totalScenarios=" + this.totalScenarios + ", passedSteps=" + this.passedSteps + ", failedSteps=" + this.failedSteps + ", skippedSteps=" + this.skippedSteps + ", totalSteps=" + this.totalSteps + ")";
        }
    }
}

