/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.details.executable;

import java.awt.Color;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.pdf.optimizer.TextSanitizer;
import tech.grasshopper.pdf.pojo.cucumber.Executable;
import tech.grasshopper.pdf.pojo.cucumber.Status;
import tech.grasshopper.pdf.section.details.executable.DummyCellDisplay;
import tech.grasshopper.pdf.section.details.executable.LogMessageDisplay;
import tech.grasshopper.pdf.section.details.executable.MediaDisplay;
import tech.grasshopper.pdf.section.details.executable.StackTraceDisplay;
import tech.grasshopper.pdf.structure.Display;

public abstract class ExecutableDisplay
extends Display {
    protected Executable executable;
    protected Table.TableBuilder tableBuilder;
    protected int sNo;

    @Override
    public void display() {
        TextSanitizer sanitizer = TextSanitizer.builder().build();
        this.tableBuilder.addRow(Row.builder().add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(this.getSerialNumber()).borderColor(Color.GRAY)).borderWidthLeft(1.0f)).borderWidthTop(1.0f)).build()).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(sanitizer.sanitizeText(this.executableName())).textColor(this.executableNameColor())).backgroundColor(this.executableBackgroundColor())).borderColor(Color.GRAY)).borderWidth(1.0f)).build()).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(this.executable.getStatus().toString()).textColor(this.statusColor(this.executable.getStatus()))).borderColor(Color.GRAY)).borderWidthRight(1.0f)).borderWidthTop(1.0f)).build()).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(this.getDuration()).textColor(this.reportConfig.getDetailedStepHookConfig().durationColor())).borderColor(Color.GRAY)).borderWidthRight(1.0f)).borderWidthTop(1.0f)).build()).build());
        this.displaySubTypeDetails();
        this.displayLogMessage();
        this.displayStackTrace();
        this.displayMedia();
    }

    public abstract int processSNo(int var1);

    protected abstract String getSerialNumber();

    protected abstract String getDuration();

    public abstract String executableName();

    protected abstract Color executableNameColor();

    protected abstract Color executableBackgroundColor();

    protected int getSubTypeRowSpanCount() {
        return 0;
    }

    protected void displaySubTypeDetails() {
    }

    protected void displayLogMessage() {
        if (this.executable.getOutput().isEmpty()) {
            return;
        }
        LogMessageDisplay.builder().executable(this.executable).tableBuilder(this.tableBuilder).color(this.reportConfig.getDetailedStepHookConfig().logMsgColor()).build().display();
    }

    protected void displayStackTrace() {
        if (this.executable.getErrorMessage() == null || this.executable.getErrorMessage().isEmpty()) {
            return;
        }
        if (this.executable.getStatus() == Status.SKIPPED && this.executable.getErrorMessage().equalsIgnoreCase("Step Skipped")) {
            return;
        }
        this.tableBuilder.addRow(Row.builder().add(DummyCellDisplay.dummyCellLeftBorder()).add(StackTraceDisplay.builder().executable(this.executable).color(this.reportConfig.getDetailedStepHookConfig().errorMsgColor()).build().display()).add(DummyCellDisplay.dummyCellRightBorder()).add(DummyCellDisplay.dummyCellRightBorder()).build());
    }

    protected void displayMedia() {
        if (this.executable.getMedia().isEmpty()) {
            return;
        }
        this.tableBuilder.addRow(Row.builder().add(DummyCellDisplay.dummyCellLeftBorder()).add(MediaDisplay.builder().executable(this.executable).document(this.document).attachView(this.reportConfig.isDisplayAttached()).expandView(this.reportConfig.isDisplayExpanded()).build().display()).add(DummyCellDisplay.dummyCellRightBorder()).add(DummyCellDisplay.dummyCellRightBorder()).build());
    }

    protected ExecutableDisplay(ExecutableDisplayBuilder<?, ?> b) {
        super(b);
        this.executable = ((ExecutableDisplayBuilder)b).executable;
        this.tableBuilder = ((ExecutableDisplayBuilder)b).tableBuilder;
        this.sNo = ((ExecutableDisplayBuilder)b).sNo;
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public Table.TableBuilder getTableBuilder() {
        return this.tableBuilder;
    }

    public int getSNo() {
        return this.sNo;
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    public void setTableBuilder(Table.TableBuilder tableBuilder) {
        this.tableBuilder = tableBuilder;
    }

    public void setSNo(int sNo) {
        this.sNo = sNo;
    }

    @Override
    public String toString() {
        return "ExecutableDisplay(executable=" + this.getExecutable() + ", tableBuilder=" + this.getTableBuilder() + ", sNo=" + this.getSNo() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExecutableDisplay)) {
            return false;
        }
        ExecutableDisplay other = (ExecutableDisplay)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSNo() != other.getSNo()) {
            return false;
        }
        Executable this$executable = this.getExecutable();
        Executable other$executable = other.getExecutable();
        if (this$executable == null ? other$executable != null : !((Object)this$executable).equals(other$executable)) {
            return false;
        }
        Table.TableBuilder this$tableBuilder = this.getTableBuilder();
        Table.TableBuilder other$tableBuilder = other.getTableBuilder();
        return !(this$tableBuilder == null ? other$tableBuilder != null : !this$tableBuilder.equals(other$tableBuilder));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ExecutableDisplay;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSNo();
        Executable $executable = this.getExecutable();
        result = result * 59 + ($executable == null ? 43 : ((Object)$executable).hashCode());
        Table.TableBuilder $tableBuilder = this.getTableBuilder();
        result = result * 59 + ($tableBuilder == null ? 43 : $tableBuilder.hashCode());
        return result;
    }

    public static abstract class ExecutableDisplayBuilder<C extends ExecutableDisplay, B extends ExecutableDisplayBuilder<C, B>>
    extends Display.DisplayBuilder<C, B> {
        private Executable executable;
        private Table.TableBuilder tableBuilder;
        private int sNo;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B executable(Executable executable) {
            this.executable = executable;
            return (B)this.self();
        }

        public B tableBuilder(Table.TableBuilder tableBuilder) {
            this.tableBuilder = tableBuilder;
            return (B)this.self();
        }

        public B sNo(int sNo) {
            this.sNo = sNo;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ExecutableDisplay.ExecutableDisplayBuilder(super=" + super.toString() + ", executable=" + this.executable + ", tableBuilder=" + this.tableBuilder + ", sNo=" + this.sNo + ")";
        }
    }
}

