/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.processor;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.worker.extension.processor.ProcessorBean;
import tech.powerjob.worker.extension.processor.ProcessorDefinition;
import tech.powerjob.worker.extension.processor.ProcessorFactory;
import tech.powerjob.worker.processor.ProcessorLoader;

public class PowerJobProcessorLoader
implements ProcessorLoader {
    private static final Logger log = LoggerFactory.getLogger(PowerJobProcessorLoader.class);
    private final List<ProcessorFactory> processorFactoryList;
    private final Map<ProcessorDefinition, ProcessorBean> def2Bean = new ConcurrentHashMap<ProcessorDefinition, ProcessorBean>(128);

    public PowerJobProcessorLoader(List<ProcessorFactory> processorFactoryList) {
        this.processorFactoryList = processorFactoryList;
    }

    @Override
    public ProcessorBean load(ProcessorDefinition definition) {
        ProcessorBean pBean = this.def2Bean.computeIfAbsent(definition, ignore -> this.buildProcessorBean(definition));
        if (pBean.isStable()) {
            return pBean;
        }
        return this.buildProcessorBean(definition);
    }

    private ProcessorBean buildProcessorBean(ProcessorDefinition definition) {
        String processorType = definition.getProcessorType();
        log.info("[ProcessorFactory] start to load Processor: {}", (Object)definition);
        for (ProcessorFactory pf : this.processorFactoryList) {
            String pfName = pf.getClass().getSimpleName();
            if (!Optional.ofNullable(pf.supportTypes()).orElse(Collections.emptySet()).contains(processorType)) {
                log.info("[ProcessorFactory] [{}] can't load type={}, skip!", (Object)pfName, (Object)processorType);
                continue;
            }
            log.info("[ProcessorFactory] [{}] try to load processor: {}", (Object)pfName, (Object)definition);
            try {
                ProcessorBean processorBean = pf.build(definition);
                if (processorBean == null) continue;
                log.info("[ProcessorFactory] [{}] load processor successfully: {}", (Object)pfName, (Object)definition);
                return processorBean;
            }
            catch (Throwable t) {
                log.error("[ProcessorFactory] [{}] load processor failed: {}", new Object[]{pfName, definition, t});
            }
        }
        throw new PowerJobException("fetch Processor failed, please check your processorType and processorInfo config");
    }
}

