/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.selector;

import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import us.codecraft.webmagic.selector.RegexSelector;
import us.codecraft.webmagic.selector.ReplaceSelector;
import us.codecraft.webmagic.selector.Selector;
import us.codecraft.webmagic.selector.SmartContentSelector;
import us.codecraft.webmagic.selector.XpathSelector;

public class SelectorFactory {
    private Map<String, Selector> innerCache = new ConcurrentHashMap<String, Selector>();
    private static final SelectorFactory INSTATNCE = new SelectorFactory();

    public static SelectorFactory getInstatnce() {
        return INSTATNCE;
    }

    public RegexSelector newRegexSelector(String regex) {
        return this.newSelector(RegexSelector.class, regex);
    }

    public RegexSelector newRegexSelector(String regex, int group) {
        String cacheKey = this.getCacheKey(RegexSelector.class, regex, String.valueOf(group));
        if (this.innerCache.get(cacheKey) != null) {
            return (RegexSelector)this.innerCache.get(cacheKey);
        }
        return new RegexSelector(regex, group);
    }

    public ReplaceSelector newReplaceSelector(String regex, String replacement) {
        return this.newSelector(ReplaceSelector.class, regex, replacement);
    }

    public XpathSelector newXpathSelector(String xpath) {
        return this.newSelector(XpathSelector.class, xpath);
    }

    public SmartContentSelector newSmartContentSelector() {
        return this.newSelector(SmartContentSelector.class, new String[0]);
    }

    public <T extends Selector> T newAndCacheSelector(Class<T> clazz, String ... param) {
        String cacheKey = this.getCacheKey(RegexSelector.class, param);
        if (this.innerCache.get(cacheKey) != null) {
            return (T)this.innerCache.get(cacheKey);
        }
        T selector = this.newSelector(clazz, param);
        if (selector != null) {
            this.innerCache.put(cacheKey, (Selector)selector);
        }
        return selector;
    }

    public <T extends Selector> T newSelector(Class<T> clazz, String ... param) {
        try {
            if (param.length == 0) {
                Constructor<T> constructor = clazz.getConstructor(new Class[0]);
                Selector selector = (Selector)constructor.newInstance(new Object[0]);
                return (T)selector;
            }
            if (param.length == 1) {
                Constructor<T> constructor = clazz.getConstructor(String.class);
                Selector selector = (Selector)constructor.newInstance(param[0]);
                return (T)selector;
            }
            if (param.length == 2) {
                Constructor<T> constructor = clazz.getConstructor(String.class, String.class);
                Selector selector = (Selector)constructor.newInstance(param[0], param[1]);
                return (T)selector;
            }
            throw new UnsupportedOperationException();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("init object error", e);
        }
    }

    private String getCacheKey(Class<?> clazz, String ... param) {
        return clazz.toString() + "_" + StringUtils.join((Object[])param, (String)"_");
    }
}

