/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.InputChunked;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.io.OutputChunked;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.kryo.util.Util;
import com.esotericsoftware.minlog.Log;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;

public class TaggedFieldSerializer<T>
extends FieldSerializer<T> {
    private static final Comparator<FieldSerializer.CachedField> tagComparator = new Comparator<FieldSerializer.CachedField>(){

        @Override
        public int compare(FieldSerializer.CachedField o1, FieldSerializer.CachedField o2) {
            return o1.field.getAnnotation(Tag.class).value() - o2.field.getAnnotation(Tag.class).value();
        }
    };
    private int[] tags;
    private int writeFieldCount;
    private boolean[] deprecated;
    private final TaggedFieldSerializerConfig config;

    public TaggedFieldSerializer(Kryo kryo, Class type) {
        this(kryo, type, new TaggedFieldSerializerConfig());
    }

    public TaggedFieldSerializer(Kryo kryo, Class type, TaggedFieldSerializerConfig config) {
        super(kryo, type, config);
        this.config = config;
        this.setAcceptsNull(true);
    }

    @Override
    protected void initializeCachedFields() {
        int n;
        Field field;
        FieldSerializer.CachedField[] fields = this.cachedFields.fields;
        int n2 = fields.length;
        for (int i = 0; i < n2; ++i) {
            field = fields[i].field;
            if (field.getAnnotation(Tag.class) != null) continue;
            if (Log.TRACE) {
                Log.trace("kryo", "Ignoring field without tag: " + fields[i]);
            }
            super.removeField(fields[i]);
        }
        fields = this.cachedFields.fields;
        Arrays.sort(fields, tagComparator);
        this.writeFieldCount = n = fields.length;
        this.tags = new int[n];
        this.deprecated = new boolean[n];
        for (int i = 0; i < n; ++i) {
            field = fields[i].field;
            this.tags[i] = field.getAnnotation(Tag.class).value();
            if (i > 0 && this.tags[i] == this.tags[i - 1]) {
                throw new KryoException("Duplicate tag " + this.tags[i] + " on fields: " + field + " and " + fields[i - 1].field);
            }
            if (field.getAnnotation(Deprecated.class) == null) continue;
            this.deprecated[i] = true;
            --this.writeFieldCount;
        }
    }

    @Override
    public void removeField(String fieldName) {
        super.removeField(fieldName);
        this.initializeCachedFields();
    }

    @Override
    public void removeField(FieldSerializer.CachedField field) {
        super.removeField(field);
        this.initializeCachedFields();
    }

    @Override
    public void write(Kryo kryo, Output output, T object) {
        Output fieldOutput;
        if (object == null) {
            output.writeByte((byte)0);
            return;
        }
        int pop = this.pushTypeVariables();
        output.writeVarInt(this.writeFieldCount + 1, true);
        this.writeHeader(kryo, output, object);
        FieldSerializer.CachedField[] fields = this.cachedFields.fields;
        boolean chunked = this.config.chunked;
        boolean readUnknownTagData = this.config.readUnknownTagData;
        OutputChunked outputChunked = null;
        if (chunked) {
            outputChunked = new OutputChunked(output, this.config.chunkSize);
            fieldOutput = outputChunked;
        } else {
            fieldOutput = output;
        }
        int[] tags = this.tags;
        boolean[] deprecated = this.deprecated;
        int n = fields.length;
        for (int i = 0; i < n; ++i) {
            if (deprecated[i]) continue;
            FieldSerializer.CachedField cachedField = fields[i];
            if (Log.TRACE) {
                this.log("Write", fields[i], output.position());
            }
            output.writeVarInt(tags[i], true);
            if (readUnknownTagData) {
                Class<?> valueClass = null;
                try {
                    Object value;
                    if (object != null && (value = cachedField.field.get(object)) != null) {
                        valueClass = value.getClass();
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                kryo.writeClass(fieldOutput, valueClass);
                if (valueClass == null) {
                    if (!chunked) continue;
                    outputChunked.endChunk();
                    continue;
                }
                cachedField.setCanBeNull(false);
                cachedField.setValueClass(valueClass);
            }
            cachedField.write(fieldOutput, object);
            if (!chunked) continue;
            outputChunked.endChunk();
        }
        if (pop > 0) {
            this.popTypeVariables(pop);
        }
    }

    protected void writeHeader(Kryo kryo, Output output, T object) {
    }

    @Override
    public T read(Kryo kryo, Input input, Class<? extends T> type) {
        Input fieldInput;
        int fieldCount = input.readVarInt(true);
        if (fieldCount == 0) {
            return null;
        }
        --fieldCount;
        int pop = this.pushTypeVariables();
        T object = this.create(kryo, input, type);
        kryo.reference(object);
        FieldSerializer.CachedField[] fields = this.cachedFields.fields;
        boolean chunked = this.config.chunked;
        boolean readUnknownTagData = this.config.readUnknownTagData;
        InputChunked inputChunked = null;
        if (chunked) {
            inputChunked = new InputChunked(input, this.config.chunkSize);
            fieldInput = inputChunked;
        } else {
            fieldInput = input;
        }
        int[] tags = this.tags;
        int n = fieldCount;
        for (int i = 0; i < n; ++i) {
            int tag = input.readVarInt(true);
            FieldSerializer.CachedField cachedField = null;
            int nn = tags.length;
            for (int ii = 0; ii < nn; ++ii) {
                if (tags[ii] != tag) continue;
                cachedField = fields[ii];
                break;
            }
            if (readUnknownTagData) {
                Registration registration;
                try {
                    registration = kryo.readClass(fieldInput);
                }
                catch (KryoException ex) {
                    if (!chunked) {
                        throw new KryoException("Unable to read unknown tag " + tag + " data (unknown type). (" + this.getType().getName() + ")", ex);
                    }
                    if (Log.DEBUG) {
                        Log.debug("kryo", "Unable to read unknown tag " + tag + " data (unknown type).", ex);
                    }
                    inputChunked.nextChunk();
                    continue;
                }
                if (registration == null) {
                    if (!chunked) continue;
                    inputChunked.nextChunk();
                    continue;
                }
                Class valueClass = registration.getType();
                if (cachedField == null) {
                    block22: {
                        if (Log.TRACE) {
                            Log.trace("kryo", "Read unknown tag " + tag + " data, type: " + Util.className(valueClass));
                        }
                        try {
                            kryo.readObject(fieldInput, valueClass);
                        }
                        catch (KryoException ex) {
                            if (!chunked) {
                                throw new KryoException("Unable to read unknown tag " + tag + " data, type: " + Util.className(valueClass), ex);
                            }
                            if (!Log.DEBUG) break block22;
                            Log.debug("kryo", "Unable to read unknown tag " + tag + " data, type: " + Util.className(valueClass), ex);
                        }
                    }
                    if (!chunked) continue;
                    inputChunked.nextChunk();
                    continue;
                }
                cachedField.setCanBeNull(false);
                cachedField.setValueClass(valueClass);
            } else if (cachedField == null) {
                if (!chunked) {
                    throw new KryoException("Unknown field tag: " + tag + " (" + this.getType().getName() + ")");
                }
                if (Log.TRACE) {
                    Log.trace("kryo", "Skip unknown field tag: " + tag);
                }
                inputChunked.nextChunk();
                continue;
            }
            if (Log.TRACE) {
                this.log("Read", cachedField, input.position());
            }
            cachedField.read(fieldInput, object);
            if (!chunked) continue;
            inputChunked.nextChunk();
        }
        if (pop > 0) {
            this.popTypeVariables(pop);
        }
        return object;
    }

    public TaggedFieldSerializerConfig getTaggedFieldSerializerConfig() {
        return this.config;
    }

    public static class TaggedFieldSerializerConfig
    extends FieldSerializer.FieldSerializerConfig {
        boolean readUnknownTagData;
        boolean chunked;
        int chunkSize = 1024;

        @Override
        public TaggedFieldSerializerConfig clone() {
            return (TaggedFieldSerializerConfig)super.clone();
        }

        public void setReadUnknownTagData(boolean readUnknownTagData) {
            this.readUnknownTagData = readUnknownTagData;
        }

        public boolean getReadUnknownTagData() {
            return this.readUnknownTagData;
        }

        public void setChunkedEncoding(boolean chunked) {
            this.chunked = chunked;
            if (Log.TRACE) {
                Log.trace("kryo", "TaggedFieldSerializerConfig setChunked: " + chunked);
            }
        }

        public boolean getChunkedEncoding() {
            return this.chunked;
        }

        public void setChunkSize(int chunkSize) {
            this.chunkSize = chunkSize;
            if (Log.TRACE) {
                Log.trace("kryo", "TaggedFieldSerializerConfig setChunkSize: " + chunkSize);
            }
        }

        public int getChunkSize() {
            return this.chunkSize;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Tag {
        public int value();
    }
}

