/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.query.parser.cqn;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.query.parser.common.InvalidQueryException;
import com.googlecode.cqengine.query.parser.common.ParseResult;
import com.googlecode.cqengine.query.parser.common.QueryParser;
import com.googlecode.cqengine.query.parser.cqn.grammar.CQNGrammarLexer;
import com.googlecode.cqengine.query.parser.cqn.grammar.CQNGrammarParser;
import com.googlecode.cqengine.query.parser.cqn.support.CQNAntlrListener;
import com.googlecode.cqengine.query.parser.cqn.support.FallbackValueParser;
import com.googlecode.cqengine.query.parser.cqn.support.StringParser;
import java.util.Map;
import selogger.org.antlr.v4.runtime.ANTLRInputStream;
import selogger.org.antlr.v4.runtime.CommonTokenStream;
import selogger.org.antlr.v4.runtime.tree.ParseTreeWalker;

public class CQNParser<O>
extends QueryParser<O> {
    public CQNParser(Class<O> objectType) {
        super(objectType);
        StringParser stringParser = new StringParser();
        super.registerValueParser(String.class, stringParser);
        super.registerFallbackValueParser(new FallbackValueParser(stringParser));
    }

    @Override
    public ParseResult<O> parse(String query) {
        try {
            if (query == null) {
                throw new IllegalArgumentException("Query was null");
            }
            CQNGrammarLexer lexer = new CQNGrammarLexer(new ANTLRInputStream(query));
            lexer.removeErrorListeners();
            lexer.addErrorListener(SYNTAX_ERROR_LISTENER);
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            CQNGrammarParser parser = new CQNGrammarParser(tokens);
            parser.removeErrorListeners();
            parser.addErrorListener(SYNTAX_ERROR_LISTENER);
            CQNGrammarParser.StartContext queryContext = parser.start();
            ParseTreeWalker walker = new ParseTreeWalker();
            CQNAntlrListener listener = new CQNAntlrListener(this);
            walker.walk(listener, queryContext);
            return new ParseResult(listener.getParsedQuery(), listener.getQueryOptions());
        }
        catch (InvalidQueryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidQueryException("Failed to parse query", e);
        }
    }

    public static <O> CQNParser<O> forPojo(Class<O> pojoClass) {
        return new CQNParser<O>(pojoClass);
    }

    public static <O> CQNParser<O> forPojoWithAttributes(Class<O> pojoClass, Map<String, ? extends Attribute<O, ?>> attributes) {
        CQNParser<O> parser = CQNParser.forPojo(pojoClass);
        parser.registerAttributes(attributes);
        return parser;
    }
}

