/*
 * Decompiled with CFR 0.152.
 */
package com.insidious.common.parser;

import io.kaitai.struct.ByteBufferKaitaiStream;
import io.kaitai.struct.KaitaiStream;
import io.kaitai.struct.KaitaiStruct;
import java.io.IOException;
import java.util.ArrayList;

public class KaitaiInsidiousIndexParser
extends KaitaiStruct {
    private long indexFileCount;
    private ArrayList<IndexedFile> indexFiles;
    private long unionValueIdIndexLen;
    private byte[] unionValueIdIndex;
    private long unionProbeIdIndexLen;
    private byte[] unionProbeIdIndex;
    private long endTime;
    private KaitaiInsidiousIndexParser _root;
    private KaitaiStruct _parent;

    public static KaitaiInsidiousIndexParser fromFile(String fileName) throws IOException {
        return new KaitaiInsidiousIndexParser(new ByteBufferKaitaiStream(fileName));
    }

    public KaitaiInsidiousIndexParser(KaitaiStream _io) {
        this(_io, null, null);
    }

    public KaitaiInsidiousIndexParser(KaitaiStream _io, KaitaiStruct _parent) {
        this(_io, _parent, null);
    }

    public KaitaiInsidiousIndexParser(KaitaiStream _io, KaitaiStruct _parent, KaitaiInsidiousIndexParser _root) {
        super(_io);
        this._parent = _parent;
        this._root = _root == null ? this : _root;
        this._read();
    }

    private void _read() {
        this.indexFileCount = this._io.readU4be();
        this.indexFiles = new ArrayList();
        int i = 0;
        while ((long)i < this.indexFileCount()) {
            this.indexFiles.add(new IndexedFile(this._io, this, this._root));
            ++i;
        }
        this.unionValueIdIndexLen = this._io.readU4be();
        this.unionValueIdIndex = this._io.readBytes(this.unionValueIdIndexLen());
        this.unionProbeIdIndexLen = this._io.readU4be();
        this.unionProbeIdIndex = this._io.readBytes(this.unionProbeIdIndexLen());
        this.endTime = this._io.readU8be();
    }

    public long indexFileCount() {
        return this.indexFileCount;
    }

    public ArrayList<IndexedFile> indexFiles() {
        return this.indexFiles;
    }

    public long unionValueIdIndexLen() {
        return this.unionValueIdIndexLen;
    }

    public byte[] unionValueIdIndex() {
        return this.unionValueIdIndex;
    }

    public long unionProbeIdIndexLen() {
        return this.unionProbeIdIndexLen;
    }

    public byte[] unionProbeIdIndex() {
        return this.unionProbeIdIndex;
    }

    public long endTime() {
        return this.endTime;
    }

    public KaitaiInsidiousIndexParser _root() {
        return this._root;
    }

    @Override
    public KaitaiStruct _parent() {
        return this._parent;
    }

    public static class IndexedFile
    extends KaitaiStruct {
        private StrWithLen filePath;
        private long threadId;
        private long valueIdIndexLen;
        private byte[] valueIdIndex;
        private long probeIdIndexLen;
        private byte[] probeIdIndex;
        private KaitaiInsidiousIndexParser _root;
        private KaitaiInsidiousIndexParser _parent;

        public static IndexedFile fromFile(String fileName) throws IOException {
            return new IndexedFile(new ByteBufferKaitaiStream(fileName));
        }

        public IndexedFile(KaitaiStream _io) {
            this(_io, null, null);
        }

        public IndexedFile(KaitaiStream _io, KaitaiInsidiousIndexParser _parent) {
            this(_io, _parent, null);
        }

        public IndexedFile(KaitaiStream _io, KaitaiInsidiousIndexParser _parent, KaitaiInsidiousIndexParser _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.filePath = new StrWithLen(this._io, this, this._root);
            this.threadId = this._io.readU8be();
            this.valueIdIndexLen = this._io.readU4be();
            this.valueIdIndex = this._io.readBytes(this.valueIdIndexLen());
            this.probeIdIndexLen = this._io.readU4be();
            this.probeIdIndex = this._io.readBytes(this.probeIdIndexLen());
        }

        public StrWithLen filePath() {
            return this.filePath;
        }

        public long threadId() {
            return this.threadId;
        }

        public long valueIdIndexLen() {
            return this.valueIdIndexLen;
        }

        public byte[] valueIdIndex() {
            return this.valueIdIndex;
        }

        public long probeIdIndexLen() {
            return this.probeIdIndexLen;
        }

        public byte[] probeIdIndex() {
            return this.probeIdIndex;
        }

        public KaitaiInsidiousIndexParser _root() {
            return this._root;
        }

        @Override
        public KaitaiInsidiousIndexParser _parent() {
            return this._parent;
        }
    }

    public static class StrWithLen
    extends KaitaiStruct {
        private long len;
        private byte[] value;
        private KaitaiInsidiousIndexParser _root;
        private IndexedFile _parent;

        public static StrWithLen fromFile(String fileName) throws IOException {
            return new StrWithLen(new ByteBufferKaitaiStream(fileName));
        }

        public StrWithLen(KaitaiStream _io) {
            this(_io, null, null);
        }

        public StrWithLen(KaitaiStream _io, IndexedFile _parent) {
            this(_io, _parent, null);
        }

        public StrWithLen(KaitaiStream _io, IndexedFile _parent, KaitaiInsidiousIndexParser _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.len = this._io.readU4be();
            this.value = this._io.readBytes(this.len());
        }

        public long len() {
            return this.len;
        }

        public byte[] value() {
            return this.value;
        }

        public KaitaiInsidiousIndexParser _root() {
            return this._root;
        }

        @Override
        public IndexedFile _parent() {
            return this._parent;
        }
    }
}

