/*
 * Decompiled with CFR 0.152.
 */
package com.insidious.common.weaver;

import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.query.option.QueryOptions;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.util.Scanner;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.core.io.IORuntimeException;

public class MethodInfo
implements Serializable,
BytesMarshallable {
    public static final SimpleAttribute<MethodInfo, Integer> METHOD_ID = new SimpleAttribute<MethodInfo, Integer>("methodId"){

        @Override
        public Integer getValue(MethodInfo probeInfoDocument, QueryOptions queryOptions) {
            return probeInfoDocument.methodId;
        }
    };
    private static final String SEPARATOR = ",";
    private int classId;
    private int methodId;
    private String className;
    private String methodName;
    private String methodDesc;
    private int access;
    private String sourceFileName;
    private String methodHash;

    public MethodInfo(int classId, int methodId, String className, String methodName, String methodDesc, int access, String sourceFileName, String methodHash) {
        this.classId = classId;
        this.methodId = methodId;
        this.className = className;
        this.methodName = methodName;
        this.methodDesc = methodDesc;
        this.access = access;
        this.sourceFileName = sourceFileName;
        this.methodHash = methodHash;
    }

    public static MethodInfo parse(String s) {
        Scanner sc = new Scanner(s);
        sc.useDelimiter(SEPARATOR);
        int classId = sc.nextInt();
        int methodId = sc.nextInt();
        String className = sc.next();
        String methodName = sc.next();
        String methodDesc = sc.next();
        int access = sc.nextInt();
        String sourceFileName = sc.hasNext() ? sc.next() : "";
        String methodHash = sc.hasNext() ? sc.next() : "";
        sc.close();
        return new MethodInfo(classId, methodId, className, methodName, methodDesc, access, sourceFileName, methodHash);
    }

    public int getClassId() {
        return this.classId;
    }

    public int getMethodId() {
        return this.methodId;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMethodDesc() {
        return this.methodDesc;
    }

    public int getAccess() {
        return this.access;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public String getMethodHash() {
        return this.methodHash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.classId);
        buf.append(SEPARATOR);
        buf.append(this.methodId);
        buf.append(SEPARATOR);
        buf.append(this.className);
        buf.append(SEPARATOR);
        buf.append(this.methodName);
        buf.append(SEPARATOR);
        buf.append(this.methodDesc);
        buf.append(SEPARATOR);
        buf.append(this.access);
        buf.append(SEPARATOR);
        if (this.sourceFileName != null) {
            buf.append(this.sourceFileName);
        }
        buf.append(SEPARATOR);
        if (this.methodHash != null) {
            buf.append(this.methodHash);
        }
        return buf.toString();
    }

    @Override
    public void readMarshallable(BytesIn bytes) throws IORuntimeException, BufferUnderflowException, IllegalStateException {
        int methodHashLength;
        int descLength;
        this.classId = bytes.readInt();
        this.methodId = bytes.readInt();
        int methodNameLength = bytes.readInt();
        if (methodNameLength > 0) {
            byte[] nameBytes = new byte[methodNameLength];
            bytes.read(nameBytes);
            this.methodName = new String(nameBytes);
        }
        if ((descLength = bytes.readInt()) > 0) {
            byte[] descBytes = new byte[descLength];
            bytes.read(descBytes);
            this.methodName = new String(descBytes);
        }
        this.access = bytes.readInt();
        int sourceLength = bytes.readInt();
        if (sourceLength > 0) {
            byte[] sourceNameBytes = new byte[sourceLength];
            bytes.read(sourceNameBytes);
            this.sourceFileName = new String(sourceNameBytes);
        }
        if ((methodHashLength = bytes.readInt()) > 0) {
            byte[] methodHashBytes = new byte[methodHashLength];
            bytes.read(methodHashBytes);
            this.methodHash = new String(methodHashBytes);
        }
    }

    @Override
    public void writeMarshallable(BytesOut bytes) throws IllegalStateException, BufferOverflowException, BufferUnderflowException, ArithmeticException {
        bytes.writeInt(this.classId);
        bytes.writeInt(this.methodId);
        bytes.writeInt(this.methodName.getBytes().length);
        bytes.write(this.methodName.getBytes());
        bytes.writeInt(this.methodDesc.getBytes().length);
        bytes.write(this.methodDesc.getBytes());
        bytes.writeInt(this.access);
        bytes.writeInt(this.sourceFileName.getBytes().length);
        bytes.write(this.sourceFileName.getBytes());
        bytes.writeInt(this.methodHash.getBytes().length);
        bytes.write(this.methodHash.getBytes());
    }

    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dao = new DataOutputStream(baos);
        dao.writeInt(this.classId);
        dao.writeInt(this.methodId);
        if (this.methodName != null) {
            dao.writeInt(this.methodName.getBytes().length);
            dao.write(this.methodName.getBytes());
        } else {
            dao.writeInt(0);
        }
        dao.writeInt(this.methodDesc.getBytes().length);
        dao.write(this.methodDesc.getBytes());
        dao.writeInt(this.access);
        if (this.sourceFileName != null) {
            dao.writeInt(this.sourceFileName.getBytes().length);
            dao.write(this.sourceFileName.getBytes());
        } else {
            dao.writeInt(0);
        }
        dao.writeInt(this.methodHash.getBytes().length);
        dao.write(this.methodHash.getBytes());
        return baos.toByteArray();
    }

    public void writeToOutputStream(OutputStream baos) throws IOException {
        DataOutputStream dao = new DataOutputStream(baos);
        dao.writeInt(this.classId);
        dao.writeInt(this.methodId);
        if (this.methodName != null) {
            dao.writeInt(this.methodName.getBytes().length);
            dao.write(this.methodName.getBytes());
        } else {
            dao.writeInt(0);
        }
        dao.writeInt(this.methodDesc.getBytes().length);
        dao.write(this.methodDesc.getBytes());
        dao.writeInt(this.access);
        if (this.sourceFileName != null) {
            dao.writeInt(this.sourceFileName.getBytes().length);
            dao.write(this.sourceFileName.getBytes());
        } else {
            dao.writeInt(0);
        }
        dao.writeInt(this.methodHash.getBytes().length);
        dao.write(this.methodHash.getBytes());
        dao.flush();
    }
}

