/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.SerializerFactory;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.minlog.Log;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class FieldAnnotationAwareSerializer<T>
extends FieldSerializer<T> {
    private final Set<Class<? extends Annotation>> marked;
    private final boolean disregarding;

    public FieldAnnotationAwareSerializer(Kryo kryo, Class<?> type, Collection<Class<? extends Annotation>> marked, boolean disregarding) {
        super(kryo, type);
        this.disregarding = disregarding;
        this.marked = new HashSet<Class<? extends Annotation>>(marked);
        this.removeFields();
    }

    @Override
    public void updateFields() {
        if (this.marked == null) {
            return;
        }
        super.updateFields();
        this.removeFields();
    }

    private void removeFields() {
        FieldSerializer.CachedField[] cachedFields;
        for (FieldSerializer.CachedField cachedField : cachedFields = this.getFields()) {
            Field field = cachedField.getField();
            if (!this.isRemove(field)) continue;
            if (Log.TRACE) {
                Log.trace("kryo", String.format("Ignoring field %s tag: %s", this.disregarding ? "without" : "with", cachedField));
            }
            super.removeField(field.getName());
        }
    }

    private boolean isRemove(Field field) {
        return !this.isMarked(field) ^ this.disregarding;
    }

    private boolean isMarked(Field field) {
        for (Annotation annotation : field.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!this.marked.contains(annotationType)) continue;
            return true;
        }
        return false;
    }

    public boolean addAnnotation(Class<? extends Annotation> clazz) {
        if (this.disregarding && this.marked.add(clazz)) {
            this.initializeCachedFields();
            return true;
        }
        return false;
    }

    public boolean removeAnnotation(Class<? extends Annotation> clazz) {
        if (!this.disregarding && this.marked.remove(clazz)) {
            this.initializeCachedFields();
            return true;
        }
        return false;
    }

    public static class Factory
    implements SerializerFactory<FieldAnnotationAwareSerializer<Object>> {
        private final Collection<Class<? extends Annotation>> marked;
        private final boolean disregarding;

        public Factory(Collection<Class<? extends Annotation>> marked, boolean disregarding) {
            this.marked = marked;
            this.disregarding = disregarding;
        }

        @Override
        public boolean isSupported(Class type) {
            return true;
        }

        @Override
        public FieldAnnotationAwareSerializer<Object> newSerializer(Kryo kryo, Class type) {
            return new FieldAnnotationAwareSerializer<Object>(kryo, type, this.marked, this.disregarding);
        }
    }
}

