/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged;

import io.unlogged.AgentCommandRawResponse;
import io.unlogged.MethodSignatureParser;
import io.unlogged.ParameterFactory;
import io.unlogged.auth.RequestAuthentication;
import io.unlogged.auth.UnloggedSpringAuthentication;
import io.unlogged.command.AgentCommandExecutor;
import io.unlogged.command.AgentCommandRequest;
import io.unlogged.command.AgentCommandRequestType;
import io.unlogged.command.AgentCommandResponse;
import io.unlogged.command.ResponseType;
import io.unlogged.logging.IEventLogger;
import io.unlogged.mocking.DeclaredMock;
import io.unlogged.mocking.MockHandler;
import io.unlogged.mocking.MockInstance;
import io.unlogged.util.ClassTypeUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import selogger.com.fasterxml.jackson.core.JsonProcessingException;
import selogger.com.fasterxml.jackson.databind.JavaType;
import selogger.com.fasterxml.jackson.databind.ObjectMapper;
import selogger.com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import selogger.com.fasterxml.jackson.databind.type.TypeFactory;
import selogger.net.bytebuddy.ByteBuddy;
import selogger.net.bytebuddy.NamingStrategy;
import selogger.net.bytebuddy.description.annotation.AnnotationDescription;
import selogger.net.bytebuddy.description.modifier.ModifierContributor;
import selogger.net.bytebuddy.dynamic.DynamicType;
import selogger.net.bytebuddy.dynamic.Transformer;
import selogger.net.bytebuddy.dynamic.loading.ClassInjector;
import selogger.net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import selogger.net.bytebuddy.implementation.MethodDelegation;
import selogger.net.bytebuddy.matcher.ElementMatchers;

public class AgentCommandExecutorImpl
implements AgentCommandExecutor {
    private final ObjectMapper objectMapper;
    private final IEventLogger logger;
    private final ByteBuddy byteBuddyInstance = new ByteBuddy().with(new NamingStrategy.SuffixingRandom("Unlogged"));
    private final Map<String, MockInstance> globalFieldMockMap = new HashMap<String, MockInstance>();
    private final Map<String, Object> ourOwnObjects = new HashMap<String, Object>();
    private final ParameterFactory parameterFactory;
    Objenesis objenesis = new ObjenesisStd();
    private Object applicationContext;
    private Object springTestContextManager;
    private boolean isSpringPresent;
    private Method getBeanMethod;
    private Method getBeanByBeanNameMethod;
    private Object springBeanFactory;
    private Object springTransactionStatus;
    private Object platformTransactionManagerBean;
    private Method getBeanDefinitionNamesMethod;

    public AgentCommandExecutorImpl(ObjectMapper objectMapper, IEventLogger logger) {
        this.objectMapper = objectMapper;
        this.logger = logger;
        this.parameterFactory = new ParameterFactory(this.objenesis, objectMapper, this.byteBuddyInstance);
    }

    private void closeHibernateSessionIfPossible(Object sessionInstance) {
        if (sessionInstance != null) {
            try {
                Method transactionCommitMethod = this.platformTransactionManagerBean.getClass().getMethod("commit", Class.forName("org.springframework.transaction.TransactionStatus"));
                transactionCommitMethod.invoke(this.platformTransactionManagerBean, this.springTransactionStatus);
                Method getTransactionMethod = sessionInstance.getClass().getMethod("getTransaction", new Class[0]);
                Object transactionInstance = getTransactionMethod.invoke(sessionInstance, new Object[0]);
                Method rollbackMethod = transactionInstance.getClass().getMethod("rollback", new Class[0]);
                rollbackMethod.invoke(transactionInstance, new Object[0]);
                Method sessionCloseMethod = sessionInstance.getClass().getMethod("close", new Class[0]);
                sessionCloseMethod.invoke(sessionInstance, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public AgentCommandRawResponse executeCommandRaw(AgentCommandRequest agentCommandRequest) {
        if (agentCommandRequest == null) {
            AgentCommandResponse agentCommandResponse = new AgentCommandResponse();
            agentCommandResponse.setMessage("request is null");
            agentCommandResponse.setResponseType(ResponseType.FAILED);
            return new AgentCommandRawResponse(agentCommandResponse, new Exception("request is null"));
        }
        AgentCommandResponse agentCommandResponse = new AgentCommandResponse();
        AgentCommandRawResponse agentCommandRawResponse = new AgentCommandRawResponse(agentCommandResponse);
        AgentCommandRequestType requestType = agentCommandRequest.getRequestType();
        if (requestType == null) {
            requestType = AgentCommandRequestType.REPEAT_INVOKE;
        }
        try {
            Class<?> targetClassType;
            ClassLoader targetClassLoader1;
            String targetClassName;
            Object objectInstanceByClass;
            Object sessionInstance;
            block53: {
                this.logger.setRecordingPaused(true);
                this.loadContext();
                sessionInstance = this.tryOpenHibernateSessionIfHibernateExists();
                objectInstanceByClass = null;
                targetClassName = agentCommandRequest.getClassName();
                if (this.applicationContext != null && this.getBeanMethod != null) {
                    try {
                        objectInstanceByClass = this.getBeanMethod.invoke(this.applicationContext, Class.forName(targetClassName));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (objectInstanceByClass == null) {
                    objectInstanceByClass = this.logger.getObjectByClassName(targetClassName);
                }
                List<String> alternateClassNames = agentCommandRequest.getAlternateClassNames();
                if (objectInstanceByClass == null && alternateClassNames != null && !alternateClassNames.isEmpty()) {
                    String alternateClassName;
                    Iterator<String> iterator = alternateClassNames.iterator();
                    while (iterator.hasNext() && (objectInstanceByClass = this.logger.getObjectByClassName(alternateClassName = iterator.next())) == null) {
                    }
                }
                targetClassLoader1 = this.logger.getTargetClassLoader();
                if (objectInstanceByClass == null) {
                    objectInstanceByClass = this.tryObjectConstruct(targetClassName, targetClassLoader1, new HashMap<String, Object>());
                }
                if (objectInstanceByClass != null) {
                    targetClassType = objectInstanceByClass.getClass();
                    break block53;
                }
                try {
                    targetClassType = Class.forName(targetClassName, false, targetClassLoader1);
                }
                catch (Exception e2) {
                    agentCommandResponse.setTargetClassName(targetClassName);
                    agentCommandResponse.setTargetMethodName(agentCommandRequest.getMethodName());
                    agentCommandResponse.setTargetMethodSignature(agentCommandRequest.getMethodSignature());
                    agentCommandResponse.setTimestamp(new Date().getTime());
                    agentCommandResponse.setMethodReturnValue(null);
                    agentCommandResponse.setResponseClassName(null);
                    agentCommandResponse.setResponseType(ResponseType.FAILED);
                    agentCommandResponse.setMessage(e2.getMessage());
                    agentCommandRawResponse.setResponseObject(null);
                    AgentCommandRawResponse agentCommandRawResponse2 = agentCommandRawResponse;
                    this.closeHibernateSessionIfPossible(sessionInstance);
                    this.logger.setRecordingPaused(false);
                    return agentCommandRawResponse2;
                }
            }
            try {
                Object methodReturnValue;
                Object[] parameters;
                ClassLoader targetClassLoader = objectInstanceByClass != null ? objectInstanceByClass.getClass().getClassLoader() : targetClassLoader1;
                List<String> methodSignatureParts = MethodSignatureParser.parseMethodSignature(agentCommandRequest.getMethodSignature());
                String methodReturnType = methodSignatureParts.remove(methodSignatureParts.size() - 1);
                List<String> methodParameters = agentCommandRequest.getMethodParameters();
                JavaType[] expectedMethodArgumentTypes = new JavaType[methodSignatureParts.size()];
                List<String> typeFromRequest = agentCommandRequest.getParameterTypes();
                TypeFactory typeFactory = this.objectMapper.getTypeFactory();
                for (int i = 0; i < methodSignatureParts.size(); ++i) {
                    JavaType typeReference;
                    String methodSignaturePart = methodSignatureParts.get(i);
                    String typeName = typeFromRequest.get(i);
                    try {
                        typeReference = ClassTypeUtil.getClassNameFromDescriptor(methodSignaturePart, typeFactory);
                    }
                    catch (Exception e3) {
                        typeReference = ClassTypeUtil.getClassNameFromDescriptor(typeName, typeFactory);
                    }
                    expectedMethodArgumentTypes[i] = typeReference;
                }
                try {
                    Class<?> rch = Class.forName("org.springframework.web.context.request.RequestContextHolder");
                    String className = "org.springframework.web.context.request.RequestAttributes";
                    Class<?> requestAttributesClass = Class.forName(className);
                    Method setRequestAttributesMethod = rch.getMethod("setRequestAttributes", requestAttributesClass, Boolean.TYPE);
                    String attributesClassName = "org.springframework.web.context.request.ServletRequestAttributes";
                    Class<?> attributesClass = Class.forName(attributesClassName);
                    Object requestAttributes = this.parameterFactory.createObjectInstanceFromStringAndTypeInformation(attributesClassName, "{\"request\": {   \"requestURL\": \"https://localhost:8080/api\",   \"queryString\": \"?query=value\",   \"method\": \"GET\",   \"requestURI\": \"/api\"}}", attributesClass, this.objectMapper.getTypeFactory().withClassLoader(targetClassLoader));
                    setRequestAttributesMethod.invoke(null, requestAttributes, true);
                }
                catch (Throwable rch) {
                    // empty catch block
                }
                UnloggedSpringAuthentication authInstance = null;
                Object usa = null;
                Object mockedContext = new Object();
                RequestAuthentication requestAuthentication = agentCommandRequest.getRequestAuthentication();
                if (requestAuthentication != null && requestAuthentication.getPrincipalClassName() != null) {
                    Object principalObject;
                    String principalString = String.valueOf(requestAuthentication.getPrincipal());
                    String userPrincipalClassName = requestAuthentication.getPrincipalClassName();
                    if (userPrincipalClassName.equals("org.springframework.security.core.userdetails.User")) {
                        principalObject = "DUMMY_USER";
                    } else {
                        try {
                            principalObject = this.objectMapper.readValue(principalString, Class.forName(userPrincipalClassName));
                        }
                        catch (Exception classNotFoundException) {
                            principalObject = classNotFoundException;
                        }
                    }
                    requestAuthentication.setPrincipal(principalObject);
                    if (this.springTestContextManager != null) {
                        try {
                            Class<?> authClass = Class.forName("org.springframework.security.core.Authentication");
                            Class springAuthImplementatorClass = this.byteBuddyInstance.subclass(UnloggedSpringAuthentication.class).implement(authClass).make().load(targetClassLoader).getLoaded();
                            authInstance = (UnloggedSpringAuthentication)springAuthImplementatorClass.getConstructor(RequestAuthentication.class).newInstance(requestAuthentication);
                            mockedContext = Class.forName("org.springframework.security.core.context.SecurityContextImpl").getConstructor(authClass).newInstance(authInstance);
                        }
                        catch (Exception e4) {
                            System.err.println("warn: failed to set authentication for request: " + e4.getMessage());
                        }
                    }
                }
                Method methodToExecute = this.getMethodToExecute(targetClassType, agentCommandRequest.getMethodName(), expectedMethodArgumentTypes);
                methodToExecute.setAccessible(true);
                Class<?>[] parameterTypesClass = methodToExecute.getParameterTypes();
                try {
                    List<String> parsedSignature = MethodSignatureParser.parseMethodSignature(agentCommandRequest.getMethodSignature());
                    parsedSignature.remove(parsedSignature.size() - 1);
                    parameters = this.buildParametersUsingTargetClass(targetClassLoader, methodParameters, parameterTypesClass, parsedSignature);
                }
                catch (InvalidDefinitionException ide1) {
                    if (targetClassLoader.equals(targetClassLoader1)) throw ide1;
                    parameters = this.buildParametersUsingTargetClass(targetClassLoader, methodParameters, parameterTypesClass, agentCommandRequest.getParameterTypes());
                }
                agentCommandResponse.setTargetClassName(targetClassName);
                agentCommandResponse.setTargetMethodName(agentCommandRequest.getMethodName());
                agentCommandResponse.setTargetMethodSignature(agentCommandRequest.getMethodSignature());
                agentCommandResponse.setTimestamp(new Date().getTime());
                List<DeclaredMock> declaredMocksList = agentCommandRequest.getDeclaredMocks();
                objectInstanceByClass = this.arrangeMocks(targetClassType, targetClassLoader, objectInstanceByClass, declaredMocksList);
                Class<?> SECURITY_CONTEXT_KEY = null;
                try {
                    SECURITY_CONTEXT_KEY = Class.forName("org.springframework.security.core.context.SecurityContext");
                    this.isSpringPresent = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if ((methodToExecute.getReturnType().getCanonicalName().startsWith("reactor.core.publisher.Mono") || methodToExecute.getReturnType().getCanonicalName().startsWith("reactor.core.publisher.Flux")) && this.springTestContextManager != null && this.springTestContextManager.getClass().getCanonicalName().contains("AnnotationConfigReactiveWebServerApplicationContext")) {
                    HashMap resultContainer = new HashMap();
                    Mono securityContext = Mono.just((Object)mockedContext);
                    Object finalObjectInstanceByClass = objectInstanceByClass;
                    Object[] finalParameters = parameters;
                    assert (SECURITY_CONTEXT_KEY != null);
                    Class<?> finalSECURITY_CONTEXT_KEY = SECURITY_CONTEXT_KEY;
                    CountDownLatch cdl = new CountDownLatch(1);
                    Mono.defer(() -> {
                        try {
                            this.logger.setRecordingPaused(false);
                            Object returnValue = methodToExecute.invoke(finalObjectInstanceByClass, finalParameters);
                            if (returnValue instanceof Mono) {
                                return (Mono)returnValue;
                            }
                            if (returnValue instanceof Flux) {
                                return ((Flux)returnValue).collectList();
                            }
                            return Mono.justOrEmpty((Object)returnValue);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            return Mono.error((Throwable)e);
                        }
                    }).contextWrite(ctx -> {
                        if (finalSECURITY_CONTEXT_KEY != null) {
                            return ctx.put((Object)finalSECURITY_CONTEXT_KEY, (Object)securityContext);
                        }
                        return ctx;
                    }).doOnSuccess(result -> {
                        resultContainer.put("returnValue", result);
                        cdl.countDown();
                    }).doOnError(error -> {
                        resultContainer.put("exception", error);
                        cdl.countDown();
                    }).doFinally(e -> this.logger.setRecordingPaused(true)).subscribe();
                    cdl.await();
                    if (!resultContainer.containsKey("returnValue")) throw (Throwable)resultContainer.get("exception");
                    methodReturnValue = resultContainer.get("returnValue");
                } else {
                    try {
                        Class<?> sch = Class.forName("org.springframework.security.core.context.SecurityContextHolder");
                        Method gcm = sch.getMethod("getContext", new Class[0]);
                        Object contextInstance = gcm.invoke(null, new Object[0]);
                        Class<?> authenticationClass = Class.forName("org.springframework.security.core.Authentication");
                        Method setMethod = contextInstance.getClass().getMethod("setAuthentication", authenticationClass);
                        setMethod.invoke(contextInstance, authInstance);
                    }
                    catch (Exception sch) {
                        // empty catch block
                    }
                    this.logger.setRecordingPaused(false);
                    methodReturnValue = methodToExecute.invoke(objectInstanceByClass, parameters);
                    this.logger.setRecordingPaused(true);
                }
                Object serializedValue = this.serializeMethodReturnValue(methodReturnValue);
                agentCommandResponse.setMethodReturnValue(serializedValue);
                agentCommandResponse.setResponseClassName(methodToExecute.getReturnType().getCanonicalName());
                agentCommandResponse.setResponseType(ResponseType.NORMAL);
                agentCommandRawResponse.setResponseObject(methodReturnValue);
                AgentCommandRawResponse agentCommandRawResponse3 = agentCommandRawResponse;
                this.closeHibernateSessionIfPossible(sessionInstance);
                return agentCommandRawResponse3;
            }
            catch (Throwable exception) {
                try {
                    try {
                        if (exception instanceof InvocationTargetException) {
                            agentCommandResponse.setResponseType(ResponseType.EXCEPTION);
                            exception.getCause().printStackTrace();
                        } else {
                            agentCommandResponse.setResponseType(ResponseType.FAILED);
                        }
                        Throwable exceptionCause = exception.getCause() != null ? exception.getCause() : exception;
                        agentCommandResponse.setMessage(exceptionCause.getMessage());
                        agentCommandRawResponse.setResponseObject(exceptionCause);
                        try {
                            agentCommandResponse.setMethodReturnValue(this.objectMapper.writeValueAsString(exceptionCause));
                        }
                        catch (Throwable e5) {
                            agentCommandResponse.setMethodReturnValue("Exception: " + exceptionCause.getMessage());
                            agentCommandResponse.setMessage("Exception: " + exceptionCause.getMessage());
                        }
                        agentCommandResponse.setResponseClassName(exceptionCause.getClass().getCanonicalName());
                        return agentCommandRawResponse;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        this.closeHibernateSessionIfPossible(sessionInstance);
                    }
                }
                catch (Throwable exception2) {
                    Throwable exceptionCause = exception2.getCause() != null ? exception2.getCause() : exception2;
                    agentCommandResponse.setMessage(exceptionCause.getMessage());
                    try {
                        agentCommandRawResponse.setResponseObject(exceptionCause);
                        agentCommandResponse.setMethodReturnValue(this.objectMapper.writeValueAsString(exceptionCause));
                    }
                    catch (Throwable e6) {
                        agentCommandResponse.setMethodReturnValue("Exception: " + exceptionCause.getMessage());
                        agentCommandResponse.setMessage("Exception: " + exceptionCause.getMessage());
                    }
                    agentCommandResponse.setResponseClassName(exceptionCause.getClass().getCanonicalName());
                    agentCommandResponse.setResponseType(ResponseType.FAILED);
                    return agentCommandRawResponse;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.logger.setRecordingPaused(false);
        }
    }

    private AnnotationDescription getAnnotationDescription(String className) throws ClassNotFoundException {
        Class<?> springBootTestAnnotationClass = Class.forName(className);
        AnnotationDescription springBootTestAnnotation = AnnotationDescription.Builder.ofType(springBootTestAnnotationClass).build();
        return springBootTestAnnotation;
    }

    @Override
    public AgentCommandResponse executeCommand(AgentCommandRequest agentCommandRequest) {
        AgentCommandRawResponse rawResponse = this.executeCommandRaw(agentCommandRequest);
        return rawResponse.getAgentCommandResponse();
    }

    @Override
    public AgentCommandResponse injectMocks(AgentCommandRequest agentCommandRequest) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException, NoSuchFieldException, SecurityException {
        int fieldCount = 0;
        int classCount = 0;
        Map<String, List<DeclaredMock>> mocksBySourceClass = agentCommandRequest.getDeclaredMocks().stream().collect(Collectors.groupingBy(DeclaredMock::getSourceClassName));
        for (String sourceClassName : mocksBySourceClass.keySet()) {
            ArrayList<Object> beansToInject = new ArrayList<Object>();
            Class<?> targetClassObject = Class.forName(sourceClassName);
            Object sourceClassInstance1 = this.logger.getObjectByClassName(sourceClassName);
            if (sourceClassInstance1 != null) {
                beansToInject.add(sourceClassInstance1);
            }
            this.loadContext();
            List<Object> objectsFromSpringObject = this.getObjectsFromSpringContext(targetClassObject);
            beansToInject.addAll(objectsFromSpringObject);
            if (beansToInject.size() == 0) {
                ClassLoader classLoader = sourceClassInstance1.getClass().getClassLoader();
                Object anInstance = this.parameterFactory.createObjectInstanceFromStringAndTypeInformation(sourceClassName, "{}", targetClassObject, this.objectMapper.getTypeFactory().withClassLoader(classLoader));
                this.ourOwnObjects.put(sourceClassName, anInstance);
                beansToInject.add(anInstance);
            }
            List<DeclaredMock> declaredMocks = mocksBySourceClass.get(sourceClassName);
            Map<String, List<DeclaredMock>> mocksByField = declaredMocks.stream().collect(Collectors.groupingBy(DeclaredMock::getFieldName));
            for (Object e : beansToInject) {
                Class<?> classObject;
                ClassLoader targetClassLoader = e.getClass().getClassLoader();
                String targetClassName = classObject.getCanonicalName();
                for (classObject = e.getClass(); classObject != Object.class; classObject = classObject.getSuperclass()) {
                    Field[] availableFields;
                    ++classCount;
                    for (Field field : availableFields = classObject.getDeclaredFields()) {
                        String fieldName = field.getName();
                        if (!mocksByField.containsKey(fieldName)) continue;
                        List<DeclaredMock> declaredMocksForField = mocksByField.get(fieldName);
                        String key = sourceClassName + "#" + fieldName;
                        MockInstance existingMockInstance = this.globalFieldMockMap.get(key);
                        field.setAccessible(true);
                        Object originalFieldValue = null;
                        try {
                            originalFieldValue = field.get(e);
                        }
                        catch (IllegalAccessException e2) {
                            System.err.println("Failed to access field [" + targetClassName + "#" + fieldName + "] => " + e2.getMessage());
                            continue;
                        }
                        if (existingMockInstance == null) {
                            Class<?> loadedMockedField;
                            MockHandler mockHandler = new MockHandler(declaredMocksForField, this.objectMapper, this.parameterFactory, this.objenesis, originalFieldValue, e, targetClassLoader, field);
                            Class<?> fieldType = field.getType();
                            try {
                                Class<?> fieldTypeFromMockDefinition = Class.forName(declaredMocks.get(0).getFieldTypeName());
                                if (fieldType.isAssignableFrom(fieldTypeFromMockDefinition)) {
                                    fieldType = fieldTypeFromMockDefinition;
                                }
                            }
                            catch (Exception fieldTypeFromMockDefinition) {
                                // empty catch block
                            }
                            try {
                                loadedMockedField = this.createInstanceUsingByteBuddy(targetClassLoader, mockHandler, fieldType);
                            }
                            catch (Throwable t) {
                                System.err.println("Failed to create instance of class: " + fieldType.getCanonicalName() + " " + fieldName);
                                continue;
                            }
                            Object mockedFieldInstance = this.objenesis.newInstance(loadedMockedField);
                            existingMockInstance = new MockInstance(mockedFieldInstance, mockHandler);
                            this.globalFieldMockMap.put(key, existingMockInstance);
                        } else {
                            existingMockInstance.getMockHandler().setDeclaredMocks(declaredMocksForField);
                        }
                        try {
                            field.set(e, existingMockInstance.getMockedFieldInstance());
                        }
                        catch (IllegalAccessException e3) {
                            System.err.println("Failed to mock field [" + sourceClassName + "#" + fieldName + "] =>" + e3.getMessage());
                        }
                        ++fieldCount;
                    }
                }
            }
        }
        AgentCommandResponse agentCommandResponse = new AgentCommandResponse();
        agentCommandResponse.setResponseType(ResponseType.NORMAL);
        agentCommandResponse.setMessage("Mocks injected for [" + fieldCount + "] fields in [" + classCount + "] classes");
        return agentCommandResponse;
    }

    private List<Object> getObjectsFromSpringContext(Class<?> targetClassObject) {
        ArrayList<Object> beansToInject = new ArrayList<Object>();
        if (this.applicationContext != null) {
            String[] beanNames = new String[]{};
            try {
                beanNames = (String[])this.getBeanDefinitionNamesMethod.invoke(this.applicationContext, targetClassObject, true, true);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            for (String beanName : beanNames) {
                Object bean = null;
                try {
                    bean = this.getBeanByBeanNameMethod.invoke(this.applicationContext, beanName);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                beansToInject.add(bean);
            }
        }
        return beansToInject;
    }

    private Class<?> createInstanceUsingByteBuddy(ClassLoader targetClassLoader, MockHandler mockHandler, Class<?> classType) {
        DynamicType.Loaded loadedMockedField;
        ClassLoadingStrategy.Default strategy = ClassLoadingStrategy.Default.INJECTION;
        if (classType.isInterface()) {
            Class<?>[] implementedInterfaces = this.parameterFactory.getAllInterfaces(classType);
            HashSet<String> implementedClasses = new HashSet<String>();
            implementedClasses.add(classType.getCanonicalName());
            ArrayList pendingImplementations = new ArrayList();
            pendingImplementations.add(classType);
            for (Class<?> implementedInterface : implementedInterfaces) {
                if (implementedClasses.contains(implementedInterface.getCanonicalName())) continue;
                implementedClasses.add(implementedInterface.getCanonicalName());
                pendingImplementations.add(implementedInterface);
            }
            String fameImplClassName = classType.getCanonicalName() + "$UnloggedFakeInterfaceImpl";
            try {
                Class<?> alreadyExist = targetClassLoader.loadClass(fameImplClassName);
                return alreadyExist;
            }
            catch (Exception exception) {
                loadedMockedField = this.byteBuddyInstance.subclass(Object.class).name(classType.getCanonicalName() + "$UnloggedFakeInterfaceImpl").implement(pendingImplementations).intercept(MethodDelegation.to(mockHandler)).make().load(targetClassLoader, strategy);
            }
        } else {
            String fameImplClassName = classType.getCanonicalName() + "$UnloggedFakeImpl";
            try {
                Class<?> alreadyExist = targetClassLoader.loadClass(fameImplClassName);
                return alreadyExist;
            }
            catch (Exception exception) {
                loadedMockedField = this.byteBuddyInstance.subclass(classType).name(fameImplClassName).method(ElementMatchers.isDeclaredBy(classType)).intercept(MethodDelegation.to(mockHandler)).make().load(targetClassLoader, strategy);
            }
        }
        return loadedMockedField.getLoaded();
    }

    @Override
    public AgentCommandResponse removeMocks(AgentCommandRequest agentCommandRequest) throws Exception {
        HashMap mocksByClassName;
        int fieldCount = 0;
        int classCount = 0;
        HashSet<String> strings = new HashSet<String>(this.globalFieldMockMap.keySet());
        HashSet<String> classNames = new HashSet<String>();
        List<DeclaredMock> mocksToDelete = agentCommandRequest.getDeclaredMocks();
        Map<Object, Object> map = mocksByClassName = mocksToDelete == null ? new HashMap() : mocksToDelete.stream().collect(Collectors.groupingBy(DeclaredMock::getSourceClassName));
        if (mocksByClassName.size() > 0) {
            for (String sourceClassName : mocksByClassName.keySet()) {
                Map<String, List<DeclaredMock>> classMocksByFieldName = ((List)mocksByClassName.get(sourceClassName)).stream().collect(Collectors.groupingBy(DeclaredMock::getFieldName));
                for (String fieldName : classMocksByFieldName.keySet()) {
                    String key = sourceClassName + "#" + fieldName;
                    MockInstance mockInstance = this.globalFieldMockMap.get(key);
                    if (mockInstance == null) continue;
                    if (!classNames.contains(sourceClassName)) {
                        classNames.add(sourceClassName);
                        ++classCount;
                    }
                    ++fieldCount;
                    MockHandler mockHandler = mockInstance.getMockHandler();
                    mockHandler.removeDeclaredMock(classMocksByFieldName.get(fieldName));
                }
            }
        } else {
            for (String key : strings) {
                ++fieldCount;
                MockInstance mockInstance = this.globalFieldMockMap.get(key);
                MockHandler mockHandler = mockInstance.getMockHandler();
                Object parentInstance = mockHandler.getOriginalFieldParent();
                String sourceObjectTypeName = parentInstance.getClass().getCanonicalName();
                if (!classNames.contains(sourceObjectTypeName)) {
                    classNames.add(sourceObjectTypeName);
                    ++classCount;
                }
                Object originalFieldInstance = mockHandler.getOriginalImplementation();
                Field field = mockHandler.getField();
                field.setAccessible(true);
                field.set(parentInstance, originalFieldInstance);
                this.globalFieldMockMap.remove(key);
            }
        }
        AgentCommandResponse agentCommandResponse = new AgentCommandResponse();
        agentCommandResponse.setResponseType(ResponseType.NORMAL);
        agentCommandResponse.setMessage("Mocks removed for [" + fieldCount + "] fields in [" + classCount + "] classes");
        return agentCommandResponse;
    }

    public Object arrangeMocks(Class<?> targetClassType, ClassLoader targetClassLoader, Object objectInstanceByClass, List<DeclaredMock> declaredMocksList) {
        Object extendedClassInstance;
        if (declaredMocksList == null || declaredMocksList.size() == 0) {
            return objectInstanceByClass;
        }
        HashMap<String, MockInstance> mockInstanceMap = new HashMap<String, MockInstance>();
        String targetClassName = targetClassType.getCanonicalName();
        Map mocksByFieldName = declaredMocksList.stream().collect(Collectors.groupingBy(DeclaredMock::getFieldName, Collectors.toList()));
        if (Modifier.isFinal(targetClassType.getModifiers())) {
            extendedClassInstance = objectInstanceByClass;
        } else {
            ClassLoadingStrategy<ClassLoader> strategy;
            DynamicType.Builder.FieldDefinition.Optional extendedClassBuilder = this.byteBuddyInstance.subclass(targetClassType).field(ElementMatchers.any()).transform(Transformer.ForField.withModifiers(new ModifierContributor.ForField(){

                @Override
                public int getMask() {
                    return 16;
                }

                @Override
                public int getRange() {
                    return 0;
                }

                @Override
                public boolean isDefault() {
                    return false;
                }
            }));
            DynamicType.Unloaded extendedClass = extendedClassBuilder.make();
            if (ClassInjector.UsingLookup.isAvailable()) {
                Class<?> methodHandles = null;
                try {
                    methodHandles = targetClassLoader.loadClass("java.lang.invoke.MethodHandles");
                    Object lookup = methodHandles.getMethod("lookup", new Class[0]).invoke(null, new Object[0]);
                    Method privateLookupIn = methodHandles.getMethod("privateLookupIn", Class.class, targetClassLoader.loadClass("java.lang.invoke.MethodHandles$Lookup"));
                    Object privateLookup = privateLookupIn.invoke(null, targetClassType, lookup);
                    strategy = ClassLoadingStrategy.UsingLookup.of(privateLookup);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else if (ClassInjector.UsingReflection.isAvailable()) {
                strategy = ClassLoadingStrategy.Default.INJECTION;
            } else {
                throw new IllegalStateException("No code generation strategy available");
            }
            DynamicType.Loaded extendedClassLoaded = extendedClass.load(targetClassLoader, strategy);
            extendedClassInstance = this.objenesis.newInstance(extendedClassLoaded.getLoaded());
        }
        Map<String, Field> fieldMap = this.getFieldMap(extendedClassInstance.getClass());
        for (Class<?> fieldCopyForClass = targetClassType; fieldCopyForClass != null && !fieldCopyForClass.equals(Object.class); fieldCopyForClass = fieldCopyForClass.getSuperclass()) {
            Field[] declaredFields;
            for (Field field : declaredFields = fieldCopyForClass.getDeclaredFields()) {
                try {
                    Field fieldToSet = fieldMap.get(field.getName());
                    field.setAccessible(true);
                    fieldToSet.setAccessible(true);
                    List<DeclaredMock> declaredMocksForField = mocksByFieldName.get(field.getName());
                    Object fieldValue = field.get(objectInstanceByClass);
                    boolean fieldTypeIsFinal = Modifier.isFinal(field.getType().getModifiers());
                    if (declaredMocksForField == null || declaredMocksForField.size() == 0 || fieldTypeIsFinal) {
                        if (fieldValue == null) {
                            try {
                                fieldValue = this.objenesis.newInstance(field.getType());
                            }
                            catch (Throwable e) {
                                continue;
                            }
                        }
                        try {
                            fieldToSet.set(extendedClassInstance, fieldValue);
                        }
                        catch (Throwable e) {}
                        continue;
                    }
                    String key = targetClassName + "#" + field.getName();
                    MockInstance existingMockInstance = (MockInstance)mockInstanceMap.get(key);
                    if (existingMockInstance == null) {
                        if (objectInstanceByClass == null) {
                            System.err.println("original instance is null [" + field.getType().getCanonicalName() + " " + field.getName());
                        }
                        if (fieldValue == null) {
                            try {
                                fieldValue = this.parameterFactory.createObjectInstanceFromStringAndTypeInformation(field.getType().getCanonicalName(), "{}", field.getType(), this.objectMapper.getTypeFactory().withClassLoader(targetClassLoader));
                            }
                            catch (Exception e) {
                                fieldValue = null;
                            }
                        }
                        String fieldTypeName = declaredMocksForField.get(0).getFieldTypeName();
                        JavaType typeReference = MockHandler.getTypeReference(this.objectMapper.getTypeFactory(), fieldTypeName);
                        Class<?> classTypeToBeMocked = typeReference.getRawClass();
                        existingMockInstance = this.parameterFactory.createMockedInstance(targetClassLoader, objectInstanceByClass, field, declaredMocksForField, fieldValue, classTypeToBeMocked);
                        mockInstanceMap.put(key, existingMockInstance);
                    } else {
                        existingMockInstance.getMockHandler().setDeclaredMocks(declaredMocksForField);
                    }
                    fieldToSet.set(extendedClassInstance, existingMockInstance.getMockedFieldInstance());
                }
                catch (Exception e) {
                    if (e.getMessage().startsWith("Can not set static final")) continue;
                    e.printStackTrace();
                    System.err.println("Failed to set value for field [" + field.getName() + "] => " + e.getMessage());
                }
            }
        }
        return extendedClassInstance;
    }

    private Map<String, Field> getFieldMap(Class<?> extendedClassInstance) {
        HashMap<String, Field> map = new HashMap<String, Field>();
        for (Class<?> currentClass = extendedClassInstance; currentClass != null && !Object.class.equals(currentClass); currentClass = currentClass.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = currentClass.getDeclaredFields()) {
                if (map.containsKey(field.getName())) continue;
                map.put(field.getName(), field);
            }
        }
        return map;
    }

    private Method getMethodToExecute(Class<?> objectClass, String expectedMethodName, JavaType[] expectedMethodArgumentTypes) throws NoSuchMethodException {
        StringBuilder className = new StringBuilder();
        Method methodToExecute = null;
        ArrayList<String> methodNamesList = new ArrayList<String>();
        while (objectClass != null && !objectClass.equals(Object.class)) {
            className.append(objectClass.getCanonicalName()).append(", ");
            int argsCount = expectedMethodArgumentTypes.length;
            try {
                Class[] paramClassNames = new Class[argsCount];
                for (int i = 0; i < argsCount; ++i) {
                    Class<?> rawClass;
                    paramClassNames[i] = rawClass = expectedMethodArgumentTypes[i].getRawClass();
                }
                methodToExecute = objectClass.getDeclaredMethod(expectedMethodName, paramClassNames);
            }
            catch (NoSuchMethodException paramClassNames) {
                // empty catch block
            }
            if (methodToExecute == null) {
                Method[] methods;
                for (Method method : methods = objectClass.getDeclaredMethods()) {
                    String methodName = method.getName();
                    methodNamesList.add(methodName);
                    if (!methodName.equals(expectedMethodName) || method.getParameterCount() != argsCount) continue;
                    Class<?>[] actualParameterTypes = method.getParameterTypes();
                    boolean match = true;
                    for (int i = 0; i < argsCount; ++i) {
                        Class<?> methodParameterType = expectedMethodArgumentTypes[i].getRawClass();
                        Class<?> actualParamType = actualParameterTypes[i];
                        if (actualParamType.getCanonicalName().equals(methodParameterType.getCanonicalName())) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    methodToExecute = method;
                    break;
                }
            }
            if (methodToExecute != null) break;
            objectClass = objectClass.getSuperclass();
        }
        if (methodToExecute == null) {
            System.err.println("Method not found: " + expectedMethodName + ", methods were: " + methodNamesList);
            throw new NoSuchMethodException("method not found [" + expectedMethodName + "] in class [" + className + "]. Available methods are: " + methodNamesList);
        }
        return methodToExecute;
    }

    public Object serializeMethodReturnValue(Object methodReturnValue) {
        if (methodReturnValue == null) {
            return null;
        }
        if (methodReturnValue instanceof Double) {
            return Double.doubleToLongBits((Double)methodReturnValue);
        }
        if (methodReturnValue instanceof Float) {
            return Float.floatToIntBits(((Float)methodReturnValue).floatValue());
        }
        if (methodReturnValue instanceof String) {
            return methodReturnValue;
        }
        try {
            if (methodReturnValue.getClass().getCanonicalName().startsWith("reactor.core.publisher.Flux")) {
                Flux returnedFlux = (Flux)methodReturnValue;
                CountDownLatch cdl = new CountDownLatch(1);
                StringBuffer returnValue = new StringBuffer();
                returnedFlux.collectList().doOnError(e -> {
                    try {
                        e.printStackTrace();
                        returnValue.append(this.objectMapper.writeValueAsString(e));
                    }
                    catch (JsonProcessingException ex) {
                        returnValue.append(e.getMessage());
                    }
                    finally {
                        cdl.countDown();
                    }
                }).subscribe(e -> {
                    try {
                        returnValue.append(this.objectMapper.writeValueAsString(e));
                    }
                    catch (JsonProcessingException ex) {
                        try {
                            returnValue.append(this.objectMapper.writeValueAsString(ex));
                        }
                        catch (JsonProcessingException exc) {
                            returnValue.append(ex.getMessage());
                        }
                    }
                    finally {
                        cdl.countDown();
                    }
                });
                cdl.await();
                return returnValue.toString();
            }
            if (methodReturnValue.getClass().getCanonicalName().startsWith("reactor.core.publisher.Mono")) {
                Mono returnedMono = (Mono)methodReturnValue;
                CountDownLatch cdl = new CountDownLatch(1);
                StringBuffer returnValue = new StringBuffer();
                Object finalMethodReturnValue = methodReturnValue;
                returnedMono.log().subscribe(e -> {
                    try {
                        returnValue.append(this.objectMapper.writeValueAsString(e));
                    }
                    catch (JsonProcessingException ex) {
                        try {
                            returnValue.append(this.objectMapper.writeValueAsString(ex));
                        }
                        catch (JsonProcessingException exc) {
                            returnValue.append("{\"className\": \"" + finalMethodReturnValue.getClass().getCanonicalName() + "\"}");
                        }
                    }
                    finally {
                        cdl.countDown();
                    }
                }, e -> {
                    try {
                        returnValue.append(this.objectMapper.writeValueAsString(e));
                    }
                    catch (JsonProcessingException ex) {
                        try {
                            returnValue.append(this.objectMapper.writeValueAsString(ex));
                        }
                        catch (JsonProcessingException exc) {
                            returnValue.append("{\"className\": \"" + finalMethodReturnValue.getClass().getCanonicalName() + "\"}");
                        }
                    }
                    finally {
                        cdl.countDown();
                    }
                }, cdl::countDown);
                cdl.await();
                return returnValue.toString();
            }
            if (methodReturnValue instanceof Future) {
                methodReturnValue = ((Future)methodReturnValue).get();
            }
            return this.objectMapper.writeValueAsString(methodReturnValue);
        }
        catch (Exception ide) {
            return "{\"className\": \"" + methodReturnValue.getClass().getCanonicalName() + "\"}";
        }
    }

    private Object[] buildParametersUsingTargetClass(ClassLoader targetClassLoader, List<String> methodParameters, Class<?>[] parameterTypesClass, List<String> parameterTypes) throws JsonProcessingException {
        TypeFactory typeFactory = this.objectMapper.getTypeFactory().withClassLoader(targetClassLoader);
        Object[] parameters = new Object[methodParameters.size()];
        for (int i = 0; i < methodParameters.size(); ++i) {
            Object parameterObject;
            String methodParameterStringValue = methodParameters.get(i);
            Class<?> parameterType = parameterTypesClass[i];
            String parameterTypeName = parameterTypes.get(i);
            try {
                parameterObject = this.parameterFactory.createObjectInstanceFromStringAndTypeInformation(parameterTypeName, methodParameterStringValue, parameterType, typeFactory);
            }
            catch (Exception e) {
                System.err.println("Failed to create paramter of type [" + parameterTypeName + "] from source " + methodParameterStringValue + " => " + e.getMessage());
                e.printStackTrace();
                parameterObject = null;
            }
            parameters[i] = parameterObject;
        }
        return parameters;
    }

    private Object tryObjectConstruct(String className, ClassLoader targetClassLoader, Map<String, Object> buildMap) throws IllegalAccessException {
        Class<?> loadedClass;
        if (className.equals("java.util.List")) {
            return new ArrayList();
        }
        if (className.equals("java.util.Map")) {
            return new HashMap();
        }
        Object newInstance = null;
        if (targetClassLoader == null) {
            System.err.println("Failed to construct instance of class [" + className + "]. classLoader is not defined");
        }
        try {
            loadedClass = targetClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (className.lastIndexOf(".") == -1) {
                return null;
            }
            String parentName = className.substring(0, className.lastIndexOf("."));
            try {
                Class<?> parentClassType = targetClassLoader.loadClass(parentName);
                loadedClass = targetClassLoader.loadClass(parentName + "$" + className.substring(className.lastIndexOf(".") + 1));
            }
            catch (ClassNotFoundException cne) {
                return null;
            }
        }
        Constructor<?> noArgsConstructor = null;
        noArgsConstructor = null;
        Constructor<?>[] declaredConstructors = loadedClass.getDeclaredConstructors();
        if (declaredConstructors.length > 0) {
            noArgsConstructor = declaredConstructors[0];
        }
        for (Constructor<?> declaredConstructor : declaredConstructors) {
            if (declaredConstructor.getParameterCount() != 0) continue;
            noArgsConstructor = declaredConstructor;
            break;
        }
        try {
            noArgsConstructor.setAccessible(true);
            int paramCount = noArgsConstructor.getParameterCount();
            Class<?>[] paramTypes = noArgsConstructor.getParameterTypes();
            Object[] parameters = new Object[paramCount];
            for (int i = 0; i < paramCount; ++i) {
                String typeName = paramTypes[i].getCanonicalName();
                Object paramValue = buildMap.get(typeName);
                if (paramValue == null) {
                    paramValue = this.tryObjectConstruct(typeName, targetClassLoader, buildMap);
                }
                parameters[i] = paramValue;
            }
            this.logger.setRecordingPaused(false);
            newInstance = noArgsConstructor.newInstance(parameters);
            this.logger.setRecordingPaused(true);
        }
        catch (Throwable paramCount) {
            // empty catch block
        }
        if (newInstance == null) {
            Method[] methods;
            for (Method method : methods = loadedClass.getMethods()) {
                if (method.getParameterCount() != 0 || !Modifier.isStatic(method.getModifiers()) || !method.getReturnType().equals(loadedClass)) continue;
                try {
                    this.logger.setRecordingPaused(false);
                    Object invoke = method.invoke(null, new Object[0]);
                    this.logger.setRecordingPaused(true);
                    return invoke;
                }
                catch (InvocationTargetException invoke) {
                    // empty catch block
                }
            }
        }
        if (newInstance == null) {
            try {
                newInstance = this.objenesis.newInstance(loadedClass);
            }
            catch (Throwable methods) {
                // empty catch block
            }
        }
        if (newInstance == null) {
            try {
                MockHandler mockHandler = new MockHandler(new ArrayList<DeclaredMock>(), this.objectMapper, this.parameterFactory, this.objenesis, null, null, targetClassLoader, null);
                Class<?> newInstanceLoader = this.createInstanceUsingByteBuddy(targetClassLoader, mockHandler, loadedClass);
                newInstance = this.objenesis.newInstance(newInstanceLoader);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        buildMap.put(className, newInstance);
        if (newInstance == null) {
            return newInstance;
        }
        for (Class<?> fieldsForClass = loadedClass; fieldsForClass != null && !fieldsForClass.equals(Object.class); fieldsForClass = fieldsForClass.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = fieldsForClass.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers)) continue;
                try {
                    field.setAccessible(true);
                }
                catch (Exception e) {
                    continue;
                }
                String fieldTypeName = field.getType().getCanonicalName();
                Object value = field.get(newInstance);
                if (value != null) continue;
                if (buildMap.containsKey(fieldTypeName)) {
                    value = buildMap.get(fieldTypeName);
                } else {
                    value = this.tryObjectConstruct(fieldTypeName, targetClassLoader, buildMap);
                    if (value == null) continue;
                    buildMap.put(fieldTypeName, value);
                }
                try {
                    field.set(newInstance, value);
                }
                catch (Throwable th) {
                    th.printStackTrace();
                    System.out.println("Failed to set field value: " + th.getMessage());
                }
            }
        }
        return newInstance;
    }

    private Object trySpringTransaction() {
        try {
            Class<?> transactionManagerClass = Class.forName("org.springframework.transaction.TransactionManager");
            Object transactionManager = this.getBeanMethod.invoke(this.applicationContext, transactionManagerClass);
            transactionManagerClass.getMethod("getTransaction", new Class[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private Object tryOpenHibernateSessionIfHibernateExists() {
        Object hibernateSessionFactory = this.logger.getObjectByClassName("org.hibernate.internal.SessionFactoryImpl");
        if (hibernateSessionFactory == null && this.getBeanMethod != null && this.applicationContext != null) {
            try {
                hibernateSessionFactory = this.getBeanMethod.invoke(this.applicationContext, Class.forName("org.hibernate.SessionFactory"));
            }
            catch (ClassNotFoundException | IllegalAccessException | InvocationTargetException e) {
                return null;
            }
        }
        Object sessionInstance = null;
        if (hibernateSessionFactory != null) {
            try {
                Method openSessionMethod = hibernateSessionFactory.getClass().getMethod("openSession", new Class[0]);
                sessionInstance = openSessionMethod.invoke(hibernateSessionFactory, new Object[0]);
                Class<?> managedSessionContextClass = Class.forName("org.hibernate.context.internal.ManagedSessionContext");
                Method bindMethod = managedSessionContextClass.getMethod("bind", Class.forName("org.hibernate.Session"));
                bindMethod.invoke(null, sessionInstance);
                Method beginTransactionMethod = sessionInstance.getClass().getMethod("beginTransaction", new Class[0]);
                beginTransactionMethod.invoke(sessionInstance, new Object[0]);
                Class<?> PlatformTransactionManagerClass = Class.forName("org.springframework.transaction.PlatformTransactionManager");
                this.platformTransactionManagerBean = this.getBeanMethod.invoke(this.applicationContext, PlatformTransactionManagerClass);
                Constructor<?> DefaultTransactionDefinitionConstructor = Class.forName("org.springframework.transaction.support.DefaultTransactionDefinition").getDeclaredConstructor(new Class[0]);
                DefaultTransactionDefinitionConstructor.setAccessible(true);
                Object def = DefaultTransactionDefinitionConstructor.newInstance(new Object[0]);
                Method setNameMethod = def.getClass().getMethod("setName", String.class);
                setNameMethod.invoke(def, "unlogged-direct-invoke-transaction");
                Class<?> transactionDefinitionClass = Class.forName("org.springframework.transaction.TransactionDefinition");
                Field propagationRequiredField = transactionDefinitionClass.getDeclaredField("PROPAGATION_REQUIRED");
                propagationRequiredField.setAccessible(true);
                int propagationBehavior = (Integer)propagationRequiredField.get(null);
                Method setPropogationBehaviourMethod = def.getClass().getMethod("setPropagationBehavior", Integer.TYPE);
                setPropogationBehaviourMethod.invoke(def, propagationBehavior);
                Method getTransactionMethod = this.platformTransactionManagerBean.getClass().getMethod("getTransaction", Class.forName("org.springframework.transaction.TransactionDefinition"));
                this.springTransactionStatus = getTransactionMethod.invoke(this.platformTransactionManagerBean, def);
            }
            catch (Exception e) {
                return null;
            }
        }
        return sessionInstance;
    }

    private void trySpringIntegration(Class<?> testClass) {
        try {
            Class.forName("org.springframework.boot.SpringApplication");
            this.isSpringPresent = true;
            Annotation[] classAnnotations = testClass.getAnnotations();
            boolean hasEnableAutoConfigAnnotation = false;
            for (Annotation classAnnotation : classAnnotations) {
                if (!classAnnotation.annotationType().getCanonicalName().startsWith("org.springframework.")) continue;
                hasEnableAutoConfigAnnotation = true;
                break;
            }
            Class<?> testContextManagerClass = null;
            try {
                testContextManagerClass = Class.forName("org.springframework.test.context.TestContextManager");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!hasEnableAutoConfigAnnotation) {
                return;
            }
            this.springTestContextManager = testContextManagerClass.getConstructor(Class.class).newInstance(testClass);
            Method getTestContextMethod = testContextManagerClass.getMethod("getTestContext", new Class[0]);
            Class<?> testContextClass = Class.forName("org.springframework.test.context.TestContext");
            Method getApplicationContextMethod = testContextClass.getMethod("getApplicationContext", new Class[0]);
            Class<?> pspcClass = Class.forName("org.springframework.context.support.PropertySourcesPlaceholderConfigurer");
            Object propertySourcesPlaceholderConfigurer = pspcClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            Class<?> propertiesClass = Class.forName("java.util.Properties");
            Method pspcClassSetPropertiesMethod = pspcClass.getMethod("setProperties", propertiesClass);
            Class<?> yamlPropertiesFactoryBeanClass = Class.forName("org.springframework.beans.factory.config.YamlPropertiesFactoryBean");
            Object yaml = yamlPropertiesFactoryBeanClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            Method yamlGetObjectMethod = yamlPropertiesFactoryBeanClass.getMethod("getObject", new Class[0]);
            Class<?> classPathResourceClass = Class.forName("org.springframework.core.io.ClassPathResource");
            Object classPathResource = classPathResourceClass.getConstructor(String.class).newInstance("config/application.yml");
            Method setResourceMethod = yamlPropertiesFactoryBeanClass.getMethod("setResources", Class.forName("[Lorg.springframework.core.io.Resource;"));
            Method resourceExistsMethod = classPathResourceClass.getMethod("exists", new Class[0]);
            if (((Boolean)resourceExistsMethod.invoke(classPathResource, new Object[0])).booleanValue()) {
                setResourceMethod.invoke(yaml, classPathResource);
                Object yamlObject = yamlGetObjectMethod.invoke(yaml, new Object[0]);
                pspcClassSetPropertiesMethod.invoke(propertySourcesPlaceholderConfigurer, yamlObject);
            }
            Object testContext = getTestContextMethod.invoke(this.springTestContextManager, new Object[0]);
            Object applicationContext = getApplicationContextMethod.invoke(testContext, new Object[0]);
            Object factory = this.setSpringApplicationContextAndLoadBeanFactory(applicationContext);
            Method pspcProcessBeanFactoryMethod = pspcClass.getMethod("postProcessBeanFactory", Class.forName("org.springframework.beans.factory.config.ConfigurableListableBeanFactory"));
            pspcProcessBeanFactoryMethod.invoke(propertySourcesPlaceholderConfigurer, factory);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return;
        }
    }

    private Object setSpringApplicationContextAndLoadBeanFactory(Object applicationContext) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        try {
            if (applicationContext == null) {
                return null;
            }
            this.applicationContext = applicationContext;
            Class<?> applicationContextClass = Class.forName("org.springframework.context.ApplicationContext");
            this.getBeanMethod = applicationContextClass.getMethod("getBean", Class.class);
            this.getBeanByBeanNameMethod = applicationContextClass.getMethod("getBean", String.class);
            Method getAutowireCapableBeanFactoryMethod = applicationContextClass.getMethod("getAutowireCapableBeanFactory", new Class[0]);
            this.springBeanFactory = Class.forName("org.springframework.beans.factory.support.DefaultListableBeanFactory").cast(getAutowireCapableBeanFactoryMethod.invoke(applicationContext, new Object[0]));
            return this.springBeanFactory;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private void loadContext() {
        try {
            if (this.applicationContext != null) {
                return;
            }
            if (this.springTestContextManager == null) {
                this.springTestContextManager = this.logger.getObjectByClassName("org.springframework.boot.web.reactive.context.AnnotationConfigReactiveWebServerApplicationContext");
                this.setSpringApplicationContextAndLoadBeanFactory(this.springTestContextManager);
            }
            if (this.springTestContextManager == null) {
                this.springTestContextManager = this.logger.getObjectByClassName("org.springframework.boot.web.servlet.context.AnnotationConfigServletWebServerApplicationContext");
                this.setSpringApplicationContextAndLoadBeanFactory(this.springTestContextManager);
            }
            if (this.applicationContext != null) {
                Class<?> applicationContextClass = Class.forName("org.springframework.context.ApplicationContext");
                this.getBeanDefinitionNamesMethod = applicationContextClass.getMethod("getBeanNamesForType", Class.class, Boolean.TYPE, Boolean.TYPE);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void enableSpringIntegration(Class<?> testClass) {
        if (this.springTestContextManager == null) {
            this.trySpringIntegration(testClass);
        }
    }
}

