/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class MethodSignatureParser {
    public static List<String> parseMethodSignature(String signature) {
        ParseInfo parseInfo = new ParseInfo("", 1);
        ArrayList<String> parameterTypes = new ArrayList<String>();
        while (signature.charAt(parseInfo.getNewIndex()) != ')') {
            parseInfo = MethodSignatureParser.parseType(signature, parseInfo.getNewIndex());
            parameterTypes.add(parseInfo.getValue());
        }
        ParseInfo returnInfo = MethodSignatureParser.parseType(signature, parseInfo.getNewIndex() + 1);
        parameterTypes.add(returnInfo.getValue());
        return parameterTypes;
    }

    private static ParseInfo parseType(String signature, int index) {
        switch (signature.charAt(index)) {
            case 'L': {
                return MethodSignatureParser.parseComplexType(signature, index);
            }
            case '[': {
                return MethodSignatureParser.parseArrayType(signature, index);
            }
        }
        String value = String.valueOf(signature.charAt(index));
        return new ParseInfo(value, index + 1);
    }

    private static ParseInfo parseComplexType(String signature, int index) {
        ++index;
        StringBuilder type = new StringBuilder();
        while (index < signature.length() && signature.charAt(index) != ';') {
            if (signature.charAt(index) == '<') {
                ParseInfo obj = MethodSignatureParser.parseGenericType(signature, index);
                type.append(obj.getValue());
                index = obj.getNewIndex();
                continue;
            }
            type.append(signature.charAt(index));
            ++index;
        }
        return new ParseInfo(type.toString().replace('/', '.'), ++index);
    }

    private static ParseInfo parseGenericType(String signature, int index) {
        StringBuilder generic = new StringBuilder();
        ++index;
        generic.append('<');
        while (signature.charAt(index) != '>') {
            ParseInfo obj = MethodSignatureParser.parseType(signature, index);
            generic.append(obj.getValue());
            index = obj.getNewIndex();
            if (signature.charAt(index) == ',') {
                ++index;
            }
            if (signature.charAt(index) == '>') continue;
            generic.append(", ");
        }
        generic.append('>');
        return new ParseInfo(generic.toString(), ++index);
    }

    private static ParseInfo parseArrayType(String signature, int index) {
        ParseInfo componentType = MethodSignatureParser.parseType(signature, ++index);
        return new ParseInfo(componentType.getValue() + "[]", componentType.getNewIndex());
    }

    public static void main(String[] args) {
        HashMap<String, List<String>> signatureMap = new HashMap<String, List<String>>();
        signatureMap.put("(Ljava/util/Map<Ljava/lang/String;,Ljava/lang/Object;>;Ljakarta/servlet/http/HttpServletRequest;Ljakarta/servlet/http/HttpServletResponse;)Ljava/util/List<Lcom/rometools/rome/feed/atom/Entry;>;", Arrays.asList("java.util.Map<java.lang.String, java.lang.Object>", "jakarta.servlet.http.HttpServletRequest", "jakarta.servlet.http.HttpServletResponse", "java.util.List<com.rometools.rome.feed.atom.Entry>"));
        signatureMap.put("(JJ)V", Arrays.asList("J", "J", "V"));
        signatureMap.put("([J[[J)[V", Arrays.asList("J[]", "J[][]", "V[]"));
        signatureMap.put("(Ljava/util/List<Lorg/unlogged/demo/models/CustomerProfile;>;Z)Ljava/util/List<Lorg/unlogged/demo/models/CustomerProfile;>;", Arrays.asList("java.util.List<org.unlogged.demo.models.CustomerProfile>", "Z", "java.util.List<org.unlogged.demo.models.CustomerProfile>"));
        signatureMap.put("()Lorg/springframework/data/redis/core/ReactiveRedisOperations<Ljava/lang/String;,Lorg/unlogged/demo/models/Student;>;", Arrays.asList("org.springframework.data.redis.core.ReactiveRedisOperations<java.lang.String,org.unlogged.demo.models.Student>"));
        for (String signature : signatureMap.keySet()) {
            List<String> parameterTypes1 = MethodSignatureParser.parseMethodSignature(signature);
            parameterTypes1.forEach(System.out::println);
            List expectedResult = (List)signatureMap.get(signature);
            for (int i = 0; i < expectedResult.size(); ++i) {
                String actual;
                String expected = (String)expectedResult.get(i);
                if (Objects.equals(expected, actual = parameterTypes1.get(i))) continue;
                System.err.println("fail: expected [" + expected + "] vs actual [" + actual + "] at " + signature);
            }
        }
    }

    private static class ParseInfo {
        String value;
        int newIndex;

        public ParseInfo(String value, int newIndex) {
            this.value = value;
            this.newIndex = newIndex;
        }

        public String getValue() {
            return this.value;
        }

        public int getNewIndex() {
            return this.newIndex;
        }
    }
}

