/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.atomic;

import io.unlogged.atomic.AssertionResult;
import io.unlogged.atomic.AssertionType;
import io.unlogged.atomic.AtomicAssertion;
import io.unlogged.atomic.Expression;
import io.unlogged.logging.ObjectMapperFactory;
import java.util.List;
import java.util.Objects;
import selogger.com.fasterxml.jackson.core.JsonProcessingException;
import selogger.com.fasterxml.jackson.databind.JsonNode;
import selogger.com.fasterxml.jackson.databind.ObjectMapper;

public class AssertionEngine {
    private static final ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapperReactive();

    public static AssertionResult executeAssertions(AtomicAssertion assertion, JsonNode responseNode) {
        boolean result;
        AssertionResult assertionResult = new AssertionResult();
        if (assertion == null) {
            assertionResult.setPassing(true);
            return assertionResult;
        }
        AssertionType assertionType = assertion.getAssertionType();
        if (assertionType == AssertionType.ANYOF) {
            result = false;
            List<AtomicAssertion> subAssertions = assertion.getSubAssertions();
            for (AtomicAssertion subAssertion : subAssertions) {
                AssertionResult subResult = AssertionEngine.executeAssertions(subAssertion, responseNode);
                assertionResult.getResults().putAll(subResult.getResults());
                result = result || subResult.isPassing();
            }
        } else if (assertionType == AssertionType.ALLOF) {
            result = true;
            List<AtomicAssertion> subAssertions = assertion.getSubAssertions();
            for (AtomicAssertion subAssertion : subAssertions) {
                AssertionResult subResult = AssertionEngine.executeAssertions(subAssertion, responseNode);
                assertionResult.getResults().putAll(subResult.getResults());
                result = result && subResult.isPassing();
            }
        } else if (assertionType == AssertionType.NOTALLOF) {
            result = true;
            List<AtomicAssertion> subAssertions = assertion.getSubAssertions();
            for (AtomicAssertion subAssertion : subAssertions) {
                AssertionResult subResult = AssertionEngine.executeAssertions(subAssertion, responseNode);
                assertionResult.getResults().putAll(subResult.getResults());
                result = !subResult.isPassing();
            }
        } else if (assertionType == AssertionType.NOTANYOF) {
            result = false;
            List<AtomicAssertion> subAssertions = assertion.getSubAssertions();
            for (AtomicAssertion subAssertion : subAssertions) {
                AssertionResult subResult = AssertionEngine.executeAssertions(subAssertion, responseNode);
                assertionResult.getResults().putAll(subResult.getResults());
                result = result || !subResult.isPassing();
            }
        } else {
            String key = assertion.getKey();
            if (Objects.equals(key, "/")) {
                key = "";
            }
            JsonNode assertionActualValue = responseNode == null ? null : responseNode.at(key);
            Expression expression = assertion.getExpression();
            JsonNode expressedValue = assertionActualValue != null ? expression.compute(assertionActualValue) : assertionActualValue;
            JsonNode expectedValue = null;
            try {
                if (assertion.getExpectedValue() == null) {
                    result = assertionType.verify(expressedValue, null);
                }
                expectedValue = objectMapper.readTree(assertion.getExpectedValue());
                result = assertionType.verify(expressedValue, expectedValue);
            }
            catch (JsonProcessingException e) {
                try {
                    expectedValue = objectMapper.readTree("\"" + assertion.getExpectedValue() + "\"");
                    result = assertionType.verify(expressedValue, expectedValue);
                }
                catch (JsonProcessingException ex) {
                    result = false;
                }
            }
        }
        assertionResult.addResult(assertion, result);
        assertionResult.setPassing(result);
        return assertionResult;
    }
}

