/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.atomic;

import io.unlogged.atomic.AssertionType;
import io.unlogged.atomic.Expression;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

public class AtomicAssertion {
    List<AtomicAssertion> subAssertions = new ArrayList<AtomicAssertion>();
    private Expression expression = Expression.SELF;
    private String expectedValue;
    private String id = UUID.randomUUID().toString();
    private AssertionType assertionType = AssertionType.EQUAL;
    private String key;

    public AtomicAssertion() {
    }

    public AtomicAssertion(AtomicAssertion original) {
        if (original == null) {
            return;
        }
        this.expression = original.expression;
        this.assertionType = original.assertionType;
        this.key = original.key;
        this.id = original.id;
        this.expectedValue = original.expectedValue;
        this.subAssertions = original.subAssertions.stream().map(AtomicAssertion::new).collect(Collectors.toList());
    }

    public AtomicAssertion(Expression expression, AssertionType assertionType, String key, String expectedValue) {
        this.expression = expression;
        this.assertionType = assertionType;
        this.key = key;
        this.expectedValue = expectedValue;
    }

    public AtomicAssertion(AssertionType assertionType, String key, String expectedValue) {
        this.expression = Expression.SELF;
        this.assertionType = assertionType;
        this.key = key;
        this.expectedValue = expectedValue;
    }

    public AtomicAssertion(AssertionType assertionType, List<AtomicAssertion> subAssertions) {
        this.expression = Expression.SELF;
        if (assertionType == AssertionType.ANYOF || assertionType != AssertionType.ALLOF) {
            // empty if block
        }
        this.assertionType = assertionType;
        this.subAssertions = subAssertions;
    }

    public List<AtomicAssertion> getSubAssertions() {
        return this.subAssertions;
    }

    public void setSubAssertions(List<AtomicAssertion> subAssertions) {
        this.subAssertions = subAssertions;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public String getExpectedValue() {
        return this.expectedValue;
    }

    public void setExpectedValue(String expectedValue) {
        this.expectedValue = expectedValue;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AssertionType getAssertionType() {
        return this.assertionType;
    }

    public void setAssertionType(AssertionType assertionType) {
        this.assertionType = assertionType;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String toString() {
        return "AtomicAssertion{ " + (Object)((Object)this.expression) + " (" + this.key + ") " + (Object)((Object)this.assertionType) + " = " + this.expectedValue + " }";
    }
}

