/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.logging;

import io.unlogged.logging.DiscardEventLogger;
import io.unlogged.logging.IEventLogger;
import io.unlogged.logging.impl.DetailedEventStreamAggregatedLogger;
import io.unlogged.logging.impl.EventStreamAggregatedLogger;
import io.unlogged.logging.util.AggregatedFileLogger;
import io.unlogged.logging.util.ObjectIdAggregatedStream;
import io.unlogged.logging.util.TypeIdAggregatedStreamMap;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class Logging {
    static IEventLogger INSTANCE = new DiscardEventLogger();
    static int previousDataId = -1;

    public static EventStreamAggregatedLogger initialiseAggregatedLogger(AggregatedFileLogger aggregatedLogger, File outputDir) throws IOException {
        TypeIdAggregatedStreamMap typeToId = new TypeIdAggregatedStreamMap(aggregatedLogger);
        ObjectIdAggregatedStream objectIdMap = new ObjectIdAggregatedStream(aggregatedLogger, typeToId, outputDir);
        EventStreamAggregatedLogger instance = new EventStreamAggregatedLogger(objectIdMap, aggregatedLogger);
        INSTANCE = instance;
        return instance;
    }

    public static DetailedEventStreamAggregatedLogger initialiseDetailedAggregatedLogger(AggregatedFileLogger aggregatedLogger, File outputDir) throws IOException {
        TypeIdAggregatedStreamMap typeToId = new TypeIdAggregatedStreamMap(aggregatedLogger);
        ObjectIdAggregatedStream objectIdMap = new ObjectIdAggregatedStream(aggregatedLogger, typeToId, outputDir);
        DetailedEventStreamAggregatedLogger instance = new DetailedEventStreamAggregatedLogger(objectIdMap, aggregatedLogger);
        INSTANCE = instance;
        return instance;
    }

    public static void recordEvent(Object value, int dataId) {
        INSTANCE.recordEvent(dataId, value);
    }

    public static Mono<?> recordEvent(Mono<?> value, int dataId) {
        return (Mono)INSTANCE.recordEvent(dataId, value);
    }

    public static Flux<?> recordEvent(Flux<?> value, int dataId) {
        return (Flux)INSTANCE.recordEvent(dataId, value);
    }

    public static void recordEvent(Throwable value, int dataId) {
        INSTANCE.recordEvent(dataId, value);
    }

    public static void recordEvent(boolean value, int dataId) {
        INSTANCE.recordEvent(dataId, value);
    }

    public static void recordEvent(byte value, int dataId) {
        INSTANCE.recordEvent(dataId, value);
    }

    public static void recordEvent(Integer value, int dataId) {
        if (value != null) {
            INSTANCE.recordEvent(dataId, value);
        } else {
            INSTANCE.recordEvent(dataId, value);
        }
    }

    public static void recordEvent(Long value, int dataId) {
        if (value != null) {
            INSTANCE.recordEvent(dataId, value);
        } else {
            INSTANCE.recordEvent(dataId, value);
        }
    }

    public static void recordEvent(Short value, int dataId) {
        if (value != null) {
            INSTANCE.recordEvent(dataId, value);
        } else {
            INSTANCE.recordEvent(dataId, value);
        }
    }

    public static void recordEvent(Byte value, int dataId) {
        if (value != null) {
            INSTANCE.recordEvent(dataId, value);
        } else {
            INSTANCE.recordEvent(dataId, value);
        }
    }

    public static void recordEvent(Float value, int dataId) {
        if (value != null) {
            INSTANCE.recordEvent(dataId, value.floatValue());
        } else {
            INSTANCE.recordEvent(dataId, value);
        }
    }

    public static void recordEvent(Double value, int dataId) {
        if (value != null) {
            INSTANCE.recordEvent(dataId, value);
        } else {
            INSTANCE.recordEvent(dataId, value);
        }
    }

    public static void recordEvent(Character value, int dataId) {
        if (value != null) {
            INSTANCE.recordEvent(dataId, value.charValue());
        } else {
            INSTANCE.recordEvent(dataId, value);
        }
    }

    public static void recordEvent(Boolean value, int dataId) {
        if (value == null || !value.booleanValue()) {
            INSTANCE.recordEvent(dataId, 0);
        } else {
            INSTANCE.recordEvent(dataId, 1);
        }
    }

    public static void recordEvent(char value, int dataId) {
        INSTANCE.recordEvent(dataId, value);
    }

    public static void recordEvent(short value, int dataId) {
        INSTANCE.recordEvent(dataId, value);
    }

    public static void recordEvent(int value, int dataId) {
        INSTANCE.recordEvent(dataId, value);
    }

    public static void recordEvent(long value, int dataId) {
        INSTANCE.recordEvent(dataId, value);
    }

    public static void recordEvent(float value, int dataId) {
        INSTANCE.recordEvent(dataId, value);
    }

    public static void recordEvent(double value, int dataId) {
        INSTANCE.recordEvent(dataId, value);
    }

    public static void recordEvent(int dataId) {
        INSTANCE.recordEvent(dataId, 0);
    }

    public static void recordArrayLoad(Object array, int index, int dataId) {
        INSTANCE.recordEvent(dataId, array);
        INSTANCE.recordEvent(dataId + 1, index);
    }

    public static void recordArrayStore(Object array, int index, byte value, int dataId) {
        INSTANCE.recordEvent(dataId, array);
        INSTANCE.recordEvent(dataId + 1, index);
        INSTANCE.recordEvent(dataId + 2, value);
    }

    public static void recordArrayStore(Object array, int index, char value, int dataId) {
        INSTANCE.recordEvent(dataId, array);
        INSTANCE.recordEvent(dataId + 1, index);
        INSTANCE.recordEvent(dataId + 2, value);
    }

    public static void recordArrayStore(Object array, int index, double value, int dataId) {
        INSTANCE.recordEvent(dataId, array);
        INSTANCE.recordEvent(dataId + 1, index);
        INSTANCE.recordEvent(dataId + 2, value);
    }

    public static void recordArrayStore(Object array, int index, float value, int dataId) {
        INSTANCE.recordEvent(dataId, array);
        INSTANCE.recordEvent(dataId + 1, index);
        INSTANCE.recordEvent(dataId + 2, value);
    }

    public static void recordArrayStore(Object array, int index, int value, int dataId) {
        INSTANCE.recordEvent(dataId, array);
        INSTANCE.recordEvent(dataId + 1, index);
        INSTANCE.recordEvent(dataId + 2, value);
    }

    public static void recordArrayStore(Object array, int index, long value, int dataId) {
        INSTANCE.recordEvent(dataId, array);
        INSTANCE.recordEvent(dataId + 1, index);
        INSTANCE.recordEvent(dataId + 2, value);
    }

    public static void recordArrayStore(Object array, int index, short value, int dataId) {
        INSTANCE.recordEvent(dataId, array);
        INSTANCE.recordEvent(dataId + 1, index);
        INSTANCE.recordEvent(dataId + 2, value);
    }

    public static void recordArrayStore(Object array, int index, Object value, int dataId) {
        INSTANCE.recordEvent(dataId, array);
        INSTANCE.recordEvent(dataId + 1, index);
        INSTANCE.recordEvent(dataId + 2, value);
    }

    public static void recordMultiNewArray(Object array, int dataId) {
        INSTANCE.recordEvent(dataId, array);
        Logging.recordMultiNewArrayContents((Object[])array, dataId);
    }

    private static void recordMultiNewArrayContents(Object[] array, int dataId) {
        LinkedList<Object[]> arrays = new LinkedList<Object[]>();
        arrays.addFirst(array);
        while (!arrays.isEmpty()) {
            Object[] asArray = (Object[])arrays.removeFirst();
            INSTANCE.recordEvent(dataId + 1, asArray);
            for (int index = 0; index < asArray.length; ++index) {
                Object element = asArray[index];
                Class<?> elementType = element.getClass();
                if (element == null || !elementType.isArray()) continue;
                INSTANCE.recordEvent(dataId + 2, element);
                if (!elementType.getComponentType().isArray()) continue;
                arrays.addLast((Object[])element);
            }
        }
    }

    public static IEventLogger initialiseDiscardLogger() {
        INSTANCE = new DiscardEventLogger();
        return INSTANCE;
    }
}

