/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.logging;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import selogger.com.fasterxml.jackson.annotation.JsonAutoDetect;
import selogger.com.fasterxml.jackson.annotation.PropertyAccessor;
import selogger.com.fasterxml.jackson.core.JsonGenerator;
import selogger.com.fasterxml.jackson.databind.DeserializationFeature;
import selogger.com.fasterxml.jackson.databind.JsonMappingException;
import selogger.com.fasterxml.jackson.databind.JsonSerializer;
import selogger.com.fasterxml.jackson.databind.Module;
import selogger.com.fasterxml.jackson.databind.ObjectMapper;
import selogger.com.fasterxml.jackson.databind.SerializationFeature;
import selogger.com.fasterxml.jackson.databind.SerializerProvider;
import selogger.com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import selogger.com.fasterxml.jackson.databind.introspect.Annotated;
import selogger.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import selogger.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import selogger.com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import selogger.com.fasterxml.jackson.databind.json.JsonMapper;
import selogger.com.fasterxml.jackson.databind.module.SimpleModule;

public class ObjectMapperFactory {
    private static final List<String> JACKSON_PROPERTY_NAMES_SET_FALSE;
    private static boolean isLombokPresent;
    private static boolean isReactivePresent;

    public static ObjectMapper createObjectMapper() {
        String jacksonVersion = ObjectMapper.class.getPackage().getImplementationVersion();
        if (jacksonVersion != null && (jacksonVersion.startsWith("2.9") || jacksonVersion.startsWith("2.8"))) {
            ObjectMapper objectMapper1 = new ObjectMapper();
            try {
                JsonMappingException jme = new JsonMappingException(new DummyClosable(), "load class");
                jme.prependPath(new JsonMappingException.Reference("from dummy"));
            }
            catch (Exception jme) {
                // empty catch block
            }
            for (DeserializationFeature value : DeserializationFeature.values()) {
                if (!JACKSON_PROPERTY_NAMES_SET_FALSE.contains(value.name())) continue;
                objectMapper1.configure(value, false);
            }
            objectMapper1.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, true);
            objectMapper1.configure(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS, false);
            List<String> jacksonModules = Arrays.asList("selogger.com.fasterxml.jackson.datatype.jdk8.Jdk8Module", "selogger.com.fasterxml.jackson.datatype.jsr310.JavaTimeModule", "selogger.com.fasterxml.jackson.datatype.joda.JodaModule", "selogger.com.fasterxml.jackson.module.jakarta.xmlbind.JakartaXmlBindAnnotationModule", "selogger.com.fasterxml.jackson.module.mrbean.MrBeanModule", "selogger.com.fasterxml.jackson.module.paranamer.ParanamerModule", "software.fitz.jackson.module.force.ForceDeserializerModule");
            for (String jacksonModule : jacksonModules) {
                try {
                    Class<?> jdk8Module = Class.forName(jacksonModule);
                    objectMapper1.registerModule((Module)jdk8Module.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (ClassNotFoundException | UnsupportedClassVersionError jdk8Module) {
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException jdk8Module) {}
            }
            return objectMapper1;
        }
        JsonMappingException jme = new JsonMappingException(new DummyClosable(), "load class");
        jme.prependPath(new JsonMappingException.Reference("from dummy"));
        JsonMapper.Builder jacksonBuilder = JsonMapper.builder();
        for (DeserializationFeature value : DeserializationFeature.values()) {
            if (!JACKSON_PROPERTY_NAMES_SET_FALSE.contains(value.name())) continue;
            jacksonBuilder.configure(value, false);
        }
        jacksonBuilder.annotationIntrospector(new JacksonAnnotationIntrospector(){

            @Override
            public boolean hasIgnoreMarker(AnnotatedMember m) {
                String fullName = m.getFullName();
                if (m.getDeclaringClass().getCanonicalName().contains("_$$_")) {
                    return true;
                }
                String rawTypeCanonicalName = m.getRawType().getCanonicalName();
                if (rawTypeCanonicalName.equals("javassist.util.proxy.MethodHandler")) {
                    return true;
                }
                if (fullName.contains(".$Proxy")) {
                    return true;
                }
                if (rawTypeCanonicalName.startsWith("java.lang.Thread")) {
                    return true;
                }
                if (rawTypeCanonicalName.startsWith("java.util.function.")) {
                    return true;
                }
                if (rawTypeCanonicalName.startsWith("java.lang.reflect.")) {
                    return true;
                }
                if (rawTypeCanonicalName.startsWith("jdk.internal.reflect.")) {
                    return true;
                }
                if (rawTypeCanonicalName.startsWith("io.mongock.")) {
                    return true;
                }
                if (rawTypeCanonicalName.startsWith("sun.reflect.")) {
                    return true;
                }
                if (rawTypeCanonicalName.equals("sun.nio.ch.Interruptible")) {
                    return true;
                }
                if (rawTypeCanonicalName.equals("java.security.AccessControlContext")) {
                    return true;
                }
                if (rawTypeCanonicalName.equals("java.lang.ClassLoader")) {
                    return true;
                }
                if (rawTypeCanonicalName.equals("java.lang.Runnable")) {
                    return true;
                }
                if (rawTypeCanonicalName.startsWith("reactor.core.")) {
                    return true;
                }
                if (fullName.startsWith("reactor.")) {
                    return true;
                }
                if (rawTypeCanonicalName.startsWith("io.netty.resolver")) {
                    return true;
                }
                return rawTypeCanonicalName.startsWith("org.reactivestreams.");
            }

            @Override
            public Object findSerializer(Annotated a) {
                if (Objects.equals(a.getRawType(), Date.class)) {
                    return null;
                }
                return super.findSerializer(a);
            }

            @Override
            public JsonPOJOBuilder.Value findPOJOBuilderConfig(AnnotatedClass ac) {
                if (ac.hasAnnotation(JsonPOJOBuilder.class)) {
                    return super.findPOJOBuilderConfig(ac);
                }
                return new JsonPOJOBuilder.Value("build", "");
            }

            @Override
            public Class<?> findPOJOBuilder(AnnotatedClass ac) {
                if (ac.getRawType().getCanonicalName().startsWith("java.")) {
                    return null;
                }
                if (isLombokPresent) {
                    try {
                        String classFullyQualifiedName = ac.getName();
                        String classSimpleName = classFullyQualifiedName.substring(classFullyQualifiedName.lastIndexOf(".") + 1);
                        String lombokClassBuilderName = ac.getName() + "$" + classSimpleName + "Builder";
                        if (ac.getRawType().getClassLoader() != null) {
                            return ac.getRawType().getClassLoader().loadClass(lombokClassBuilderName);
                        }
                        return this.getClass().getClassLoader().loadClass(lombokClassBuilderName);
                    }
                    catch (ClassNotFoundException e) {
                        return super.findPOJOBuilder(ac);
                    }
                }
                return super.findPOJOBuilder(ac);
            }
        });
        SimpleDateFormat df = new SimpleDateFormat("MMM d, yyyy HH:mm:ss aaa");
        jacksonBuilder.defaultDateFormat(df);
        jacksonBuilder.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        jacksonBuilder.configure(SerializationFeature.FAIL_ON_SELF_REFERENCES, false);
        try {
            Field fieldWriteSelfReferencesAsNull = SerializationFeature.class.getDeclaredField("WRITE_SELF_REFERENCES_AS_NULL");
            jacksonBuilder.configure(SerializationFeature.WRITE_SELF_REFERENCES_AS_NULL, true);
        }
        catch (NoSuchFieldException fieldWriteSelfReferencesAsNull) {
            // empty catch block
        }
        try {
            Class<?> hibernateClassPresent = Class.forName("org.hibernate.SessionFactory");
            Class<?> hibernateModule = Class.forName("selogger.com.fasterxml.jackson.datatype.hibernate5.Hibernate5Module");
            Module module = (Module)hibernateModule.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Class<?> featureClass = Class.forName("selogger.com.fasterxml.jackson.datatype.hibernate5.Hibernate5Module$Feature");
            Method configureMethod = hibernateModule.getMethod("configure", featureClass, Boolean.TYPE);
            configureMethod.invoke((Object)module, featureClass.getDeclaredField("FORCE_LAZY_LOADING").get(null), true);
            configureMethod.invoke((Object)module, featureClass.getDeclaredField("REPLACE_PERSISTENT_COLLECTIONS").get(null), true);
            configureMethod.invoke((Object)module, featureClass.getDeclaredField("USE_TRANSIENT_ANNOTATION").get(null), false);
            jacksonBuilder.addModule(module);
        }
        catch (ClassNotFoundException | NoSuchMethodException hibernateClassPresent) {
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        List<String> jacksonModules = Arrays.asList("selogger.com.fasterxml.jackson.datatype.jdk8.Jdk8Module", "selogger.com.fasterxml.jackson.datatype.jsr310.JavaTimeModule", "selogger.com.fasterxml.jackson.datatype.joda.JodaModule", "selogger.com.fasterxml.jackson.module.jakarta.xmlbind.JakartaXmlBindAnnotationModule", "selogger.com.fasterxml.jackson.module.mrbean.MrBeanModule", "selogger.com.fasterxml.jackson.module.paranamer.ParanamerModule", "software.fitz.jackson.module.force.ForceDeserializerModule");
        for (String jacksonModule : jacksonModules) {
            try {
                Class<?> jdk8Module = Class.forName(jacksonModule);
                jacksonBuilder.addModule((Module)jdk8Module.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ClassNotFoundException | UnsupportedClassVersionError throwable) {
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {}
        }
        JsonMapper objectMapperInstance = (JsonMapper)jacksonBuilder.build();
        objectMapperInstance.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        return objectMapperInstance;
    }

    public static ObjectMapper createObjectMapperReactive() {
        String jacksonVersion = ObjectMapper.class.getPackage().getImplementationVersion();
        if (jacksonVersion != null && (jacksonVersion.startsWith("2.9") || jacksonVersion.startsWith("2.8"))) {
            ObjectMapper objectMapper1 = new ObjectMapper();
            try {
                JsonMappingException jme = new JsonMappingException(new DummyClosable(), "load class");
                jme.prependPath(new JsonMappingException.Reference("from dummy"));
            }
            catch (Exception jme) {
                // empty catch block
            }
            for (DeserializationFeature value : DeserializationFeature.values()) {
                if (!JACKSON_PROPERTY_NAMES_SET_FALSE.contains(value.name())) continue;
                objectMapper1.configure(value, false);
            }
            if (isReactivePresent) {
                objectMapper1.registerModule(new ReactiveModule());
            }
            objectMapper1.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, true);
            objectMapper1.configure(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS, false);
            List<String> jacksonModules = Arrays.asList("selogger.com.fasterxml.jackson.datatype.jdk8.Jdk8Module", "selogger.com.fasterxml.jackson.datatype.jsr310.JavaTimeModule", "selogger.com.fasterxml.jackson.datatype.joda.JodaModule", "selogger.com.fasterxml.jackson.module.jakarta.xmlbind.JakartaXmlBindAnnotationModule", "selogger.com.fasterxml.jackson.module.mrbean.MrBeanModule", "selogger.com.fasterxml.jackson.module.paranamer.ParanamerModule", "software.fitz.jackson.module.force.ForceDeserializerModule");
            for (String jacksonModule : jacksonModules) {
                try {
                    Class<?> jdk8Module = Class.forName(jacksonModule);
                    objectMapper1.registerModule((Module)jdk8Module.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (ClassNotFoundException | UnsupportedClassVersionError jdk8Module) {
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException jdk8Module) {}
            }
            return objectMapper1;
        }
        JsonMappingException jme = new JsonMappingException(new DummyClosable(), "load class");
        jme.prependPath(new JsonMappingException.Reference("from dummy"));
        JsonMapper.Builder jacksonBuilder = JsonMapper.builder();
        for (DeserializationFeature value : DeserializationFeature.values()) {
            if (!JACKSON_PROPERTY_NAMES_SET_FALSE.contains(value.name())) continue;
            jacksonBuilder.configure(value, false);
        }
        if (isReactivePresent) {
            jacksonBuilder.addModule(new ReactiveModule());
        }
        jacksonBuilder.annotationIntrospector(new JacksonAnnotationIntrospector(){

            @Override
            public boolean hasIgnoreMarker(AnnotatedMember m) {
                String fullName = m.getFullName();
                if (m.getDeclaringClass().getCanonicalName().contains("_$$_")) {
                    return true;
                }
                String rawTypeCanonicalName = m.getRawType().getCanonicalName();
                if (rawTypeCanonicalName.equals("javassist.util.proxy.MethodHandler")) {
                    return true;
                }
                if (fullName.contains(".$Proxy")) {
                    return true;
                }
                if (rawTypeCanonicalName.startsWith("java.lang.Thread")) {
                    return true;
                }
                if (rawTypeCanonicalName.startsWith("java.util.function.")) {
                    return true;
                }
                if (rawTypeCanonicalName.startsWith("java.lang.reflect.")) {
                    return true;
                }
                if (rawTypeCanonicalName.startsWith("jdk.internal.reflect.")) {
                    return true;
                }
                if (rawTypeCanonicalName.startsWith("io.mongock.")) {
                    return true;
                }
                if (rawTypeCanonicalName.startsWith("sun.reflect.")) {
                    return true;
                }
                if (rawTypeCanonicalName.equals("sun.nio.ch.Interruptible")) {
                    return true;
                }
                if (rawTypeCanonicalName.equals("java.security.AccessControlContext")) {
                    return true;
                }
                if (rawTypeCanonicalName.equals("java.lang.ClassLoader")) {
                    return true;
                }
                if (rawTypeCanonicalName.equals("java.lang.Runnable")) {
                    return true;
                }
                if (rawTypeCanonicalName.startsWith("reactor.core.")) {
                    return true;
                }
                if (fullName.startsWith("reactor.")) {
                    return true;
                }
                if (rawTypeCanonicalName.startsWith("io.netty.resolver")) {
                    return true;
                }
                return rawTypeCanonicalName.startsWith("org.reactivestreams.");
            }

            @Override
            public Object findSerializer(Annotated a) {
                if (Objects.equals(a.getRawType(), Date.class)) {
                    return null;
                }
                return super.findSerializer(a);
            }

            @Override
            public JsonPOJOBuilder.Value findPOJOBuilderConfig(AnnotatedClass ac) {
                if (ac.hasAnnotation(JsonPOJOBuilder.class)) {
                    return super.findPOJOBuilderConfig(ac);
                }
                return new JsonPOJOBuilder.Value("build", "");
            }

            @Override
            public Class<?> findPOJOBuilder(AnnotatedClass ac) {
                if (ac.getRawType().getCanonicalName().startsWith("java.")) {
                    return null;
                }
                if (isLombokPresent) {
                    try {
                        String classFullyQualifiedName = ac.getName();
                        String classSimpleName = classFullyQualifiedName.substring(classFullyQualifiedName.lastIndexOf(".") + 1);
                        String lombokClassBuilderName = ac.getName() + "$" + classSimpleName + "Builder";
                        if (ac.getRawType().getClassLoader() != null) {
                            return ac.getRawType().getClassLoader().loadClass(lombokClassBuilderName);
                        }
                        return this.getClass().getClassLoader().loadClass(lombokClassBuilderName);
                    }
                    catch (ClassNotFoundException e) {
                        return super.findPOJOBuilder(ac);
                    }
                }
                return super.findPOJOBuilder(ac);
            }
        });
        SimpleDateFormat df = new SimpleDateFormat("MMM d, yyyy HH:mm:ss aaa");
        jacksonBuilder.defaultDateFormat(df);
        jacksonBuilder.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        jacksonBuilder.configure(SerializationFeature.FAIL_ON_SELF_REFERENCES, false);
        try {
            Field fieldWriteSelfReferencesAsNull = SerializationFeature.class.getDeclaredField("WRITE_SELF_REFERENCES_AS_NULL");
            jacksonBuilder.configure(SerializationFeature.WRITE_SELF_REFERENCES_AS_NULL, true);
        }
        catch (NoSuchFieldException fieldWriteSelfReferencesAsNull) {
            // empty catch block
        }
        try {
            Class<?> hibernateClassPresent = Class.forName("org.hibernate.SessionFactory");
            Class<?> hibernateModule = Class.forName("selogger.com.fasterxml.jackson.datatype.hibernate5.Hibernate5Module");
            Module module = (Module)hibernateModule.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Class<?> featureClass = Class.forName("selogger.com.fasterxml.jackson.datatype.hibernate5.Hibernate5Module$Feature");
            Method configureMethod = hibernateModule.getMethod("configure", featureClass, Boolean.TYPE);
            configureMethod.invoke((Object)module, featureClass.getDeclaredField("FORCE_LAZY_LOADING").get(null), true);
            configureMethod.invoke((Object)module, featureClass.getDeclaredField("REPLACE_PERSISTENT_COLLECTIONS").get(null), true);
            configureMethod.invoke((Object)module, featureClass.getDeclaredField("USE_TRANSIENT_ANNOTATION").get(null), false);
            jacksonBuilder.addModule(module);
        }
        catch (ClassNotFoundException | NoSuchMethodException hibernateClassPresent) {
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        List<String> jacksonModules = Arrays.asList("selogger.com.fasterxml.jackson.datatype.jdk8.Jdk8Module", "selogger.com.fasterxml.jackson.datatype.jsr310.JavaTimeModule", "selogger.com.fasterxml.jackson.datatype.joda.JodaModule", "selogger.com.fasterxml.jackson.module.jakarta.xmlbind.JakartaXmlBindAnnotationModule", "selogger.com.fasterxml.jackson.module.mrbean.MrBeanModule", "selogger.com.fasterxml.jackson.module.paranamer.ParanamerModule", "software.fitz.jackson.module.force.ForceDeserializerModule");
        for (String jacksonModule : jacksonModules) {
            try {
                Class<?> jdk8Module = Class.forName(jacksonModule);
                jacksonBuilder.addModule((Module)jdk8Module.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ClassNotFoundException | UnsupportedClassVersionError throwable) {
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {}
        }
        JsonMapper objectMapperInstance = (JsonMapper)jacksonBuilder.build();
        objectMapperInstance.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        return objectMapperInstance;
    }

    static {
        Class<?> lombokBuilderAnnotation;
        JACKSON_PROPERTY_NAMES_SET_FALSE = Arrays.asList("FAIL_ON_UNKNOWN_PROPERTIES", "FAIL_ON_IGNORED_PROPERTIES", "FAIL_ON_NULL_FOR_PRIMITIVES", "FAIL_ON_NULL_CREATOR_PROPERTIES", "FAIL_ON_MISSING_CREATOR_PROPERTIES", "FAIL_ON_NUMBERS_FOR_ENUMS", "FAIL_ON_TRAILING_TOKENS");
        isReactivePresent = false;
        try {
            lombokBuilderAnnotation = Class.forName("lombok.Builder");
            isLombokPresent = true;
        }
        catch (ClassNotFoundException e) {
            isLombokPresent = false;
        }
        try {
            lombokBuilderAnnotation = Class.forName("reactor.core.publisher.Mono");
            isReactivePresent = true;
        }
        catch (ClassNotFoundException e) {
            isReactivePresent = false;
        }
    }

    private static class DummyClosable
    implements Closeable {
        private DummyClosable() {
        }

        @Override
        public void close() throws IOException {
        }
    }

    static class ReactiveModule
    extends SimpleModule {
        ReactiveModule() {
            this.addSerializer(Mono.class, new MonoSerializer());
            this.addSerializer(Flux.class, new FluxSerializer());
        }
    }

    public static class FluxSerializer
    extends JsonSerializer<Flux> {
        @Override
        public void serialize(Flux flux, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartArray();
            flux.toIterable().forEach(element -> {
                try {
                    jsonGenerator.writeObject(element);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            jsonGenerator.writeEndArray();
        }
    }

    public static class MonoSerializer
    extends JsonSerializer<Mono> {
        @Override
        public void serialize(Mono mono, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeObject(mono.block());
        }
    }
}

