/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.logging;

import io.unlogged.logging.IErrorLogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;

public class SimpleFileLogger
implements IErrorLogger {
    private File logFile;
    public static final String ERROR_LOG_FILE = "log.txt";
    private PrintStream logger;

    public SimpleFileLogger(File outputDir) {
        try {
            this.logFile = new File(outputDir, ERROR_LOG_FILE);
            this.logger = new PrintStream(this.logFile);
        }
        catch (FileNotFoundException e) {
            this.logger = System.out;
            this.logger.println("[unlogged] failed to open log.txt in " + outputDir.getAbsolutePath());
            this.logger.println("[unlogged] using System.out instead.");
        }
    }

    @Override
    public void log(Throwable throwable) {
        this.logger.println(throwable.getMessage());
        throwable.printStackTrace(this.logger);
    }

    @Override
    public void log(String message) {
        this.logger.println(message);
    }

    @Override
    public void close() {
        if (this.logger != System.out) {
            this.logger.close();
        }
    }

    @Override
    public String getPath() {
        return this.logFile.getAbsolutePath();
    }
}

