/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.logging.util;

import io.unlogged.logging.util.IntIntMap;
import io.unlogged.logging.util.Tools;

public class IntIntMap4
implements IntIntMap {
    private static final int FREE_KEY = 0;
    private static final long FREE_CELL = 0L;
    private static long KEY_MASK = 0xFFFFFFFFL;
    public static final int NO_VALUE = 0;
    private long[] m_ar;
    private boolean m_hasFreeKey;
    private int m_freeValue;
    private final float m_fillFactor;
    private int m_threshold;
    private int m_size;
    private int m_mask;

    public IntIntMap4(int size, float fillFactor) {
        if (fillFactor <= 0.0f || fillFactor >= 1.0f) {
            throw new IllegalArgumentException("FillFactor must be in (0, 1)");
        }
        if (size <= 0) {
            throw new IllegalArgumentException("Size must be positive!");
        }
        int capacity = Tools.arraySize(size, fillFactor);
        this.m_mask = capacity - 1;
        this.m_fillFactor = fillFactor;
        this.m_ar = new long[capacity];
        this.m_threshold = (int)((float)capacity * fillFactor);
    }

    @Override
    public int get(int key) {
        if (key == 0) {
            return this.m_hasFreeKey ? this.m_freeValue : 0;
        }
        int idx = this.getStartIndex(key);
        long c = this.m_ar[idx];
        if (c == 0L) {
            return 0;
        }
        if ((int)(c & KEY_MASK) == key) {
            return (int)(c >> 32);
        }
        do {
            if ((c = this.m_ar[idx = this.getNextIndex(idx)]) != 0L) continue;
            return 0;
        } while ((int)(c & KEY_MASK) != key);
        return (int)(c >> 32);
    }

    @Override
    public int put(int key, int value) {
        if (key == 0) {
            int ret = this.m_freeValue;
            if (!this.m_hasFreeKey) {
                ++this.m_size;
            }
            this.m_hasFreeKey = true;
            this.m_freeValue = value;
            return ret;
        }
        int idx = this.getStartIndex(key);
        long c = this.m_ar[idx];
        if (c == 0L) {
            this.m_ar[idx] = (long)key & KEY_MASK | (long)value << 32;
            if (this.m_size >= this.m_threshold) {
                this.rehash(this.m_ar.length * 2);
            } else {
                ++this.m_size;
            }
            return 0;
        }
        if ((int)(c & KEY_MASK) == key) {
            this.m_ar[idx] = (long)key & KEY_MASK | (long)value << 32;
            return (int)(c >> 32);
        }
        do {
            if ((c = this.m_ar[idx = this.getNextIndex(idx)]) != 0L) continue;
            this.m_ar[idx] = (long)key & KEY_MASK | (long)value << 32;
            if (this.m_size >= this.m_threshold) {
                this.rehash(this.m_ar.length * 2);
            } else {
                ++this.m_size;
            }
            return 0;
        } while ((int)(c & KEY_MASK) != key);
        this.m_ar[idx] = (long)key & KEY_MASK | (long)value << 32;
        return (int)(c >> 32);
    }

    @Override
    public int remove(int key) {
        if (key == 0) {
            if (!this.m_hasFreeKey) {
                return 0;
            }
            this.m_hasFreeKey = false;
            int ret = this.m_freeValue;
            this.m_freeValue = 0;
            --this.m_size;
            return ret;
        }
        int idx = this.getStartIndex(key);
        long c = this.m_ar[idx];
        if (c == 0L) {
            return 0;
        }
        if ((int)(c & KEY_MASK) == key) {
            --this.m_size;
            this.shiftKeys(idx);
            return (int)(c >> 32);
        }
        do {
            if ((c = this.m_ar[idx = this.getNextIndex(idx)]) != 0L) continue;
            return 0;
        } while ((int)(c & KEY_MASK) != key);
        --this.m_size;
        this.shiftKeys(idx);
        return (int)(c >> 32);
    }

    @Override
    public int size() {
        return this.m_size;
    }

    private int shiftKeys(int pos) {
        long[] data = this.m_ar;
        while (true) {
            int last = pos;
            pos = last + 1 & this.m_mask;
            while (true) {
                int k;
                if ((k = (int)(data[pos] & KEY_MASK)) == 0) {
                    data[last] = 0L;
                    return last;
                }
                int slot = this.getStartIndex(k);
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.m_mask;
            }
            data[last] = data[pos];
        }
    }

    private void rehash(int newCapacity) {
        this.m_threshold = (int)((float)newCapacity * this.m_fillFactor);
        this.m_mask = newCapacity - 1;
        int oldCapacity = this.m_ar.length;
        long[] oldData = this.m_ar;
        this.m_ar = new long[newCapacity];
        this.m_size = this.m_hasFreeKey ? 1 : 0;
        int i = oldCapacity;
        while (i-- > 0) {
            int oldKey = (int)(oldData[i] & KEY_MASK);
            if (oldKey == 0) continue;
            this.put(oldKey, (int)(oldData[i] >> 32));
        }
    }

    private int getStartIndex(int key) {
        return Tools.phiMix(key) & this.m_mask;
    }

    private int getNextIndex(int currentIndex) {
        return currentIndex + 1 & this.m_mask;
    }
}

