/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.logging.util;

import io.unlogged.logging.util.FileNameGenerator;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.zip.GZIPOutputStream;

public class StringFileListStream {
    private final FileNameGenerator filenames;
    private final long itemPerFile;
    private long itemCount;
    private final boolean compress;
    private PrintWriter writer;

    public StringFileListStream(FileNameGenerator filenames, long itemPerFile, boolean compress) {
        this.filenames = filenames;
        this.itemPerFile = itemPerFile;
        this.compress = compress;
        this.itemCount = 0L;
        this.prepareNextFile();
    }

    private void prepareNextFile() {
        if (this.writer != null) {
            this.writer.close();
        }
        File f = this.filenames.getNextFile();
        try {
            if (this.compress) {
                GZIPOutputStream w = new GZIPOutputStream(new FileOutputStream(f));
                this.writer = new PrintWriter(new OutputStreamWriter(w));
            } else {
                BufferedOutputStream w = new BufferedOutputStream(new FileOutputStream(f), 65536);
                this.writer = new PrintWriter(new OutputStreamWriter(w));
            }
        }
        catch (IOException e) {
            this.writer = null;
        }
    }

    public synchronized void write(String s) {
        if (this.writer != null) {
            this.writer.print(s);
            ++this.itemCount;
            if (this.itemCount >= this.itemPerFile) {
                this.prepareNextFile();
                this.itemCount = 0L;
            }
        }
    }

    public synchronized void close() {
        this.writer.close();
        this.writer = null;
    }
}

