/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.mocking;

import io.unlogged.mocking.ParameterMatcher;
import io.unlogged.mocking.ThenParameter;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class DeclaredMock {
    private String id;
    private String name;
    private String fieldTypeName;
    private String fieldName;
    private String sourceClassName;
    private String methodName;
    private String methodHashKey;
    private List<ParameterMatcher> whenParameter;
    private List<ThenParameter> thenParameter;

    public DeclaredMock() {
        this.methodName = "default value";
    }

    public DeclaredMock(DeclaredMock declaredMock) {
        this.name = declaredMock.name;
        this.id = declaredMock.id;
        this.fieldTypeName = declaredMock.fieldTypeName;
        this.sourceClassName = declaredMock.sourceClassName;
        this.methodHashKey = declaredMock.methodHashKey;
        this.fieldName = declaredMock.fieldName;
        this.whenParameter = declaredMock.whenParameter.stream().map(ParameterMatcher::new).collect(Collectors.toList());
        this.thenParameter = declaredMock.thenParameter.stream().map(ThenParameter::new).collect(Collectors.toList());
        this.methodName = declaredMock.methodName == null ? "default value" : declaredMock.methodName;
    }

    public DeclaredMock(String name, String fieldTypeName, String fieldName, String methodName, List<ParameterMatcher> whenParameterLists, List<ThenParameter> thenParameterList) {
        this.name = name;
        this.fieldTypeName = fieldTypeName;
        this.fieldName = fieldName;
        this.methodName = methodName;
        this.whenParameter = whenParameterLists;
        this.thenParameter = thenParameterList;
    }

    public String getMethodHashKey() {
        return this.methodHashKey;
    }

    public void setMethodHashKey(String methodHashKey) {
        this.methodHashKey = methodHashKey;
    }

    public String getSourceClassName() {
        return this.sourceClassName;
    }

    public void setSourceClassName(String sourceClassName) {
        this.sourceClassName = sourceClassName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFieldTypeName() {
        return this.fieldTypeName;
    }

    public void setFieldTypeName(String fieldTypeName) {
        this.fieldTypeName = fieldTypeName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public List<ParameterMatcher> getWhenParameter() {
        return this.whenParameter;
    }

    public void setWhenParameter(List<ParameterMatcher> whenParameter) {
        this.whenParameter = whenParameter;
    }

    public List<ThenParameter> getThenParameter() {
        return this.thenParameter;
    }

    public void setThenParameter(List<ThenParameter> thenParameter) {
        this.thenParameter = thenParameter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeclaredMock that = (DeclaredMock)o;
        return Objects.equals(this.name, that.name) && this.fieldTypeName.equals(that.fieldTypeName) && this.fieldName.equals(that.fieldName) && this.methodName.equals(that.methodName) && this.whenParameter.equals(that.whenParameter);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fieldTypeName, this.fieldName, this.methodName, this.whenParameter);
    }

    public String toString() {
        return "DeclaredMock{name='" + this.name + '\'' + ", fieldName='" + this.fieldName + '\'' + ", sourceClassName='" + this.sourceClassName + '\'' + '}';
    }
}

