/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.mocking;

import io.unlogged.ParameterFactory;
import io.unlogged.mocking.DeclaredMock;
import io.unlogged.mocking.MethodExitType;
import io.unlogged.mocking.MockInstance;
import io.unlogged.mocking.ParameterMatcher;
import io.unlogged.mocking.ReturnValue;
import io.unlogged.mocking.ThenParameter;
import io.unlogged.mocking.construction.JsonDeserializer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.objenesis.Objenesis;
import selogger.com.fasterxml.jackson.core.JsonProcessingException;
import selogger.com.fasterxml.jackson.databind.JavaType;
import selogger.com.fasterxml.jackson.databind.JsonNode;
import selogger.com.fasterxml.jackson.databind.ObjectMapper;
import selogger.com.fasterxml.jackson.databind.type.TypeFactory;
import selogger.net.bytebuddy.implementation.bind.annotation.AllArguments;
import selogger.net.bytebuddy.implementation.bind.annotation.BindingPriority;
import selogger.net.bytebuddy.implementation.bind.annotation.Origin;
import selogger.net.bytebuddy.implementation.bind.annotation.RuntimeType;
import selogger.net.bytebuddy.implementation.bind.annotation.Super;
import selogger.net.bytebuddy.implementation.bind.annotation.This;

public class MockHandler {
    private final ObjectMapper objectMapper;
    private final List<DeclaredMock> declaredMocks = new ArrayList<DeclaredMock>();
    private final Objenesis objenesis;
    private final Object originalImplementation;
    private final Object originalFieldParent;
    private final Map<Integer, AtomicInteger> mockMatchCountMap = new HashMap<Integer, AtomicInteger>();
    private final ClassLoader targetClassLoader;
    private final Field field;
    private final JsonDeserializer jsonDeserializer;
    private final ParameterFactory parameterFactory;

    public MockHandler(List<DeclaredMock> declaredMocks, ObjectMapper objectMapper, ParameterFactory parameterFactory, Objenesis objenesis, Object originalImplementation, Object originalFieldParent, ClassLoader targetClassLoader, Field field) {
        this.objectMapper = objectMapper;
        this.jsonDeserializer = new JsonDeserializer(objectMapper);
        this.parameterFactory = parameterFactory;
        this.objenesis = objenesis;
        this.originalImplementation = originalImplementation;
        this.originalFieldParent = originalFieldParent;
        this.targetClassLoader = targetClassLoader;
        this.field = field;
        this.addDeclaredMocks(declaredMocks);
    }

    public static JavaType getTypeReference(TypeFactory typeFactory, String classNameToBeConstructed) {
        if (classNameToBeConstructed == null) {
            return null;
        }
        if (classNameToBeConstructed.endsWith("[]")) {
            JavaType subType = MockHandler.getTypeReference(typeFactory, classNameToBeConstructed.substring(0, classNameToBeConstructed.length() - 2));
            return typeFactory.constructArrayType(subType);
        }
        if (classNameToBeConstructed.contains("<") && classNameToBeConstructed.contains("[]")) {
            String containerClassName = classNameToBeConstructed.substring(0, classNameToBeConstructed.indexOf("<"));
            String containedClassName = classNameToBeConstructed.substring(classNameToBeConstructed.indexOf("<") + 1, classNameToBeConstructed.indexOf(">"));
            JavaType containedType = MockHandler.getTypeReference(typeFactory, containedClassName);
            return typeFactory.constructParametricType(MockHandler.getTypeReference(typeFactory, containerClassName).getRawClass(), containedType);
        }
        switch (classNameToBeConstructed) {
            case "J": 
            case "long": {
                return typeFactory.constructType(Long.TYPE);
            }
            case "Z": 
            case "boolean": {
                return typeFactory.constructType(Boolean.TYPE);
            }
            case "I": 
            case "integer": {
                return typeFactory.constructType(Integer.TYPE);
            }
            case "B": 
            case "byte": {
                return typeFactory.constructType(Byte.TYPE);
            }
            case "C": 
            case "char": {
                return typeFactory.constructType(Character.TYPE);
            }
            case "F": 
            case "float": {
                return typeFactory.constructType(Float.TYPE);
            }
            case "S": 
            case "short": {
                return typeFactory.constructType(Short.TYPE);
            }
            case "D": 
            case "double": {
                return typeFactory.constructType(Double.TYPE);
            }
            case "V": 
            case "void": {
                return typeFactory.constructType(Void.TYPE);
            }
        }
        return typeFactory.constructFromCanonical(classNameToBeConstructed);
    }

    public Field getField() {
        return this.field;
    }

    @RuntimeType
    @BindingPriority(value=1000)
    public Object intercept(@AllArguments Object[] methodArguments, @This Object thisInstance, @Origin Method invokedMethod, @Super Object superInstance) throws Throwable {
        String methodName = invokedMethod.getName();
        for (DeclaredMock declaredMock : this.declaredMocks) {
            int selectedThenParameter;
            if (!declaredMock.getMethodName().equals(methodName)) continue;
            boolean mockMatched = true;
            if (declaredMock.getWhenParameter().size() == methodArguments.length) {
                Object argument;
                ParameterMatcher parameterMatcher;
                List<ParameterMatcher> whenParameter = declaredMock.getWhenParameter();
                for (int i = 0; i < whenParameter.size() && (mockMatched = this.isParameterMatched(parameterMatcher = whenParameter.get(i), argument = methodArguments[i])); ++i) {
                }
            } else if (methodArguments[methodArguments.length - 1] instanceof Object[]) {
                Object[] varags = (Object[])methodArguments[methodArguments.length - 1];
                if (declaredMock.getWhenParameter().size() == methodArguments.length + varags.length - 1) {
                    Object argument;
                    ParameterMatcher parameterMatcher;
                    List<ParameterMatcher> whenParameter = declaredMock.getWhenParameter();
                    for (int i = 0; i < whenParameter.size() && i < methodArguments.length - 1 && (mockMatched = this.isParameterMatched(parameterMatcher = whenParameter.get(i), argument = methodArguments[i])); ++i) {
                    }
                }
            } else {
                mockMatched = false;
            }
            if (!mockMatched) continue;
            Object returnValueInstance = null;
            int mockHash = declaredMock.hashCode();
            AtomicInteger matchCount = this.mockMatchCountMap.getOrDefault(mockHash, new AtomicInteger(0));
            List<ThenParameter> thenParameterList = declaredMock.getThenParameter();
            ThenParameter thenParameter = thenParameterList.get(selectedThenParameter = Math.min(matchCount.getAndIncrement(), thenParameterList.size() - 1));
            if (thenParameter.getMethodExitType() == MethodExitType.NULL) {
                return null;
            }
            ReturnValue returnParameter = thenParameter.getReturnParameter();
            ClassLoader classLoader = thisInstance.getClass().getClassLoader();
            switch (returnParameter.getReturnValueType()) {
                case REAL: {
                    try {
                        returnValueInstance = this.parameterFactory.createObjectInstanceFromStringAndTypeInformation(returnParameter.getClassName(), returnParameter.getValue(), invokedMethod.getReturnType(), this.objectMapper.getTypeFactory().withClassLoader(this.targetClassLoader));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.err.println("Failed to create instance of class [" + returnParameter.getClassName() + "] from value [" + returnParameter.getValue() + "] => " + e.getMessage());
                    }
                    break;
                }
                case MOCK: {
                    Class<?> fieldType = invokedMethod.getReturnType();
                    MockInstance mockedField = this.parameterFactory.createMockedInstance(this.targetClassLoader, this.originalFieldParent, this.field, returnParameter.getDeclaredMocks(), null, fieldType);
                    returnValueInstance = mockedField.getMockedFieldInstance();
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown return parameter type => " + returnParameter);
                }
            }
            switch (thenParameter.getMethodExitType()) {
                case NORMAL: {
                    return returnValueInstance;
                }
                case EXCEPTION: {
                    if (returnValueInstance == null) {
                        returnValueInstance = new Exception("Object to be thrown from mock is null: " + declaredMock);
                    }
                    throw (Throwable)returnValueInstance;
                }
            }
        }
        if (this.originalImplementation == null) {
            return null;
        }
        return invokedMethod.invoke(this.originalImplementation, methodArguments);
    }

    private boolean isParameterMatched(ParameterMatcher parameterMatcher, Object argument) {
        boolean mockMatched = true;
        switch (parameterMatcher.getType()) {
            case ANY_OF_TYPE: {
                JavaType expectedClassType;
                TypeFactory typeFactory = this.objectMapper.getTypeFactory();
                switch (parameterMatcher.getValue()) {
                    case "int": {
                        expectedClassType = typeFactory.constructType(Integer.TYPE);
                        break;
                    }
                    case "short": {
                        expectedClassType = typeFactory.constructType(Short.TYPE);
                        break;
                    }
                    case "float": {
                        expectedClassType = typeFactory.constructType(Float.TYPE);
                        break;
                    }
                    case "long": {
                        expectedClassType = typeFactory.constructType(Long.TYPE);
                        break;
                    }
                    case "byte": {
                        expectedClassType = typeFactory.constructType(Byte.TYPE);
                        break;
                    }
                    case "double": {
                        expectedClassType = typeFactory.constructType(Double.TYPE);
                        break;
                    }
                    case "boolean": {
                        expectedClassType = typeFactory.constructType(Boolean.TYPE);
                        break;
                    }
                    case "char": {
                        expectedClassType = typeFactory.constructType(Character.TYPE);
                        break;
                    }
                    default: {
                        expectedClassType = MockHandler.getTypeReference(typeFactory, parameterMatcher.getValue());
                    }
                }
                if (argument == null) break;
                JavaType actualJavaType = typeFactory.constructType(argument.getClass());
                if (expectedClassType.isPrimitive() || actualJavaType.isPrimitive()) {
                    Class<?> primitiveExpectedType = this.getPrimitiveType(expectedClassType);
                    Class<?> primitiveActualType = this.getPrimitiveType(expectedClassType);
                    mockMatched = Objects.equals(primitiveExpectedType, primitiveActualType);
                    break;
                }
                if (expectedClassType.getRawClass().isAssignableFrom(actualJavaType.getRawClass())) break;
                mockMatched = false;
                break;
            }
            case EQUAL: {
                try {
                    JsonNode argumentAsJsonNode = this.objectMapper.readTree(this.objectMapper.writeValueAsString(argument));
                    JsonNode expectedJsonNode = this.objectMapper.readTree(parameterMatcher.getValue());
                    if (expectedJsonNode.equals(argumentAsJsonNode)) break;
                    mockMatched = false;
                }
                catch (JsonProcessingException e) {
                    if (Objects.equals(argument, parameterMatcher.getValue())) break;
                    mockMatched = false;
                }
                break;
            }
            case ANY: {
                break;
            }
            case NULL: {
                mockMatched = argument == null;
                break;
            }
            case TRUE: {
                mockMatched = argument == Boolean.TRUE;
                break;
            }
            case FALSE: {
                mockMatched = argument == Boolean.FALSE;
                break;
            }
            case NOT_NULL: {
                mockMatched = argument != null;
                break;
            }
            case ANY_STRING: {
                mockMatched = argument instanceof String;
                break;
            }
            case STARTS_WITH: {
                mockMatched = argument instanceof String && ((String)argument).startsWith(parameterMatcher.getValue());
                break;
            }
            case ENDS_WITH: {
                mockMatched = argument instanceof String && ((String)argument).endsWith(parameterMatcher.getValue());
                break;
            }
            case MATCHES_REGEX: {
                mockMatched = argument instanceof String && Pattern.compile(parameterMatcher.getValue()).matcher((String)argument).matches();
                break;
            }
            case ANY_SHORT: {
                mockMatched = argument instanceof Short;
                break;
            }
            case ANY_CHAR: {
                mockMatched = argument instanceof Character;
                break;
            }
            case ANY_FLOAT: {
                mockMatched = argument instanceof Float;
                break;
            }
            case ANY_DOUBLE: {
                mockMatched = argument instanceof Double;
                break;
            }
            case ANY_BYTE: {
                mockMatched = argument instanceof Byte;
                break;
            }
            case ANY_BOOLEAN: {
                mockMatched = argument instanceof Boolean;
                break;
            }
            case ANY_MAP: {
                mockMatched = Map.class.isAssignableFrom(argument.getClass());
                break;
            }
            case ANY_SET: {
                mockMatched = Set.class.isAssignableFrom(argument.getClass());
                break;
            }
            case ANY_LIST: {
                mockMatched = List.class.isAssignableFrom(argument.getClass());
                break;
            }
            default: {
                throw new RuntimeException("Invalid " + parameterMatcher);
            }
        }
        return mockMatched;
    }

    private Class<?> getPrimitiveType(JavaType expectedClassType) {
        Class<?> rawClass = expectedClassType.getRawClass();
        if (expectedClassType.isPrimitive()) {
            return rawClass;
        }
        if (rawClass.equals(Byte.class)) {
            return Byte.TYPE;
        }
        if (rawClass.equals(Integer.class)) {
            return Integer.TYPE;
        }
        if (rawClass.equals(Boolean.class)) {
            return Boolean.TYPE;
        }
        if (rawClass.equals(Character.class)) {
            return Character.TYPE;
        }
        if (rawClass.equals(Float.class)) {
            return Float.TYPE;
        }
        if (rawClass.equals(Long.class)) {
            return Long.TYPE;
        }
        if (rawClass.equals(Short.class)) {
            return Short.TYPE;
        }
        if (rawClass.equals(Double.class)) {
            return Double.TYPE;
        }
        if (rawClass.equals(Void.class)) {
            return Void.TYPE;
        }
        return null;
    }

    public void addDeclaredMocks(List<DeclaredMock> declaredMocksForField) {
        this.declaredMocks.addAll(declaredMocksForField);
    }

    public void setDeclaredMocks(List<DeclaredMock> declaredMocksForField) {
        this.declaredMocks.clear();
        this.addDeclaredMocks(declaredMocksForField);
    }

    public Object getOriginalImplementation() {
        return this.originalImplementation;
    }

    public Object getOriginalFieldParent() {
        return this.originalFieldParent;
    }

    public void removeDeclaredMock(List<DeclaredMock> mocksToRemove) {
        this.declaredMocks.removeAll(mocksToRemove);
    }
}

