/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.mocking.construction;

import java.math.BigDecimal;
import java.net.URI;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import selogger.com.fasterxml.jackson.core.JsonProcessingException;
import selogger.com.fasterxml.jackson.databind.JavaType;
import selogger.com.fasterxml.jackson.databind.ObjectMapper;

public class JsonDeserializer {
    private final ObjectMapper objectMapper;
    private final Map<String, Function<Object, Object>> typeHandlers;

    public JsonDeserializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.typeHandlers = new HashMap<String, Function<Object, Object>>();
        this.initializeTypeHandlers();
    }

    private void initializeTypeHandlers() {
        this.typeHandlers.put(CompletableFuture.class.getCanonicalName(), value -> CompletableFuture.supplyAsync(() -> value));
        this.typeHandlers.put(Optional.class.getCanonicalName(), Optional::of);
        this.typeHandlers.put(LocalDate.class.getCanonicalName(), e -> LocalDate.parse((CharSequence)e));
        this.typeHandlers.put(LocalDateTime.class.getCanonicalName(), e -> LocalDateTime.parse((CharSequence)e));
        this.typeHandlers.put(BigDecimal.class.getCanonicalName(), e -> new BigDecimal(String.valueOf(e)));
        this.typeHandlers.put(URI.class.getCanonicalName(), e -> URI.create(String.valueOf(e)));
        this.typeHandlers.put(UUID.class.getCanonicalName(), e -> UUID.fromString(String.valueOf(e)));
    }

    public Object createInstance(String value, JavaType typeReference) {
        String topClassCanonicalName;
        Function<Object, Object> handler;
        if (typeReference.containedTypeCount() > 0 && (handler = this.typeHandlers.get(topClassCanonicalName = typeReference.getRawClass().getCanonicalName())) != null) {
            Object containedValue = this.createInstance(value, typeReference.containedType(0));
            return handler.apply(containedValue);
        }
        try {
            return this.objectMapper.readValue(value, typeReference);
        }
        catch (JsonProcessingException e) {
            return e;
        }
    }
}

