/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.runner;

import io.unlogged.atomic.MethodUnderTest;
import io.unlogged.atomic.StoredCandidate;
import io.unlogged.atomic.StoredCandidateMetadata;
import io.unlogged.mocking.DeclaredMock;
import io.unlogged.runner.AtomicRecord;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import selogger.com.fasterxml.jackson.databind.ObjectMapper;
import selogger.org.slf4j.Logger;
import selogger.org.slf4j.LoggerFactory;

public class AtomicRecordService {
    public static final String TEST_CONTENT_PATH = "src" + File.separator + "test" + File.separator;
    public static final String TEST_RESOURCES_PATH = TEST_CONTENT_PATH + "resources" + File.separator;
    private static final Logger logger = LoggerFactory.getLogger(AtomicRecordService.class);
    private final String UNLOGGED_RESOURCE_FOLDER_NAME = "unlogged";
    private final ObjectMapper objectMapper = new ObjectMapper();
    private Map<String, AtomicRecord> classAtomicRecordMap = null;

    public String getTestResourcesPath() {
        return TEST_RESOURCES_PATH + File.separator + "unlogged";
    }

    public Map<String, List<StoredCandidate>> filterCandidates(Map<String, List<StoredCandidate>> candidates) {
        if (candidates == null || candidates.size() == 0) {
            return null;
        }
        for (String methodHashKey : candidates.keySet()) {
            TreeMap<Integer, StoredCandidate> storedCandidateMap = new TreeMap<Integer, StoredCandidate>();
            List<StoredCandidate> storedCandidateList = candidates.get(methodHashKey);
            for (StoredCandidate candidate : storedCandidateList) {
                if (candidate.getName() == null) continue;
                int hash = candidate.getMethodArguments().hashCode() + candidate.getMethod().getName().hashCode();
                if (storedCandidateMap.containsKey(hash)) {
                    if (((StoredCandidate)storedCandidateMap.get(hash)).getMetadata().getTimestamp() >= candidate.getMetadata().getTimestamp()) continue;
                    storedCandidateMap.put(hash, candidate);
                    continue;
                }
                storedCandidateMap.put(hash, candidate);
            }
            candidates.put(methodHashKey, new ArrayList(storedCandidateMap.values()));
        }
        return candidates;
    }

    private List<File> getFilesInUnloggedFolder() {
        ArrayList<File> returnFileList = new ArrayList<File>();
        File rootDir = new File(TEST_RESOURCES_PATH + "unlogged");
        File[] files = rootDir.listFiles();
        if (files != null) {
            Collections.addAll(returnFileList, files);
        }
        return returnFileList;
    }

    public Map<String, AtomicRecord> updateMap() {
        TreeMap<String, AtomicRecord> recordsMap = new TreeMap<String, AtomicRecord>();
        List<File> files = this.getFilesInUnloggedFolder();
        for (File file : files) {
            AtomicRecord record = this.getAtomicRecordFromFile(file);
            logger.info("Loaded " + (int)record.getStoredCandidateMap().values().stream().flatMap(Collection::stream).count() + " candidates from resource file: " + file.getPath());
            if (record == null) continue;
            String classname = record.getClassname();
            recordsMap.put(classname, record);
        }
        return recordsMap;
    }

    private AtomicRecord getAtomicRecordFromFile(File file) {
        try {
            if (file == null || !file.exists()) {
                return null;
            }
            FileInputStream inputStream = new FileInputStream(file);
            return this.objectMapper.readValue((InputStream)inputStream, AtomicRecord.class);
        }
        catch (IOException e) {
            logger.error("Exception getting atomic record from file", e);
            return null;
        }
    }

    public List<StoredCandidate> getStoredCandidatesForMethod(MethodUnderTest methodUnderTest) {
        if (methodUnderTest.getClassName() == null) {
            return new ArrayList<StoredCandidate>();
        }
        AtomicRecord record = this.classAtomicRecordMap.get(methodUnderTest.getClassName());
        if (record == null) {
            return new ArrayList<StoredCandidate>();
        }
        return record.getStoredCandidateMap().getOrDefault(methodUnderTest.getMethodHashKey(), new ArrayList());
    }

    public void setCandidateStateForCandidate(String candidateID, String classname, String methodKey, StoredCandidateMetadata.CandidateStatus state) {
        AtomicRecord record = this.classAtomicRecordMap.get(classname);
        if (record == null || !record.getStoredCandidateMap().containsKey(methodKey) || record.getStoredCandidateMap().get(methodKey).size() == 0) {
            return;
        }
        List<StoredCandidate> list = record.getStoredCandidateMap().get(methodKey);
        for (StoredCandidate candidate : list) {
            if (!candidateID.equals(candidate.getCandidateId())) continue;
            candidate.getMetadata().setCandidateStatus(state);
        }
    }

    public List<DeclaredMock> getDeclaredMocksOf(MethodUnderTest methodUnderTest) {
        String methodHashKey;
        if (!this.classAtomicRecordMap.containsKey(methodUnderTest.getClassName())) {
            return new ArrayList<DeclaredMock>();
        }
        Map<String, List<DeclaredMock>> declaredMockMap = this.classAtomicRecordMap.get(methodUnderTest.getClassName()).getDeclaredMockMap();
        if (!declaredMockMap.containsKey(methodHashKey = methodUnderTest.getMethodHashKey())) {
            return new ArrayList<DeclaredMock>();
        }
        return declaredMockMap.get(methodHashKey);
    }

    public List<DeclaredMock> getDeclaredMocksFor(MethodUnderTest methodUnderTest) {
        return this.classAtomicRecordMap.values().stream().map(e -> e.getDeclaredMockMap().values()).flatMap(Collection::stream).flatMap(Collection::stream).filter(e -> e.getSourceClassName() != null && e.getSourceClassName().equals(methodUnderTest.getClassName())).collect(Collectors.toList());
    }

    public List<DeclaredMock> getAllDeclaredMocks() {
        return this.classAtomicRecordMap.values().stream().map(e -> e.getDeclaredMockMap().values()).flatMap(Collection::stream).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Map<String, List<StoredCandidate>> getCandidatesByClass(String fullyClassifiedClassName) {
        if (!this.classAtomicRecordMap.containsKey(fullyClassifiedClassName)) {
            return null;
        }
        return this.classAtomicRecordMap.get(fullyClassifiedClassName).getStoredCandidateMap();
    }

    public static enum FileUpdateType {
        ADD_MOCK,
        UPDATE_MOCK,
        DELETE_MOCK,
        ADD_CANDIDATE,
        UPDATE_CANDIDATE,
        DELETE_CANDIDATE;

    }
}

