/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.util;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import selogger.com.fasterxml.jackson.databind.JavaType;
import selogger.com.fasterxml.jackson.databind.type.TypeFactory;

public class ClassTypeUtil {
    public static List<String> splitMethodDesc(String desc) {
        int beginIndex = desc.indexOf(40);
        int endIndex = desc.lastIndexOf(41);
        if (beginIndex == -1 && endIndex != -1 || beginIndex != -1 && endIndex == -1) {
            System.err.println(beginIndex);
            System.err.println(endIndex);
            throw new RuntimeException();
        }
        String x0 = beginIndex == -1 && endIndex == -1 ? desc : desc.substring(beginIndex + 1, endIndex);
        Pattern pattern = Pattern.compile("\\[*L[^;]+;|\\[[ZBCSIFDJ]|[ZBCSIFDJ]");
        Matcher matcher = pattern.matcher(x0);
        LinkedList<String> listMatches = new LinkedList<String>();
        while (matcher.find()) {
            listMatches.add(matcher.group());
        }
        listMatches.add(desc.substring(endIndex + 1));
        return listMatches;
    }

    public static JavaType getClassNameFromDescriptor(String descriptor, TypeFactory typeFactory) {
        if (descriptor.endsWith("[]")) {
            return typeFactory.constructArrayType(ClassTypeUtil.getClassNameFromDescriptor(descriptor.substring(0, descriptor.length() - 2), typeFactory));
        }
        char firstChar = descriptor.charAt(0);
        switch (firstChar) {
            case 'V': {
                return typeFactory.constructSimpleType(Void.TYPE, null);
            }
            case 'Z': {
                return typeFactory.constructSimpleType(Boolean.TYPE, null);
            }
            case 'B': {
                return typeFactory.constructSimpleType(Byte.TYPE, null);
            }
            case 'C': {
                return typeFactory.constructSimpleType(Character.TYPE, null);
            }
            case 'S': {
                return typeFactory.constructSimpleType(Short.TYPE, null);
            }
            case 'I': {
                return typeFactory.constructSimpleType(Integer.TYPE, null);
            }
            case 'J': {
                return typeFactory.constructSimpleType(Long.TYPE, null);
            }
            case 'F': {
                return typeFactory.constructSimpleType(Float.TYPE, null);
            }
            case 'D': {
                return typeFactory.constructSimpleType(Double.TYPE, null);
            }
            case 'L': {
                String className = descriptor.substring(1, descriptor.length() - 1).replace('/', '.');
                return typeFactory.constructFromCanonical(className);
            }
            case '[': {
                String componentClassName = descriptor.substring(1);
                return typeFactory.constructArrayType(ClassTypeUtil.getClassNameFromDescriptor(componentClassName, typeFactory));
            }
        }
        if (descriptor.startsWith("byte")) {
            return typeFactory.constructSimpleType(Byte.TYPE, null);
        }
        if (descriptor.startsWith("boolean")) {
            return typeFactory.constructSimpleType(Boolean.TYPE, null);
        }
        if (descriptor.startsWith("long")) {
            return typeFactory.constructSimpleType(Long.TYPE, null);
        }
        if (descriptor.startsWith("float")) {
            return typeFactory.constructSimpleType(Float.TYPE, null);
        }
        if (descriptor.startsWith("short")) {
            return typeFactory.constructSimpleType(Short.TYPE, null);
        }
        if (descriptor.startsWith("int")) {
            return typeFactory.constructSimpleType(Integer.TYPE, null);
        }
        if (descriptor.startsWith("double")) {
            return typeFactory.constructSimpleType(Double.TYPE, null);
        }
        if (descriptor.startsWith("void")) {
            return typeFactory.constructSimpleType(Void.TYPE, null);
        }
        if (descriptor.startsWith("char")) {
            return typeFactory.constructSimpleType(Character.TYPE, null);
        }
        return typeFactory.constructFromCanonical(descriptor);
    }
}

