/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public class StreamUtil {
    public static final int BUFFER_SIZE = 8192;

    public static int copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int read;
        byte[] buffer = new byte[8192];
        int total = 0;
        while ((read = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, read);
            total += read;
        }
        return total;
    }

    public static String streamToString(InputStream stream) throws IOException {
        int numRead;
        int bufferSize = 1024;
        char[] buffer = new char[bufferSize];
        StringBuilder out = new StringBuilder();
        InputStreamReader in = new InputStreamReader(stream, StandardCharsets.UTF_8);
        while ((numRead = ((Reader)in).read(buffer, 0, buffer.length)) > 0) {
            out.append(buffer, 0, numRead);
        }
        return out.toString();
    }

    public static byte[] streamToBytes(InputStream stream) throws IOException {
        int numRead;
        int bufferSize = 1024;
        byte[] buffer = new byte[bufferSize];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((numRead = stream.read(buffer, 0, buffer.length)) > 0) {
            out.write(buffer, 0, numRead);
        }
        return out.toByteArray();
    }
}

