/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.weaver;

import com.insidious.common.weaver.LogLevel;
import io.unlogged.weaver.WeaveParameters;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.UUID;

public class WeaveConfig {
    public static final String KEY_RECORD_DEFAULT = "";
    public static final String KEY_RECORD_ALL = "ALL";
    public static final String KEY_RECORD_DEFAULT_PLUS_LOCAL = "EXEC+CALL+FIELD+ARRAY+SYNC+OBJECT+PARAM+LOCAL";
    public static final String KEY_RECORD_REPLAY = "EXEC+CALL+FIELD+ARRAY+SYNC+OBJECT+PARAM+LOCAL";
    public static final String KEY_RECORD_NONE = "NONE";
    public static final String KEY_RECORD_EXEC = "EXEC";
    public static final String KEY_RECORD_CALL = "CALL";
    public static final String KEY_RECORD_FIELD = "FIELD";
    public static final String KEY_RECORD_ARRAY = "ARRAY";
    public static final String KEY_RECORD_SYNC = "SYNC";
    public static final String KEY_RECORD_OBJECT = "OBJECT";
    public static final String KEY_RECORD_LABEL = "LABEL";
    public static final String KEY_RECORD_PARAMETERS = "PARAM";
    public static final String KEY_RECORD_LOCAL = "LOCAL";
    public static final String KEY_RECORD_LINE = "LINE";
    private static final String KEY_RECORD = "Events";
    private static final String KEY_RECORD_SEPARATOR = ",";
    private Integer processId;
    private String sessionId;
    private boolean weaveExec = true;
    private boolean weaveMethodCall = true;
    private boolean weaveFieldAccess = true;
    private boolean weaveArray = true;
    private boolean weaveLabel = true;
    private boolean weaveSynchronization = true;
    private boolean weaveParameters = true;
    private boolean weaveLocalAccess = true;
    private String username;
    private String password;
    private boolean weaveObject = true;
    private boolean weaveLineNumber = true;
    private boolean ignoreArrayInitializer = false;
    private boolean weaveNone = false;
    private String authToken;

    public WeaveConfig(WeaveConfig parent, LogLevel level) {
        this.weaveExec = parent.weaveExec;
        this.weaveMethodCall = parent.weaveMethodCall;
        this.weaveFieldAccess = parent.weaveFieldAccess;
        this.weaveArray = parent.weaveArray;
        this.weaveSynchronization = parent.weaveSynchronization;
        this.weaveLabel = parent.weaveLabel;
        this.weaveParameters = parent.weaveParameters;
        this.weaveLocalAccess = parent.weaveLocalAccess;
        this.weaveLineNumber = parent.weaveLineNumber;
        this.ignoreArrayInitializer = parent.ignoreArrayInitializer;
        this.weaveNone = parent.weaveNone;
        if (level == LogLevel.IgnoreArrayInitializer) {
            this.ignoreArrayInitializer = true;
        } else if (level == LogLevel.OnlyEntryExit) {
            this.weaveMethodCall = false;
            this.weaveFieldAccess = false;
            this.weaveArray = false;
            this.weaveSynchronization = false;
            this.weaveLabel = false;
            this.weaveParameters = false;
            this.weaveLocalAccess = false;
            this.weaveObject = false;
            this.weaveLineNumber = false;
        }
    }

    public WeaveConfig(WeaveParameters weaveParameters) {
        String options = weaveParameters.getWeaveOption();
        String opt = options.toUpperCase();
        if (opt.equals(KEY_RECORD_ALL)) {
            opt = "EXECCALLFIELDARRAYSYNCOBJECTPARAMLOCAL";
        } else if (opt.equals(KEY_RECORD_DEFAULT)) {
            opt = "EXECCALLFIELDARRAYSYNCOBJECTPARAM";
        } else if (opt.equals(KEY_RECORD_NONE)) {
            opt = KEY_RECORD_DEFAULT;
            this.weaveNone = true;
        }
        this.weaveExec = opt.contains(KEY_RECORD_EXEC);
        this.weaveMethodCall = opt.contains(KEY_RECORD_CALL);
        this.weaveFieldAccess = opt.contains(KEY_RECORD_FIELD);
        this.weaveArray = opt.contains(KEY_RECORD_ARRAY);
        this.weaveSynchronization = opt.contains(KEY_RECORD_SYNC);
        this.weaveLabel = opt.contains(KEY_RECORD_LABEL);
        this.weaveParameters = opt.contains(KEY_RECORD_PARAMETERS);
        this.weaveLocalAccess = opt.contains(KEY_RECORD_LOCAL);
        this.weaveObject = opt.contains(KEY_RECORD_OBJECT);
        this.weaveLineNumber = opt.contains(KEY_RECORD_LINE);
        this.ignoreArrayInitializer = false;
        this.username = weaveParameters.getUsername();
        this.password = weaveParameters.getPassword();
        this.sessionId = UUID.randomUUID().toString();
    }

    private static Integer getProcessId(Integer fallback) {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index < 1) {
            return fallback;
        }
        try {
            return Integer.parseInt(jvmName.substring(0, index));
        }
        catch (NumberFormatException numberFormatException) {
            return fallback;
        }
    }

    public boolean isValid() {
        return this.weaveNone || this.weaveExec || this.weaveMethodCall || this.weaveFieldAccess || this.weaveArray || this.weaveSynchronization || this.weaveParameters || this.weaveLocalAccess || this.weaveLabel || this.weaveLineNumber;
    }

    public boolean recordExecution() {
        return this.weaveExec;
    }

    public boolean recordSynchronization() {
        return this.weaveSynchronization;
    }

    public boolean recordFieldAccess() {
        return this.weaveFieldAccess;
    }

    public boolean recordMethodCall() {
        return this.weaveMethodCall;
    }

    public boolean recordArrayInstructions() {
        return this.weaveArray;
    }

    public boolean recordLabel() {
        return this.weaveLabel;
    }

    public boolean recordParameters() {
        return this.weaveParameters;
    }

    public boolean recordLocalAccess() {
        return this.weaveLocalAccess;
    }

    public boolean recordLineNumber() {
        return this.weaveLineNumber;
    }

    public boolean ignoreArrayInitializer() {
        return this.ignoreArrayInitializer;
    }

    public boolean recordCatch() {
        return this.recordMethodCall() || this.recordFieldAccess() || this.recordArrayInstructions() || this.recordLabel() || this.recordSynchronization();
    }

    public boolean recordObject() {
        return this.weaveObject;
    }

    public void save(File propertyFile) {
        ArrayList<String> events = new ArrayList<String>();
        if (this.weaveExec) {
            events.add(KEY_RECORD_EXEC);
        }
        if (this.weaveMethodCall) {
            events.add(KEY_RECORD_CALL);
        }
        if (this.weaveFieldAccess) {
            events.add(KEY_RECORD_FIELD);
        }
        if (this.weaveArray) {
            events.add(KEY_RECORD_ARRAY);
        }
        if (this.weaveSynchronization) {
            events.add(KEY_RECORD_SYNC);
        }
        if (this.weaveLabel) {
            events.add(KEY_RECORD_LABEL);
        }
        if (this.weaveParameters) {
            events.add(KEY_RECORD_PARAMETERS);
        }
        if (this.weaveLocalAccess) {
            events.add(KEY_RECORD_LOCAL);
        }
        if (this.weaveObject) {
            events.add(KEY_RECORD_OBJECT);
        }
        if (this.weaveLineNumber) {
            events.add(KEY_RECORD_LINE);
        }
        if (this.weaveNone) {
            events.add(KEY_RECORD_NONE);
        }
        StringBuilder eventsString = new StringBuilder();
        for (int i = 0; i < events.size(); ++i) {
            if (i > 0) {
                eventsString.append(KEY_RECORD_SEPARATOR);
            }
            eventsString.append((String)events.get(i));
        }
        Properties prop = new Properties();
        prop.setProperty(KEY_RECORD, eventsString.toString());
        try {
            FileOutputStream out = new FileOutputStream(propertyFile);
            prop.store(out, "Generated: " + new Date());
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public String getSessionId() {
        return this.sessionId;
    }
}

