/*
 * Decompiled with CFR 0.152.
 */
package orestes.bloomfilter;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import orestes.bloomfilter.FilterBuilder;
import orestes.bloomfilter.MigratableBloomFilter;

public interface BloomFilter<T>
extends Cloneable,
Serializable {
    public boolean addRaw(byte[] var1);

    default public boolean add(T element) {
        return this.addRaw(this.toBytes(element));
    }

    default public List<Boolean> addAll(Collection<T> elements) {
        return elements.stream().map(this::add).collect(Collectors.toList());
    }

    public void clear();

    public boolean contains(byte[] var1);

    default public boolean contains(T element) {
        return this.contains(this.toBytes(element));
    }

    default public List<Boolean> contains(Collection<T> elements) {
        return elements.stream().map(this::contains).collect(Collectors.toList());
    }

    default public boolean containsAll(Collection<T> elements) {
        return elements.stream().allMatch(this::contains);
    }

    public BitSet getBitSet();

    public FilterBuilder config();

    public BloomFilter<T> clone();

    default public int getSize() {
        return this.config().size();
    }

    default public int getExpectedElements() {
        return this.config().expectedElements();
    }

    default public int getHashes() {
        return this.config().hashes();
    }

    default public double getFalsePositiveProbability() {
        return this.config().falsePositiveProbability();
    }

    default public byte[] toBytes(T element) {
        return element.toString().getBytes(FilterBuilder.defaultCharset());
    }

    @Deprecated
    default public boolean compatible(BloomFilter<T> bloomFilter, BloomFilter<T> other) {
        return bloomFilter.compatible(other);
    }

    default public boolean compatible(BloomFilter<T> other) {
        return this.config().isCompatibleTo(other.config());
    }

    default public void remove() {
        this.clear();
    }

    default public int[] hash(byte[] bytes) {
        return this.config().hashFunction().hash(bytes, this.config().size(), this.config().hashes());
    }

    default public int[] hash(String value) {
        return this.hash(value.getBytes(FilterBuilder.defaultCharset()));
    }

    public boolean union(BloomFilter<T> var1);

    public boolean intersect(BloomFilter<T> var1);

    public boolean isEmpty();

    default public double getFalsePositiveProbability(double insertedElements) {
        return FilterBuilder.optimalP(this.config().hashes(), this.config().size(), insertedElements);
    }

    default public double getEstimatedFalsePositiveProbability() {
        return this.getFalsePositiveProbability(this.getEstimatedPopulation());
    }

    default public double getBitsPerElement(int n) {
        return (double)this.config().size() / (double)n;
    }

    default public double getBitZeroProbability(int n) {
        return Math.pow(1.0 - 1.0 / (double)this.config().size(), this.config().hashes() * n);
    }

    default public Double getEstimatedPopulation() {
        return BloomFilter.population(this.getBitSet(), this.config());
    }

    public static Double population(BitSet bitSet, FilterBuilder config) {
        int oneBits = bitSet.cardinality();
        return (double)(-config.size()) / (double)config.hashes() * Math.log(1.0 - (double)oneBits / (double)config.size());
    }

    default public String asString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Bloom Filter Parameters: ");
        sb.append("size = " + this.config().size() + ", ");
        sb.append("hashes = " + this.config().hashes() + ", ");
        sb.append("Bits: " + this.getBitSet().toString());
        return sb.toString();
    }

    default public <U extends MigratableBloomFilter<T>> U migrateTo(U destination) {
        destination.migrateFrom(this);
        return destination;
    }
}

