/*
 * Decompiled with CFR 0.152.
 */
package orestes.bloomfilter;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import orestes.bloomfilter.BloomFilter;

public interface CountingBloomFilter<T>
extends BloomFilter<T> {
    default public int getCountingBits() {
        return this.config().countingBits();
    }

    public Map<Integer, Long> getCountMap();

    @Override
    default public boolean addRaw(byte[] element) {
        return this.addAndEstimateCountRaw(element) == 1L;
    }

    default public boolean removeRaw(byte[] element) {
        return this.removeAndEstimateCountRaw(element) <= 0L;
    }

    default public boolean remove(T element) {
        return this.removeRaw(this.toBytes(element));
    }

    default public List<Boolean> removeAll(Collection<T> elements) {
        return elements.stream().map(this::remove).collect(Collectors.toList());
    }

    public long getEstimatedCount(T var1);

    public long addAndEstimateCountRaw(byte[] var1);

    default public long addAndEstimateCount(T element) {
        return this.addAndEstimateCountRaw(this.toBytes(element));
    }

    public long removeAndEstimateCountRaw(byte[] var1);

    default public long removeAndEstimateCount(T element) {
        return this.removeAndEstimateCountRaw(this.toBytes(element));
    }

    @Override
    public CountingBloomFilter<T> clone();
}

