/*
 * Decompiled with CFR 0.152.
 */
package orestes.bloomfilter;

import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.BitSet;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class HashProvider {
    private static final int seed32 = 0x55555B7;

    static int hashBytes(byte[] a) {
        long FNV_PRIME = 16777619L;
        long FNV_OFFSET_BASIS = 2166136261L;
        if (a == null) {
            return 0;
        }
        long result = FNV_OFFSET_BASIS;
        for (byte element : a) {
            result = result * FNV_PRIME & 0xFFFFFFFFFFFFFFFFL;
            result ^= (long)element;
        }
        return (int)result;
    }

    public static int[] hashCarterWegman(byte[] value, int m, int k) {
        int[] positions = new int[k];
        BigInteger prime32 = BigInteger.valueOf(0xFFFFFFEFL);
        BigInteger prime64 = BigInteger.valueOf(53200200938189L);
        BigInteger prime128 = new BigInteger("21213943449988109084994671");
        Random r = new Random(0x55555B7L);
        BigInteger v = new BigInteger(value.length > 0 ? value : new byte[1]);
        for (int i = 0; i < k; ++i) {
            BigInteger a = BigInteger.valueOf(r.nextLong());
            BigInteger b = BigInteger.valueOf(r.nextLong());
            positions[i] = a.multiply(v).add(b).mod(prime64).mod(BigInteger.valueOf(m)).intValue();
        }
        return positions;
    }

    public static int[] hashRNG(byte[] value, int m, int k) {
        int[] positions = new int[k];
        Random r = new Random(HashProvider.hashBytes(value));
        for (int i = 0; i < k; ++i) {
            positions[i] = r.nextInt(m);
        }
        return positions;
    }

    public static int[] hashCRC(byte[] value, int m, int k) {
        return HashProvider.hashChecksum(value, new CRC32(), m, k);
    }

    public static int[] hashAdler(byte[] value, int m, int k) {
        return HashProvider.hashChecksum(value, new Adler32(), m, k);
    }

    public static int[] hashChecksum(byte[] value, Checksum cs, int m, int k) {
        int[] positions = new int[k];
        int hashes = 0;
        int salt = 0;
        while (hashes < k) {
            cs.reset();
            cs.update(value, 0, value.length);
            cs.update(hashes + salt++ + 0x55555B7);
            int hash = HashProvider.rejectionSample((int)cs.getValue(), m);
            if (hash == -1) continue;
            positions[hashes++] = hash;
        }
        return positions;
    }

    public static int[] hashSimpleLCG(byte[] value, int m, int k) {
        long multiplier = 25214903917L;
        long addend = 11L;
        long mask = 0xFFFFFFFFFFFFL;
        int reduced = Math.abs(HashProvider.hashBytes(value));
        if (reduced == Integer.MIN_VALUE) {
            reduced = 42;
        }
        int[] positions = new int[k];
        long seed = reduced;
        for (int i = 0; i < k; ++i) {
            seed = seed * multiplier + addend & mask;
            positions[i] = (int)(seed >>> 18) % m;
        }
        return positions;
    }

    public static int[] hashMurmur3(byte[] value, int m, int k) {
        return HashProvider.rejectionSample(HashProvider::murmur3_signed, value, m, k);
    }

    public static int[] hashCassandra(byte[] value, int m, int k) {
        int[] result = new int[k];
        long hash1 = HashProvider.murmur3(0, value);
        long hash2 = HashProvider.murmur3((int)hash1, value);
        for (int i = 0; i < k; ++i) {
            result[i] = (int)((hash1 + (long)i * hash2) % (long)m);
        }
        return result;
    }

    public static long murmur3(int seed, byte[] bytes) {
        return Integer.toUnsignedLong(HashProvider.murmur3_signed(seed, bytes));
    }

    public static int murmur3_signed(int seed, byte[] bytes) {
        int k1;
        int len;
        int h1 = seed;
        int c1 = -862048943;
        int c2 = 461845907;
        int i = 0;
        for (len = bytes.length; len >= 4; len -= 4) {
            k1 = bytes[i++] & 0xFF;
            k1 |= (bytes[i++] & 0xFF) << 8;
            k1 |= (bytes[i++] & 0xFF) << 16;
            k1 |= (bytes[i++] & 0xFF) << 24;
            k1 *= c1;
            k1 = Integer.rotateLeft(k1, 15);
            h1 ^= (k1 *= c2);
            h1 = Integer.rotateLeft(h1, 13);
            h1 = h1 * 5 + -430675100;
        }
        k1 = 0;
        switch (len) {
            case 3: {
                k1 ^= (bytes[i + 2] & 0xFF) << 16;
            }
            case 2: {
                k1 ^= (bytes[i + 1] & 0xFF) << 8;
            }
            case 1: {
                k1 ^= bytes[i] & 0xFF;
                k1 *= c1;
                k1 = Integer.rotateLeft(k1, 15);
                h1 ^= (k1 *= c2);
            }
        }
        h1 ^= (i += len);
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return h1;
    }

    public static int[] hashMurmur2(byte[] value, int em, int ka) {
        int[] positions = new int[ka];
        int hashes = 0;
        int lastHash = 0;
        byte[] data = (byte[])value.clone();
        while (hashes < ka) {
            int len;
            for (int i = 0; i < value.length; ++i) {
                if (data[i] != 127) {
                    int n = i;
                    data[n] = (byte)(data[n] + 1);
                    break;
                }
                data[i] = 0;
            }
            int m = 1540483477;
            int r = 24;
            int h = 0x55555B7 ^ len;
            int i = 0;
            for (len = data.length; len >= 4; len -= 4) {
                int k = data[i + 0] & 0xFF;
                k |= (data[i + 1] & 0xFF) << 8;
                k |= (data[i + 2] & 0xFF) << 16;
                k |= (data[i + 3] & 0xFF) << 24;
                k *= m;
                k ^= k >>> r;
                h *= m;
                h ^= (k *= m);
                i += 4;
            }
            switch (len) {
                case 3: {
                    h ^= (data[i + 2] & 0xFF) << 16;
                }
                case 2: {
                    h ^= (data[i + 1] & 0xFF) << 8;
                }
                case 1: {
                    h ^= data[i + 0] & 0xFF;
                    h *= m;
                }
            }
            h ^= h >>> 13;
            h *= m;
            if ((lastHash = HashProvider.rejectionSample(h ^= h >>> 15, em)) == -1) continue;
            positions[hashes++] = lastHash;
        }
        return positions;
    }

    public static int rejectionSample(int random, int m) {
        if ((random = Math.abs(random)) > Integer.MAX_VALUE - Integer.MAX_VALUE % m || random == Integer.MIN_VALUE) {
            return -1;
        }
        return random % m;
    }

    public static int[] rejectionSample(BiFunction<Integer, byte[], Integer> hashFunction, byte[] value, int m, int k) {
        int[] hashes = new int[k];
        int seed = 0;
        int pos = 0;
        while (pos < k) {
            int hash = HashProvider.rejectionSample(seed = hashFunction.apply(seed, value).intValue(), m);
            if (hash == -1) continue;
            hashes[pos++] = hash;
        }
        return hashes;
    }

    public static int[] hashCrypt(byte[] value, int m, int k, String method) {
        MessageDigest cryptHash = null;
        try {
            cryptHash = MessageDigest.getInstance(method);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        int[] positions = new int[k];
        int computedHashes = 0;
        Random r = new Random(0x55555B7L);
        byte[] digest = new byte[]{};
        while (computedHashes < k) {
            cryptHash.update(digest);
            digest = cryptHash.digest(value);
            BitSet hashed = BitSet.valueOf(digest);
            int filterSize = 32 - Integer.numberOfLeadingZeros(m);
            int hashBits = digest.length * 8;
            for (int split = 0; split < hashBits / filterSize && computedHashes < k; ++split) {
                int intHash;
                int from = split * filterSize;
                int to = (split + 1) * filterSize;
                BitSet hashSlice = hashed.get(from, to);
                long[] longHash = hashSlice.toLongArray();
                int n = intHash = longHash.length > 0 ? (int)longHash[0] : 0;
                if (intHash >= m) continue;
                positions[computedHashes] = intHash;
                ++computedHashes;
            }
        }
        return positions;
    }

    public static enum HashMethod {
        RNG(HashProvider::hashRNG),
        CarterWegman(HashProvider::hashCarterWegman),
        CRC32(HashProvider::hashCRC),
        Adler32(HashProvider::hashAdler),
        Murmur2(HashProvider::hashMurmur2),
        Murmur3(HashProvider::hashMurmur3),
        Murmur3KirschMitzenmacher(HashProvider::hashCassandra),
        FNVWithLCG(HashProvider::hashSimpleLCG),
        MD2((bytes, m, k) -> HashProvider.hashCrypt(bytes, m, k, "MD2")),
        MD5((bytes, m, k) -> HashProvider.hashCrypt(bytes, m, k, "MD5")),
        SHA1((bytes, m, k) -> HashProvider.hashCrypt(bytes, m, k, "SHA-1")),
        SHA256((bytes, m, k) -> HashProvider.hashCrypt(bytes, m, k, "SHA-256")),
        SHA384((bytes, m, k) -> HashProvider.hashCrypt(bytes, m, k, "SHA-384")),
        SHA512((bytes, m, k) -> HashProvider.hashCrypt(bytes, m, k, "SHA-512"));

        private HashFunction hashFunction;

        private HashMethod(HashFunction hashFunction) {
            this.hashFunction = hashFunction;
        }

        public HashFunction getHashFunction() {
            return this.hashFunction;
        }
    }

    public static interface HashFunction
    extends Serializable {
        public int[] hash(byte[] var1, int var2, int var3);
    }
}

