/*
 * Decompiled with CFR 0.152.
 */
package orestes.bloomfilter.cachesketch;

import java.time.Clock;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import orestes.bloomfilter.ExpirationMapAware;

public interface ExpirationQueue<T>
extends Iterable<T>,
ExpirationMapAware<T> {
    default public boolean addTTL(T item, long ttl, TimeUnit ttlUnit) {
        return this.add(new ExpiringItem<T>(item, this.now() + TimeUnit.MILLISECONDS.convert(ttl, ttlUnit), TimeUnit.MILLISECONDS));
    }

    default public boolean addExpiration(T item, long timestamp, TimeUnit timeUnit) {
        return this.add(new ExpiringItem<T>(item, timestamp, timeUnit));
    }

    public boolean enable();

    public boolean disable();

    default public boolean setEnabled(boolean enabled) {
        return enabled ? this.enable() : this.disable();
    }

    public int size();

    public boolean add(ExpiringItem<T> var1);

    public Collection<ExpiringItem<T>> getNonExpired();

    public void clear();

    public boolean contains(T var1);

    public boolean remove(T var1);

    default public long now() {
        return Clock.systemUTC().millis();
    }

    @Override
    default public Iterator<T> iterator() {
        return this.getNonExpired().stream().map(ExpiringItem::getItem).iterator();
    }

    public static class ExpiringItem<T>
    implements Delayed {
        private final T item;
        private final long expiration;

        public ExpiringItem(T item, long expiration, TimeUnit timeUnit) {
            this.item = item;
            this.expiration = TimeUnit.MILLISECONDS.convert(expiration, timeUnit);
        }

        public T getItem() {
            return this.item;
        }

        public long getExpiration(TimeUnit timeUnit) {
            return timeUnit.convert(this.expiration, TimeUnit.MILLISECONDS);
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.expiration - Clock.systemUTC().millis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed delayed) {
            return Long.compare(this.getDelay(TimeUnit.MILLISECONDS), delayed.getDelay(TimeUnit.MILLISECONDS));
        }

        public String toString() {
            return this.getItem() + " expires in " + this.getDelay(TimeUnit.SECONDS) + "s";
        }
    }
}

