/*
 * Decompiled with CFR 0.152.
 */
package orestes.bloomfilter.cachesketch;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import orestes.bloomfilter.BloomFilter;
import orestes.bloomfilter.CountingBloomFilter;
import orestes.bloomfilter.ExpirationMapAware;
import orestes.bloomfilter.MigratableBloomFilter;
import orestes.bloomfilter.TimeToLiveMapAware;

public interface ExpiringBloomFilter<T>
extends CountingBloomFilter<T>,
TimeToLiveMapAware<T>,
ExpirationMapAware<T>,
MigratableBloomFilter<T> {
    default public boolean isCached(T element) {
        return this.getRemainingTTL(element, TimeUnit.MILLISECONDS) != null;
    }

    public boolean isKnown(T var1);

    public List<Boolean> isKnown(List<T> var1);

    default public Long getRemainingTTL(T element, TimeUnit unit) {
        return this.getTimeToLiveMap().getRemaining(element, unit);
    }

    default public List<Long> getRemainingTTLs(List<T> elements, TimeUnit unit) {
        return elements.stream().map(el -> this.getRemainingTTL(el, unit)).collect(Collectors.toList());
    }

    default public void cleanupTTLs() {
        throw new UnsupportedOperationException();
    }

    public void reportRead(T var1, long var2, TimeUnit var4);

    public Long reportWrite(T var1, TimeUnit var2);

    default public boolean reportWrite(T element) {
        return this.reportWrite(element, TimeUnit.MILLISECONDS) != null;
    }

    default public List<Boolean> reportWrites(List<T> elements) {
        return elements.stream().map(this::reportWrite).collect(Collectors.toList());
    }

    default public List<Long> reportWrites(List<T> elements, TimeUnit unit) {
        return elements.stream().map(el -> this.reportWrite(el, unit)).collect(Collectors.toList());
    }

    public boolean setExpirationEnabled(boolean var1);

    default public boolean enableExpiration() {
        return this.setExpirationEnabled(true);
    }

    default public boolean disableExpiration() {
        return this.setExpirationEnabled(false);
    }

    public BloomFilter<T> getClonedBloomFilter();

    public void softClear();
}

