/*
 * Decompiled with CFR 0.152.
 */
package orestes.bloomfilter.cachesketch;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import orestes.bloomfilter.BloomFilter;
import orestes.bloomfilter.FilterBuilder;
import orestes.bloomfilter.MigratableBloomFilter;
import orestes.bloomfilter.TimeMap;
import orestes.bloomfilter.cachesketch.ExpirationQueue;
import orestes.bloomfilter.cachesketch.ExpirationQueueMemory;
import orestes.bloomfilter.cachesketch.ExpiringBloomFilter;
import orestes.bloomfilter.memory.CountingBloomFilter32;

public class ExpiringBloomFilterMemory<T>
extends CountingBloomFilter32<T>
implements ExpiringBloomFilter<T>,
MigratableBloomFilter<T> {
    private final TimeMap<T> ttlMap = new TimeMap();
    private final ExpirationQueue<T> queue;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread thread = new Thread(r, "BloomFilterCleanupThreadPool");
        thread.setDaemon(true);
        return thread;
    });

    public ExpiringBloomFilterMemory(FilterBuilder config) {
        super(config);
        this.queue = new ExpirationQueueMemory(this::onExpire);
        long interval = config.cleanupInterval();
        this.scheduler.scheduleAtFixedRate(this::cleanupTTLs, interval, interval, TimeUnit.MILLISECONDS);
    }

    private void onExpire(ExpirationQueue.ExpiringItem<T> entry) {
        this.remove(entry.getItem());
    }

    @Override
    public void cleanupTTLs() {
        long now = this.ttlMap.now();
        for (T key : this.ttlMap.keySet()) {
            this.ttlMap.computeIfPresent(key, (k, v) -> {
                if (v + this.config.gracePeriod() > now) {
                    return v;
                }
                return null;
            });
        }
    }

    @Override
    public synchronized void reportRead(T element, long TTL, TimeUnit unit) {
        this.ttlMap.putRemaining(element, TTL, unit);
    }

    @Override
    public synchronized Long reportWrite(T element, TimeUnit unit) {
        Long expiration = this.ttlMap.get(element);
        if (expiration == null || expiration < this.ttlMap.now()) {
            return null;
        }
        this.add(element);
        this.queue.addExpiration(element, expiration, TimeUnit.MILLISECONDS);
        return unit.convert(expiration - this.ttlMap.now(), TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean isKnown(T element) {
        if (!this.ttlMap.containsKey(element)) {
            return false;
        }
        long ttl = this.ttlMap.get(element) - this.ttlMap.now() + this.config.gracePeriod();
        return ttl > 0L;
    }

    @Override
    public List<Boolean> isKnown(List<T> elements) {
        return elements.stream().map(this::isKnown).collect(Collectors.toList());
    }

    @Override
    public Double getEstimatedPopulation() {
        return this.ttlMap.size();
    }

    @Override
    public BloomFilter<T> getClonedBloomFilter() {
        return this.filter.clone();
    }

    @Override
    public void clear() {
        super.clear();
        this.queue.clear();
        this.ttlMap.clear();
    }

    @Override
    public void softClear() {
        super.clear();
        this.queue.clear();
    }

    @Override
    public void migrateFrom(BloomFilter<T> source) {
        if (!(source instanceof ExpiringBloomFilter) || !this.compatible(source)) {
            throw new MigratableBloomFilter.IncompatibleMigrationSourceException("Source is not compatible with the targeted Bloom filter");
        }
        super.migrateFrom(source);
        ExpiringBloomFilter ebfSource = (ExpiringBloomFilter)source;
        ebfSource.disableExpiration();
        this.setTimeToLiveMap(ebfSource.getTimeToLiveMap());
        this.setExpirationMap(ebfSource.getExpirationMap());
        ebfSource.enableExpiration();
    }

    @Override
    public boolean setExpirationEnabled(boolean enabled) {
        return this.queue.setEnabled(enabled);
    }

    @Override
    public TimeMap<T> getExpirationMap() {
        return this.queue.getExpirationMap();
    }

    @Override
    public void setExpirationMap(TimeMap<T> map) {
        this.queue.setExpirationMap(map);
    }

    @Override
    public TimeMap<T> getTimeToLiveMap() {
        return this.ttlMap;
    }

    @Override
    public void setTimeToLiveMap(TimeMap<T> map) {
        this.ttlMap.putAll(map);
    }
}

