/*
 * Decompiled with CFR 0.152.
 */
package orestes.bloomfilter.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.BitSet;
import orestes.bloomfilter.BloomFilter;
import orestes.bloomfilter.FilterBuilder;
import orestes.bloomfilter.HashProvider;
import orestes.bloomfilter.memory.BloomFilterMemory;

public class BloomFilterConverter {
    public static JsonElement toJson(BloomFilter<?> source) {
        JsonObject root = new JsonObject();
        root.addProperty("m", (Number)source.getSize());
        root.addProperty("h", (Number)source.getHashes());
        byte[] bits = source.getBitSet().toByteArray();
        root.addProperty("b", BloomFilterConverter.toBase64(bits));
        return root;
    }

    public static String toBase64(BloomFilter<?> source) {
        return BloomFilterConverter.toBase64(source.getBitSet().toByteArray());
    }

    private static String toBase64(byte[] bits) {
        return new String(Base64.getEncoder().encode(bits), StandardCharsets.UTF_8);
    }

    public static BloomFilter<String> fromJson(JsonElement source) {
        return BloomFilterConverter.fromJson(source, String.class);
    }

    public static <T> BloomFilter<T> fromJson(JsonElement source, Class<T> type) {
        JsonObject root = source.getAsJsonObject();
        int m = root.get("m").getAsInt();
        int k = root.get("h").getAsInt();
        byte[] bits = Base64.getDecoder().decode(root.get("b").getAsString());
        FilterBuilder builder = new FilterBuilder(m, k).hashFunction(HashProvider.HashMethod.Murmur3KirschMitzenmacher);
        BloomFilterMemory filter = new BloomFilterMemory(builder.complete());
        filter.setBitSet(BitSet.valueOf(bits));
        return filter;
    }
}

