/*
 * Decompiled with CFR 0.152.
 */
package orestes.bloomfilter.memory;

import java.util.BitSet;
import orestes.bloomfilter.BloomFilter;
import orestes.bloomfilter.FilterBuilder;

public class BloomFilterMemory<T>
implements BloomFilter<T> {
    private static final long serialVersionUID = -5962895807963838856L;
    private final FilterBuilder config;
    protected BitSet bloom;

    public BloomFilterMemory(FilterBuilder config) {
        config.complete();
        this.bloom = new BitSet(config.size());
        this.config = config;
    }

    @Override
    public FilterBuilder config() {
        return this.config;
    }

    @Override
    public synchronized boolean addRaw(byte[] element) {
        boolean added = false;
        for (int position : this.hash(element)) {
            if (this.getBit(position)) continue;
            added = true;
            this.setBit(position, true);
        }
        return added;
    }

    @Override
    public synchronized void clear() {
        this.bloom.clear();
    }

    @Override
    public synchronized boolean contains(byte[] element) {
        for (int position : this.hash(element)) {
            if (this.getBit(position)) continue;
            return false;
        }
        return true;
    }

    protected boolean getBit(int index) {
        return this.bloom.get(index);
    }

    protected void setBit(int index, boolean to) {
        this.bloom.set(index, to);
    }

    @Override
    public synchronized BitSet getBitSet() {
        return (BitSet)this.bloom.clone();
    }

    @Override
    public synchronized boolean union(BloomFilter<T> other) {
        if (this.compatible(other)) {
            this.bloom.or(other.getBitSet());
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean intersect(BloomFilter<T> other) {
        if (this.compatible(other)) {
            this.bloom.and(other.getBitSet());
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.bloom.isEmpty();
    }

    @Override
    public synchronized BloomFilter<T> clone() {
        BloomFilterMemory o = null;
        try {
            o = (BloomFilterMemory)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        o.bloom = (BitSet)this.bloom.clone();
        return o;
    }

    public synchronized String toString() {
        return this.asString();
    }

    public synchronized void setBitSet(BitSet bloom) {
        this.bloom = bloom;
    }

    public synchronized boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BloomFilterMemory)) {
            return false;
        }
        BloomFilterMemory that = (BloomFilterMemory)o;
        if (this.bloom != null ? !this.bloom.equals(that.bloom) : that.bloom != null) {
            return false;
        }
        return !(this.config != null ? !this.config.isCompatibleTo(that.config) : that.config != null);
    }
}

