/*
 * Decompiled with CFR 0.152.
 */
package orestes.bloomfilter.memory;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import orestes.bloomfilter.FilterBuilder;
import orestes.bloomfilter.memory.BloomFilterMemory;
import orestes.bloomfilter.memory.CountingBloomFilterMemory;

public class CountingBloomFilter32<T>
extends CountingBloomFilterMemory<T> {
    private int[] counters;
    private static final long MAX = 0xFFFFFFFFL;

    public CountingBloomFilter32(FilterBuilder config) {
        config.countingBits(32).complete();
        this.config = config;
        this.filter = new BloomFilterMemory(config.clone());
        this.counters = new int[config.size()];
    }

    @Override
    protected long increment(int index) {
        if (Integer.toUnsignedLong(this.counters[index]) == 0xFFFFFFFFL) {
            this.overflowHandler.run();
            return 0xFFFFFFFFL;
        }
        int n = index;
        int n2 = this.counters[n] + 1;
        this.counters[n] = n2;
        return Integer.toUnsignedLong(n2);
    }

    @Override
    protected long decrement(int index) {
        if (this.counters[index] == 0) {
            return 0L;
        }
        int n = index;
        int n2 = this.counters[n] - 1;
        this.counters[n] = n2;
        return Integer.toUnsignedLong(n2);
    }

    @Override
    protected long count(int index) {
        return Integer.toUnsignedLong(this.counters[index]);
    }

    @Override
    protected void set(int index, long newValue) {
        this.counters[index] = (int)newValue;
    }

    @Override
    public Map<Integer, Long> getCountMap() {
        HashMap<Integer, Long> result = new HashMap<Integer, Long>();
        for (int i = 0; i < this.counters.length; ++i) {
            long count = Integer.toUnsignedLong(this.counters[i]);
            if (count <= 0L) continue;
            result.put(i, count);
        }
        return result;
    }

    @Override
    public void clear() {
        this.filter.clear();
        this.counters = new int[this.counters.length];
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CountingBloomFilter32)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CountingBloomFilter32 that = (CountingBloomFilter32)o;
        return Objects.equals(this.counters, that.counters);
    }
}

