/*
 * Decompiled with CFR 0.152.
 */
package orestes.bloomfilter.memory;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import orestes.bloomfilter.FilterBuilder;
import orestes.bloomfilter.memory.BloomFilterMemory;
import orestes.bloomfilter.memory.CountingBloomFilterMemory;

public class CountingBloomFilter8<T>
extends CountingBloomFilterMemory<T> {
    private byte[] counters;
    private static final long MAX = 255L;

    public CountingBloomFilter8(FilterBuilder config) {
        config.countingBits(8).complete();
        this.config = config;
        this.filter = new BloomFilterMemory(config.clone());
        this.counters = new byte[config.size()];
    }

    @Override
    protected long increment(int index) {
        if (Byte.toUnsignedLong(this.counters[index]) == 255L) {
            this.overflowHandler.run();
            return 255L;
        }
        int n = index;
        byte by = (byte)(this.counters[n] + 1);
        this.counters[n] = by;
        return Byte.toUnsignedLong(by);
    }

    @Override
    protected long decrement(int index) {
        if (this.counters[index] == 0) {
            return 0L;
        }
        int n = index;
        byte by = (byte)(this.counters[n] - 1);
        this.counters[n] = by;
        return Byte.toUnsignedLong(by);
    }

    @Override
    protected long count(int index) {
        return Byte.toUnsignedLong(this.counters[index]);
    }

    @Override
    protected void set(int index, long newValue) {
        this.counters[index] = (byte)(newValue & 0xFFL);
    }

    @Override
    public Map<Integer, Long> getCountMap() {
        HashMap<Integer, Long> result = new HashMap<Integer, Long>();
        for (int i = 0; i < this.counters.length; ++i) {
            long count = Byte.toUnsignedLong(this.counters[i]);
            if (count <= 0L) continue;
            result.put(i, count);
        }
        return result;
    }

    @Override
    public void clear() {
        this.filter.clear();
        this.counters = new byte[this.counters.length];
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CountingBloomFilter8)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CountingBloomFilter8 that = (CountingBloomFilter8)o;
        return Objects.equals(this.counters, that.counters);
    }
}

