/*
 * Decompiled with CFR 0.152.
 */
package orestes.bloomfilter.memory;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import orestes.bloomfilter.BloomFilter;
import orestes.bloomfilter.CountingBloomFilter;
import orestes.bloomfilter.FilterBuilder;
import orestes.bloomfilter.MigratableBloomFilter;
import orestes.bloomfilter.memory.BloomFilterMemory;

public class CountingBloomFilterMemory<T>
implements CountingBloomFilter<T>,
MigratableBloomFilter<T> {
    private static final long serialVersionUID = -3207752201903871264L;
    protected FilterBuilder config;
    protected BloomFilterMemory<T> filter;
    protected BitSet counts;
    protected transient Runnable overflowHandler;

    protected CountingBloomFilterMemory() {
        this.overflowHandler = () -> {};
    }

    public CountingBloomFilterMemory(FilterBuilder config) {
        this.overflowHandler = () -> {};
        config.complete();
        this.config = config;
        this.filter = new BloomFilterMemory(config.clone());
        this.counts = new BitSet(config.size() * this.config().countingBits());
    }

    @Override
    public boolean contains(byte[] element) {
        return this.filter.contains(element);
    }

    @Override
    public Map<Integer, Long> getCountMap() {
        HashMap<Integer, Long> result = new HashMap<Integer, Long>();
        int i = 0;
        int low = 0;
        int high = low + this.config().countingBits();
        while (low < this.counts.length()) {
            long count = 0L;
            for (int j = low; j < high; ++j) {
                count <<= 1;
                if (!this.counts.get(j)) continue;
                count |= 1L;
            }
            if (count > 0L) {
                result.put(i, count);
            }
            ++i;
            low += this.config.countingBits();
            high += this.config.countingBits();
        }
        return result;
    }

    @Override
    public synchronized long addAndEstimateCountRaw(byte[] element) {
        return IntStream.of(this.hash(element)).mapToLong(hash -> {
            this.filter.setBit(hash, true);
            return this.increment(hash);
        }).min().getAsLong();
    }

    @Override
    public synchronized long removeAndEstimateCountRaw(byte[] element) {
        if (!this.contains(element)) {
            return 0L;
        }
        return IntStream.of(this.hash(element)).mapToLong(hash -> {
            long count = this.decrement(hash);
            this.filter.setBit(hash, count > 0L);
            return count;
        }).min().getAsLong();
    }

    protected long increment(int index) {
        int i;
        int low = index * this.config().countingBits();
        int high = (index + 1) * this.config().countingBits();
        boolean incremented = false;
        long count = 0L;
        int pos = 0;
        for (i = high - 1; i >= low; --i) {
            if (!this.counts.get(i) && !incremented) {
                this.counts.set(i);
                incremented = true;
            } else if (!incremented) {
                this.counts.set(i, false);
            }
            if (this.counts.get(i)) {
                count = (long)((double)count + Math.pow(2.0, pos));
            }
            ++pos;
        }
        if (!incremented) {
            this.overflowHandler.run();
            for (i = high - 1; i >= low; --i) {
                this.counts.set(i);
            }
            count = (long)Math.pow(2.0, this.config().countingBits() - 1);
        }
        return count;
    }

    protected long count(int index) {
        int low = index * this.config().countingBits();
        int high = low + this.config().countingBits();
        long count = 0L;
        for (int i = low; i < high; ++i) {
            count <<= 1;
            if (!this.counts.get(i)) continue;
            count |= 1L;
        }
        return count;
    }

    protected void set(int index, long newValue) {
        int high;
        int low = index * this.config().countingBits();
        for (int i = high = low + this.config().countingBits() - 1; i >= low; --i) {
            this.counts.set(i, (newValue & 1L) > 0L);
            newValue >>>= 1;
        }
    }

    protected long decrement(int index) {
        int low = index * this.config().countingBits();
        int high = (index + 1) * this.config().countingBits();
        boolean decremented = false;
        boolean nonZero = false;
        long count = 0L;
        int pos = 0;
        for (int i = high - 1; i >= low; --i) {
            if (!decremented) {
                if (this.counts.get(i)) {
                    this.counts.set(i, false);
                    decremented = true;
                } else {
                    this.counts.set(i, true);
                    nonZero = true;
                }
            } else if (this.counts.get(i)) {
                nonZero = true;
            }
            if (this.counts.get(i)) {
                count = (long)((double)count + Math.pow(2.0, pos));
            }
            ++pos;
        }
        return count;
    }

    @Override
    public synchronized long getEstimatedCount(T element) {
        return IntStream.of(this.hash(this.toBytes(element))).mapToLong(this::count).min().getAsLong();
    }

    @Override
    public boolean union(BloomFilter<T> other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean intersect(BloomFilter<T> other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.filter.isEmpty();
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder(this.asString() + "\n");
        for (int i = 0; i < this.config().size(); ++i) {
            sb.append(this.filter.getBit(i) ? 1 : 0);
            sb.append(" ");
            if (this.counts != null) {
                for (int j = 0; j < this.config().countingBits(); ++j) {
                    sb.append(this.counts.get(this.config().countingBits() * i + j) ? 1 : 0);
                }
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public synchronized CountingBloomFilterMemory<T> clone() {
        CountingBloomFilterMemory o = null;
        try {
            o = (CountingBloomFilterMemory)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        o.filter = (BloomFilterMemory)this.filter.clone();
        if (this.counts != null) {
            o.counts = (BitSet)this.counts.clone();
        }
        o.config = this.config.clone();
        return o;
    }

    @Override
    public void clear() {
        this.filter.clear();
        this.counts.clear();
    }

    @Override
    public BitSet getBitSet() {
        return this.filter.getBitSet();
    }

    @Override
    public FilterBuilder config() {
        return this.config;
    }

    public synchronized boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CountingBloomFilterMemory)) {
            return false;
        }
        CountingBloomFilterMemory that = (CountingBloomFilterMemory)o;
        if (this.config != null ? !this.config.isCompatibleTo(that.config) : that.config != null) {
            return false;
        }
        if (this.counts != null ? !this.counts.equals(that.counts) : that.counts != null) {
            return false;
        }
        return !(this.filter != null ? !this.filter.equals(that.filter) : that.filter != null);
    }

    public void setOverflowHandler(Runnable callback) {
        this.overflowHandler = callback;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.overflowHandler = () -> {};
    }

    public BloomFilterMemory<T> getBloomFilter() {
        return this.filter;
    }

    @Override
    public void migrateFrom(BloomFilter<T> source) {
        if (!(source instanceof CountingBloomFilter) || !this.compatible(source)) {
            throw new MigratableBloomFilter.IncompatibleMigrationSourceException("Source is not compatible with the targeted Bloom filter");
        }
        CountingBloomFilter cbf = (CountingBloomFilter)source;
        cbf.getCountMap().forEach((position, value) -> {
            this.set((int)position, (long)value);
            this.filter.setBit((int)position, value > 0L);
        });
    }
}

