/*
 * Decompiled with CFR 0.152.
 */
package orestes.bloomfilter.redis;

import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import orestes.bloomfilter.BloomFilter;
import orestes.bloomfilter.CountingBloomFilter;
import orestes.bloomfilter.FilterBuilder;
import orestes.bloomfilter.MigratableBloomFilter;
import orestes.bloomfilter.memory.CountingBloomFilterMemory;
import orestes.bloomfilter.redis.RedisBitSet;
import orestes.bloomfilter.redis.RedisUtils;
import orestes.bloomfilter.redis.helper.RedisKeys;
import orestes.bloomfilter.redis.helper.RedisPool;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.PipelineBase;
import redis.clients.jedis.Transaction;

public class CountingBloomFilterRedis<T>
implements CountingBloomFilter<T>,
MigratableBloomFilter<T> {
    protected final RedisKeys keys;
    protected final RedisPool pool;
    protected final RedisBitSet bloom;
    protected final FilterBuilder config;

    public CountingBloomFilterRedis(FilterBuilder builder) {
        FilterBuilder updateBuilder = builder.clone();
        builder.complete();
        this.keys = new RedisKeys(builder.name());
        this.pool = builder.pool();
        this.bloom = new RedisBitSet(this.pool, this.keys.BITS_KEY, builder.size());
        this.config = this.keys.persistConfig(this.pool, updateBuilder);
        if (builder.overwriteIfExists()) {
            this.clear();
        }
    }

    @Override
    public Map<Integer, Long> getCountMap() {
        try (Jedis r = this.pool.allowingSlaves().getResource();){
            Map<Integer, Long> map = RedisUtils.decodeMap(r.hgetAll(this.keys.COUNTS_KEY.getBytes()));
            return map;
        }
    }

    @Override
    public long addAndEstimateCountRaw(byte[] element) {
        List results = this.pool.transactionallyRetry(p -> {
            int[] hashes;
            for (int position : hashes = this.hash(element)) {
                this.bloom.set((PipelineBase)p, position, true);
            }
            for (int position : hashes) {
                p.hincrBy(this.keys.COUNTS_KEY.getBytes(), RedisUtils.encodeKey(position), 1L);
            }
        }, this.keys.BITS_KEY, this.keys.COUNTS_KEY);
        return results.stream().skip(this.config().hashes()).mapToLong(i -> (Long)i).min().orElse(0L);
    }

    @Override
    public List<Boolean> addAll(Collection<T> elements) {
        return this.addAndEstimateCountRaw(elements).stream().map(el -> el == 1L).collect(Collectors.toList());
    }

    private List<Long> addAndEstimateCountRaw(Collection<T> elements) {
        List allHashes = elements.stream().map(el -> this.hash(this.toBytes(el))).collect(Collectors.toList());
        List results = this.pool.transactionallyRetry(p -> {
            int[] hashes;
            Iterator iterator = allHashes.iterator();
            while (iterator.hasNext()) {
                for (int position : hashes = (int[])iterator.next()) {
                    this.bloom.set((PipelineBase)p, position, true);
                }
            }
            iterator = allHashes.iterator();
            while (iterator.hasNext()) {
                for (int position : hashes = (int[])iterator.next()) {
                    p.hincrBy(this.keys.COUNTS_KEY.getBytes(), RedisUtils.encodeKey(position), 1L);
                }
            }
        }, this.keys.BITS_KEY, this.keys.COUNTS_KEY);
        LinkedList<Long> mins = new LinkedList<Long>();
        for (int i = results.size() / 2; i < results.size(); i += this.config().hashes()) {
            long min = results.subList(i, i + this.config().hashes()).stream().map(val -> (Long)val).min(Comparator.naturalOrder()).get();
            mins.add(min);
        }
        return mins;
    }

    @Override
    public boolean removeRaw(byte[] value) {
        return this.removeAndEstimateCountRaw(value) <= 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long removeAndEstimateCountRaw(byte[] value) {
        try (Jedis jedis = this.pool.getResource();){
            while (true) {
                jedis.watch(new String[]{this.keys.COUNTS_KEY});
                int[] positions = this.hash(value);
                Map<Integer, Long> posToCountMap = this.getCounts(jedis, positions);
                HashMap<Integer, Integer> countMap = new HashMap<Integer, Integer>(positions.length);
                for (int position2 : positions) {
                    countMap.compute(position2, (k, v) -> v == null ? 1 : v + 1);
                }
                posToCountMap.replaceAll((position, count) -> count - (long)((Integer)countMap.get(position)).intValue());
                Transaction tx = jedis.multi();
                this.setCounts((PipelineBase)tx, posToCountMap);
                this.updateBinaryBloomFilter((PipelineBase)tx, posToCountMap);
                boolean hasFailed = tx.exec().isEmpty();
                if (!hasFailed) {
                    long l = posToCountMap.values().stream().mapToLong(Long::valueOf).min().getAsLong();
                    return l;
                }
                continue;
                break;
            }
        }
    }

    @Override
    public long getEstimatedCount(T element) {
        try (Jedis jedis = this.pool.allowingSlaves().getResource();){
            byte[][] hashesString = RedisUtils.encodeKey(this.hash(this.toBytes(element)));
            List hmget = jedis.hmget(this.keys.COUNTS_KEY.getBytes(), hashesString);
            long l = hmget.stream().mapToLong(i -> i == null ? 0L : RedisUtils.decodeValue(i)).min().orElse(0L);
            return l;
        }
    }

    @Override
    public void clear() {
        try (Jedis jedis = this.pool.getResource();){
            jedis.del(new String[]{this.keys.COUNTS_KEY, this.keys.BITS_KEY});
        }
    }

    @Override
    public void remove() {
        this.clear();
        try (Jedis jedis = this.pool.getResource();){
            jedis.del(this.config().name());
        }
        this.pool.destroy();
    }

    @Override
    public boolean contains(byte[] element) {
        return this.bloom.isAllSet(this.hash(element));
    }

    public RedisBitSet getRedisBitSet() {
        return this.bloom;
    }

    @Override
    public BitSet getBitSet() {
        return this.bloom.asBitSet();
    }

    public byte[] getBytes() {
        return this.bloom.toByteArray();
    }

    @Override
    public FilterBuilder config() {
        return this.config;
    }

    public CountingBloomFilterMemory<T> toMemoryFilter() {
        CountingBloomFilterMemory filter = new CountingBloomFilterMemory(this.config().clone());
        filter.getBloomFilter().setBitSet(this.getBitSet());
        return filter;
    }

    @Override
    public CountingBloomFilter<T> clone() {
        return new CountingBloomFilterRedis<T>(this.config().clone());
    }

    @Override
    public boolean union(BloomFilter<T> other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean intersect(BloomFilter<T> other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.bloom.isEmpty();
    }

    @Override
    public Double getEstimatedPopulation() {
        return BloomFilter.population(this.bloom, this.config());
    }

    public RedisPool getRedisPool() {
        return this.pool;
    }

    public RedisKeys getRedisKeys() {
        return this.keys;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CountingBloomFilterRedis)) {
            return false;
        }
        CountingBloomFilterRedis that = (CountingBloomFilterRedis)o;
        if (this.bloom != null ? !this.bloom.equals(that.bloom) : that.bloom != null) {
            return false;
        }
        return !(this.config != null ? !this.config.isCompatibleTo(that.config) : that.config != null);
    }

    @Override
    public void migrateFrom(BloomFilter<T> source) {
        if (!(source instanceof CountingBloomFilter) || !this.compatible(source)) {
            throw new MigratableBloomFilter.IncompatibleMigrationSourceException("Source is not compatible with the targeted Bloom filter");
        }
        CountingBloomFilter cbf = (CountingBloomFilter)source;
        Map<Integer, Long> countSetToMigrate = cbf.getCountMap();
        this.pool.transactionallyRetry(p -> countSetToMigrate.forEach((position, value) -> this.set((int)position, (long)value, (Pipeline)p)), this.keys.BITS_KEY, this.keys.COUNTS_KEY);
    }

    private Map<Integer, Long> getCounts(Jedis jedis, int ... positions) {
        byte[][] keysToDec = RedisUtils.encodeKey(positions);
        List values = jedis.hmget(this.keys.COUNTS_KEY.getBytes(), keysToDec);
        return IntStream.range(0, positions.length).collect(HashMap::new, (m, i) -> m.put(positions[i], values.get(i) == null ? 0L : RedisUtils.decodeValue((byte[])values.get(i))), Map::putAll);
    }

    private void setCounts(PipelineBase p, Map<Integer, Long> counts) {
        p.hmset(this.keys.COUNTS_KEY.getBytes(), RedisUtils.encodeMap(counts));
    }

    private void updateBinaryBloomFilter(PipelineBase p, Map<Integer, Long> counts) {
        counts.forEach((position, count) -> this.bloom.set(p, (int)position, count > 0L));
    }

    private void set(int position, long value, Pipeline p) {
        this.bloom.set((PipelineBase)p, position, value > 0L);
        p.hset(this.keys.COUNTS_KEY.getBytes(), RedisUtils.encodeKey(position), RedisUtils.encodeValue(value));
    }
}

