/*
 * Decompiled with CFR 0.152.
 */
package orestes.bloomfilter.redis;

import java.util.BitSet;
import java.util.List;
import java.util.stream.Stream;
import orestes.bloomfilter.redis.helper.RedisPool;
import redis.clients.jedis.PipelineBase;
import redis.clients.util.SafeEncoder;

public class RedisBitSet
extends BitSet {
    private final RedisPool pool;
    private String name;
    private int size;

    public RedisBitSet(RedisPool pool, String name, int size) {
        this.pool = pool;
        this.name = name;
        this.size = size;
    }

    @Override
    public boolean get(int bitIndex) {
        return this.pool.allowingSlaves().safelyReturn(jedis -> jedis.getbit(this.name, (long)bitIndex));
    }

    public Boolean[] getBulk(int ... indexes) {
        List<Boolean> results = this.pool.allowingSlaves().transactionallyDo(p -> {
            for (int index : indexes) {
                this.get((PipelineBase)p, index);
            }
        }, new String[0]);
        return results.toArray(new Boolean[indexes.length]);
    }

    @Override
    public void set(int bitIndex, boolean value) {
        this.pool.safelyDo(jedis -> jedis.setbit(this.name, (long)bitIndex, value));
    }

    public void get(PipelineBase p, int position) {
        p.getbit(this.name, (long)position);
    }

    public void set(PipelineBase p, int bitIndex, boolean value) {
        p.setbit(this.name, (long)bitIndex, value);
    }

    @Override
    public void set(int bitIndex) {
        this.set(bitIndex, true);
    }

    @Override
    public void clear(int bitIndex) {
        this.set(bitIndex, false);
    }

    public void clear(PipelineBase p, int bitIndex) {
        this.set(p, bitIndex, false);
    }

    @Override
    public void clear() {
        this.pool.safelyDo(jedis -> jedis.del(this.name));
    }

    @Override
    public int cardinality() {
        return this.pool.safelyReturn(jedis -> jedis.bitcount(this.name)).intValue();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public byte[] toByteArray() {
        return this.pool.allowingSlaves().safelyReturn(jedis -> {
            byte[] bytes = jedis.get(SafeEncoder.encode((String)this.name));
            if (bytes == null) {
                bytes = new byte[(int)Math.ceil(this.size / 8)];
            }
            return bytes;
        });
    }

    @Override
    public boolean isEmpty() {
        return this.pool.safelyReturn(jedis -> jedis.bitcount(this.name) == 0L);
    }

    @Override
    public int length() {
        return this.pool.safelyReturn(jedis -> {
            int byteCount = jedis.strlen(this.name).intValue();
            if (byteCount == 0) {
                return 0;
            }
            byte lastByte = jedis.getrange(this.name.getBytes(), (long)(byteCount - 1), (long)byteCount)[0];
            int i = 8;
            while ((lastByte & 1) == 0) {
                --i;
                lastByte = (byte)(lastByte >>> 1);
            }
            return 8 * byteCount - 8 + i;
        });
    }

    public BitSet asBitSet() {
        return RedisBitSet.fromByteArrayReverse(this.toByteArray());
    }

    public void overwriteBitSet(BitSet bits) {
        this.pool.safelyDo(jedis -> jedis.set(SafeEncoder.encode((String)this.name), RedisBitSet.toByteArrayReverse(bits)));
    }

    @Override
    public String toString() {
        return this.asBitSet().toString();
    }

    public String getRedisKey() {
        return this.name;
    }

    public boolean isAllSet(int ... positions) {
        Boolean[] results = this.getBulk(positions);
        return Stream.of(results).allMatch(b -> b);
    }

    public boolean setAll(int ... positions) {
        List results = this.pool.transactionallyDo(p -> {
            for (int position : positions) {
                p.setbit(this.name, (long)position, true);
            }
        }, new String[0]);
        return results.stream().anyMatch(b -> (Boolean)b == false);
    }

    public static BitSet fromByteArrayReverse(byte[] bytes) {
        BitSet bits = new BitSet();
        for (int i = 0; i < bytes.length * 8; ++i) {
            if ((bytes[i / 8] & 1 << 7 - i % 8) == 0) continue;
            bits.set(i);
        }
        return bits;
    }

    public static byte[] toByteArrayReverse(BitSet bits) {
        byte[] bytes = new byte[(bits.length() + 7) / 8];
        for (int i = 0; i < bits.length(); ++i) {
            if (!bits.get(i)) continue;
            int value = bytes[i / 8] | 1 << 7 - i % 8;
            bytes[i / 8] = (byte)value;
        }
        return bytes;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof RedisBitSet) {
            obj = ((RedisBitSet)obj).asBitSet();
        }
        return this.asBitSet().equals(obj);
    }
}

