/*
 * Decompiled with CFR 0.152.
 */
package orestes.bloomfilter.redis;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class RedisUtils {
    private RedisUtils() {
    }

    public static Map<byte[], byte[]> encodeMap(Map<Integer, Long> map) {
        return map.entrySet().stream().collect(Collectors.toMap(e -> RedisUtils.encodeKey((Integer)e.getKey()), e -> RedisUtils.encodeValue((Long)e.getValue())));
    }

    public static byte[] encodeKey(int key) {
        return ByteBuffer.allocate(4).putInt(key).array();
    }

    public static byte[][] encodeKey(int[] keys) {
        return (byte[][])IntStream.of(keys).mapToObj(RedisUtils::encodeKey).toArray(x$0 -> new byte[x$0][]);
    }

    public static byte[] encodeValue(long value) {
        return String.valueOf(value).getBytes();
    }

    public static Map<Integer, Long> decodeMap(Map<byte[], byte[]> map) {
        return map.entrySet().stream().collect(Collectors.toMap(e -> RedisUtils.decodeKey((byte[])e.getKey()), e -> RedisUtils.decodeValue((byte[])e.getValue())));
    }

    public static int decodeKey(byte[] key) {
        return ByteBuffer.wrap(key).getInt();
    }

    public static long decodeValue(byte[] value) {
        return Long.parseLong(new String(value));
    }
}

