/*
 * Decompiled with CFR 0.152.
 */
package orestes.bloomfilter.redis.helper;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import orestes.bloomfilter.redis.helper.RedisSentinelPoolBuilder;
import orestes.bloomfilter.redis.helper.RedisStandalonePoolBuilder;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;
import redis.clients.util.Pool;
import selogger.org.slf4j.Logger;
import selogger.org.slf4j.LoggerFactory;

public class RedisPool {
    private static final Logger LOG = LoggerFactory.getLogger(RedisPool.class);
    private final Pool<Jedis> pool;
    private final List<RedisPool> slavePools;
    private final Random random;
    private final String host;
    private final int port;

    public static final RedisStandalonePoolBuilder builder() {
        return new RedisStandalonePoolBuilder();
    }

    public static final RedisSentinelPoolBuilder sentinelBuilder() {
        return new RedisSentinelPoolBuilder();
    }

    protected RedisPool(Pool<Jedis> pool, List<RedisPool> slavePools, String host, int port) {
        this.pool = pool;
        this.host = host;
        this.port = port;
        if (slavePools != null && !slavePools.isEmpty()) {
            this.slavePools = slavePools;
            this.random = new Random();
        } else {
            this.slavePools = slavePools;
            this.random = null;
        }
    }

    public Pool<Jedis> getInternalPool() {
        return this.pool;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public RedisPool allowingSlaves() {
        if (this.slavePools == null) {
            return this;
        }
        int index = this.random.nextInt(this.slavePools.size());
        return this.slavePools.get(index);
    }

    public Jedis getResource() {
        return (Jedis)this.pool.getResource();
    }

    public void safelyDo(Consumer<Jedis> f) {
        this.safelyReturn(jedis -> {
            f.accept((Jedis)jedis);
            return null;
        });
    }

    public <T> T safelyReturn(Function<Jedis, T> f) {
        try (Jedis jedis = (Jedis)this.pool.getResource();){
            T t = f.apply(jedis);
            return t;
        }
    }

    public <T> void safeForEach(Collection<T> collection, BiConsumer<Pipeline, T> f) {
        this.safelyReturn(jedis -> {
            Pipeline p = jedis.pipelined();
            collection.stream().forEach(e -> f.accept(p, e));
            p.sync();
            return null;
        });
    }

    public <T> List<T> transactionallyDo(Consumer<Pipeline> f, String ... watch) {
        return this.safelyReturn(jedis -> {
            Pipeline p = jedis.pipelined();
            if (watch.length != 0) {
                p.watch(watch);
            }
            p.multi();
            f.accept(p);
            Response exec = p.exec();
            p.sync();
            return (List)exec.get();
        });
    }

    public <T> List<T> transactionallyRetry(Consumer<Pipeline> f, String ... watch) {
        List<T> result;
        while ((result = this.transactionallyDo(f, watch)) == null) {
        }
        return result;
    }

    public Clock getClock() {
        List time = this.safelyReturn(BinaryJedis::time);
        Instant local = Instant.now();
        Instant redis = Instant.ofEpochSecond(Long.valueOf((String)time.get(0)), Long.valueOf((String)time.get(1)) * 1000L);
        return Clock.offset(Clock.systemDefaultZone(), Duration.between(local, redis));
    }

    public static Thread startThread(String redisHost, int redisPort, Consumer<Jedis> whenConnected, Function<Exception, Boolean> abort) {
        Thread thread = new Thread(() -> {
            boolean connected = false;
            while (!connected && !Thread.currentThread().isInterrupted()) {
                try {
                    Jedis jedis = new Jedis(redisHost, redisPort);
                    Throwable throwable = null;
                    try {
                        jedis.ping();
                        connected = true;
                        LOG.info("PubSub Redis connection established.");
                        whenConnected.accept(jedis);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (jedis == null) continue;
                        if (throwable != null) {
                            try {
                                jedis.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        jedis.close();
                    }
                }
                catch (Exception e) {
                    connected = false;
                    if (((Boolean)abort.apply(e)).booleanValue()) {
                        LOG.info("PubSub Redis connection aborted.", e);
                        break;
                    }
                    LOG.warn("PubSub Redis connection failed with an exception:", e);
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException e1) {
                        LOG.warn("PubSub Redis connection Interrupted", e1);
                    }
                }
            }
            LOG.info("PubSub Redis connection closed.");
        });
        thread.start();
        return thread;
    }

    public Thread startThread(Consumer<Jedis> whenConnected) {
        return this.startThread(whenConnected, ex -> false);
    }

    public Thread startThread(Consumer<Jedis> whenConnected, Function<Exception, Boolean> abort) {
        return RedisPool.startThread(this.host, this.port, whenConnected, abort);
    }

    public void destroy() {
        this.pool.destroy();
    }
}

