/*
 * Decompiled with CFR 0.152.
 */
package orestes.bloomfilter.redis.helper;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import orestes.bloomfilter.redis.helper.RedisBasePoolBuilder;
import orestes.bloomfilter.redis.helper.RedisPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.util.Pool;

public class RedisStandalonePoolBuilder
extends RedisBasePoolBuilder<RedisStandalonePoolBuilder> {
    private Set<Map.Entry<String, Integer>> readSlaves = null;
    private boolean ssl = false;

    public RedisStandalonePoolBuilder readSlaves(Set<Map.Entry<String, Integer>> readSlaves) {
        this.readSlaves = readSlaves;
        return this;
    }

    public RedisStandalonePoolBuilder ssl(boolean ssl) {
        this.ssl = ssl;
        return this;
    }

    public RedisPool build() {
        ArrayList<RedisPool> slavePools = null;
        if (this.readSlaves != null && !this.readSlaves.isEmpty()) {
            slavePools = new ArrayList<RedisPool>();
            for (Map.Entry<String, Integer> slave : this.readSlaves) {
                String host = slave.getKey();
                Integer port = slave.getValue();
                slavePools.add(new RedisPool((Pool<Jedis>)this.createJedisPool(host, port), null, host, port));
            }
        }
        JedisPool pool = this.createJedisPool(this.host, this.port);
        return new RedisPool((Pool<Jedis>)pool, slavePools, this.host, this.port);
    }

    protected JedisPool createJedisPool(String host, int port) {
        return new JedisPool((GenericObjectPoolConfig)this.getPoolConfig(this.redisConnections), host, port, this.timeout, this.password, this.database, this.ssl);
    }
}

