/*
 * Decompiled with CFR 0.152.
 */
package selogger.com.fasterxml.jackson.module.blackbird.ser;

import java.util.function.Function;
import selogger.com.fasterxml.jackson.core.JsonGenerator;
import selogger.com.fasterxml.jackson.databind.JsonSerializer;
import selogger.com.fasterxml.jackson.databind.PropertyName;
import selogger.com.fasterxml.jackson.databind.SerializerProvider;
import selogger.com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import selogger.com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import selogger.com.fasterxml.jackson.module.blackbird.ser.OptimizedBeanPropertyWriter;

final class ObjectPropertyWriter
extends OptimizedBeanPropertyWriter<ObjectPropertyWriter> {
    private static final long serialVersionUID = 1L;
    private final Function<Object, Object> _acc;

    public ObjectPropertyWriter(BeanPropertyWriter src, Function<Object, Object> acc, JsonSerializer<Object> ser) {
        super(src, ser);
        this._acc = acc;
    }

    protected ObjectPropertyWriter(ObjectPropertyWriter base, PropertyName name) {
        super(base, name);
        this._acc = base._acc;
    }

    @Override
    protected BeanPropertyWriter _new(PropertyName newName) {
        return new ObjectPropertyWriter(this, newName);
    }

    @Override
    public BeanPropertyWriter withSerializer(JsonSerializer<Object> ser) {
        return new ObjectPropertyWriter(this, this._acc, ser);
    }

    @Override
    public final void serializeAsField(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        Class<?> cls;
        PropertySerializerMap map;
        Object value;
        if (this.broken) {
            this.fallbackWriter.serializeAsField(bean, gen, prov);
            return;
        }
        try {
            value = this._acc.apply(bean);
        }
        catch (Throwable t) {
            this._handleProblem(bean, gen, prov, t, false);
            return;
        }
        if (value == null) {
            if (this._nullSerializer != null) {
                gen.writeFieldName(this._fastName);
                this._nullSerializer.serialize(null, gen, prov);
            } else if (!this._suppressNulls) {
                gen.writeFieldName(this._fastName);
                prov.defaultSerializeNull(gen);
            }
            return;
        }
        JsonSerializer<Object> ser = this._serializer;
        if (ser == null && (ser = (map = this._dynamicSerializers).serializerFor(cls = value.getClass())) == null) {
            ser = this._findAndAddDynamic(map, cls, prov);
        }
        if (this._suppressableValue != null && (MARKER_FOR_EMPTY == this._suppressableValue ? ser.isEmpty(prov, value) : this._suppressableValue.equals(value))) {
            return;
        }
        if (value == bean && this._handleSelfReference(bean, gen, prov, ser)) {
            return;
        }
        gen.writeFieldName(this._fastName);
        if (this._typeSerializer == null) {
            ser.serialize(value, gen, prov);
        } else {
            ser.serializeWithType(value, gen, prov, this._typeSerializer);
        }
    }

    @Override
    public final void serializeAsElement(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        Class<?> cls;
        PropertySerializerMap map;
        Object value;
        if (this.broken) {
            this.fallbackWriter.serializeAsElement(bean, gen, prov);
            return;
        }
        try {
            value = this._acc.apply(bean);
        }
        catch (Throwable t) {
            this._handleProblem(bean, gen, prov, t, true);
            return;
        }
        if (value == null) {
            if (this._nullSerializer != null) {
                this._nullSerializer.serialize(null, gen, prov);
            } else if (this._suppressNulls) {
                this.serializeAsPlaceholder(bean, gen, prov);
            } else {
                prov.defaultSerializeNull(gen);
            }
            return;
        }
        JsonSerializer<Object> ser = this._serializer;
        if (ser == null && (ser = (map = this._dynamicSerializers).serializerFor(cls = value.getClass())) == null) {
            ser = this._findAndAddDynamic(map, cls, prov);
        }
        if (this._suppressableValue != null) {
            if (MARKER_FOR_EMPTY == this._suppressableValue) {
                if (ser.isEmpty(prov, value)) {
                    this.serializeAsPlaceholder(bean, gen, prov);
                    return;
                }
            } else if (this._suppressableValue.equals(value)) {
                this.serializeAsPlaceholder(bean, gen, prov);
                return;
            }
        }
        if (value == bean && this._handleSelfReference(bean, gen, prov, ser)) {
            return;
        }
        if (this._typeSerializer == null) {
            ser.serialize(value, gen, prov);
        } else {
            ser.serializeWithType(value, gen, prov, this._typeSerializer);
        }
    }
}

