/*
 * Decompiled with CFR 0.152.
 */
package selogger.net.bytebuddy.implementation.bytecode.assign;

import selogger.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import selogger.net.bytebuddy.description.type.TypeDefinition;
import selogger.net.bytebuddy.description.type.TypeDescription;
import selogger.net.bytebuddy.implementation.Implementation;
import selogger.net.bytebuddy.implementation.bytecode.StackManipulation;
import selogger.net.bytebuddy.implementation.bytecode.StackSize;
import selogger.net.bytebuddy.jar.asm.MethodVisitor;
import selogger.net.bytebuddy.utility.nullability.MaybeNull;

@HashCodeAndEqualsPlugin.Enhance
public class TypeCasting
extends StackManipulation.AbstractBase {
    private final TypeDescription typeDescription;

    protected TypeCasting(TypeDescription typeDescription) {
        this.typeDescription = typeDescription;
    }

    public static StackManipulation to(TypeDefinition typeDefinition) {
        if (typeDefinition.isPrimitive()) {
            throw new IllegalArgumentException("Cannot cast to primitive type: " + typeDefinition);
        }
        return new TypeCasting(typeDefinition.asErasure());
    }

    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitTypeInsn(192, this.typeDescription.getInternalName());
        return StackSize.ZERO.toIncreasingSize();
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.typeDescription.equals(((TypeCasting)object).typeDescription);
    }

    public int hashCode() {
        return this.getClass().hashCode() * 31 + this.typeDescription.hashCode();
    }
}

