/*
 * Decompiled with CFR 0.152.
 */
package software.fitz.jackson.module.force;

import selogger.com.fasterxml.jackson.databind.BeanDescription;
import selogger.com.fasterxml.jackson.databind.DeserializationConfig;
import selogger.com.fasterxml.jackson.databind.JsonDeserializer;
import selogger.com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import selogger.com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import selogger.com.fasterxml.jackson.databind.deser.ValueInstantiator;
import selogger.com.fasterxml.jackson.databind.deser.std.MapDeserializer;
import selogger.com.fasterxml.jackson.databind.type.MapType;
import software.fitz.jackson.module.force.ForceMapDeserializer;
import software.fitz.jackson.module.force.ForceValueInstantiator;

class ForceCreatorBeanDeserializerModifier
extends BeanDeserializerModifier {
    private static final ForceCreatorBeanDeserializerModifier INSTANCE = new ForceCreatorBeanDeserializerModifier();

    ForceCreatorBeanDeserializerModifier() {
    }

    public static ForceCreatorBeanDeserializerModifier getInstance() {
        return INSTANCE;
    }

    @Override
    public BeanDeserializerBuilder updateBuilder(DeserializationConfig config, BeanDescription beanDesc, BeanDeserializerBuilder builder) {
        boolean forceCreationTarget;
        ValueInstantiator valueInstantiator = builder.getValueInstantiator();
        Class<?> deserType = beanDesc.getBeanClass();
        boolean bl = forceCreationTarget = !deserType.isPrimitive() && deserType != String.class && beanDesc.findDefaultConstructor() == null && ForceCreatorBeanDeserializerModifier.isNotPossibleInstantiation(valueInstantiator);
        if (forceCreationTarget) {
            builder.setValueInstantiator(ForceValueInstantiator.getInstance(deserType));
        }
        return builder;
    }

    @Override
    public JsonDeserializer<?> modifyMapDeserializer(DeserializationConfig config, MapType type, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
        return new ForceMapDeserializer((MapDeserializer)deserializer);
    }

    private static boolean isNotPossibleInstantiation(ValueInstantiator valueInstantiator) {
        return !valueInstantiator.canCreateUsingDelegate() && !valueInstantiator.canCreateUsingArrayDelegate() && !valueInstantiator.canCreateFromObjectWith();
    }
}

